/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.cmd.ui.launching;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigUtils;
import org.eclipse.statet.ecommons.debug.ui.util.UnterminatedLaunchAlerter;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.cmd.ui.launching.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.r.launching.ui.RErrorLineTracker;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;

@NonNullByDefault
public class RCmdLaunchDelegate
extends LaunchConfigurationDelegate {
    public String showCommandLine(ILaunchConfiguration configuration, String mode, @Nullable ILaunch launch, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        try {
            RunData data = this.getLaunchCommandData(configuration, m);
            String string = data != null ? LaunchUtils.generateCommandLine((List)data.command) : "";
            return string;
        }
        finally {
            m.done();
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor m = LaunchUtils.initProgressMonitor((ILaunchConfiguration)configuration, (IProgressMonitor)monitor, (int)25);
        long timestamp = System.currentTimeMillis();
        try {
            IConsole console;
            Process p;
            if (m.isCanceled()) {
                return;
            }
            RunData data = this.getLaunchCommandData(configuration, m);
            if (data == null || m.isCanceled()) {
                return;
            }
            ProcessBuilder builder = new ProcessBuilder(data.command);
            builder.directory(data.workingDirectory.toLocalFile(0, null));
            builder.redirectErrorStream(configuration.getAttribute("org.eclipse.debug.core.ATTR_MERGE_OUTPUT", false));
            Map<String, String> envp = builder.environment();
            LaunchUtils.configureEnvironment(envp, (ILaunchConfiguration)configuration, (Map)data.rEnvConfig.getEnvironmentsVariables());
            UnterminatedLaunchAlerter.registerLaunchType((String)"org.eclipse.statet.r.launchConfigurations.RCmdTool");
            try {
                p = builder.start();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.RCmd_LaunchDelegate_error_StartingExec, (Throwable)e));
            }
            m.worked(10);
            HashMap<String, String> processAttributes = new HashMap<String, String>();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, "R.cmd");
            String processName = String.valueOf((String)data.command.get(0)) + ' ' + LaunchUtils.createProcessTimestamp((long)timestamp);
            StringBuilder sb = new StringBuilder(200);
            sb.append(LaunchUtils.createLaunchPrefix((ILaunchConfiguration)configuration));
            sb.append(' ').append(data.rEnvConfig.getName());
            sb.append(" : R ").append(data.cmd);
            if (data.resourcePathAbsolute != null) {
                sb.append(' ').append(data.resourcePathAbsolute.toOSString());
            }
            sb.append(" ~ ").append(processName);
            String label = sb.toString();
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)processName, processAttributes);
            if (process == null) {
                p.destroy();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.RCmd_LaunchDelegate_error_ProcessHandle, null));
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, LaunchUtils.generateCommandLine((List)data.command));
            process.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
            m.worked(5);
            if (!process.isTerminated() && !CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
                m.subTask(Messages.RCmd_LaunchDelegate_Running_label);
            }
            if ((console = DebugUITools.getConsole((IProcess)process)) instanceof TextConsole) {
                RErrorLineTracker lineMatcher = new RErrorLineTracker(data.workingDirectory);
                ((TextConsole)console).addPatternMatchListener((IPatternMatchListener)lineMatcher);
            }
            LaunchConfigUtils.launchResourceRefresh((ILaunchConfiguration)configuration, (IProcess)process, (IProgressMonitor)m.newChild(5));
        }
        finally {
            m.done();
        }
    }

    private @Nullable RunData getLaunchCommandData(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        IREnvConfiguration rEnvConfig = RLaunching.getREnvConfig((ILaunchConfiguration)configuration, (boolean)true);
        String cmd = configuration.getAttribute("org.eclipse.statet.r.debug/RCmd/arguments.cmd", "").trim();
        if (!cmd.isEmpty()) {
            command.addAll(Arrays.asList(cmd.split(" ")));
        }
        String arg1 = null;
        if (command.size() > 0) {
            arg1 = (String)command.remove(0);
        }
        command.addAll(0, rEnvConfig.getExecCommand(arg1, EnumSet.of(IREnvConfiguration.Exec.CMD, IREnvConfiguration.Exec.TERM)));
        m.worked(1);
        if (m.isCanceled()) {
            return null;
        }
        IFileStore workingDirectory = REnvTab.getWorkingDirectory((ILaunchConfiguration)configuration);
        m.worked(1);
        if (m.isCanceled()) {
            return null;
        }
        command.addAll(Arrays.asList(LaunchUtils.getProcessArguments((ILaunchConfiguration)configuration, (String)"org.eclipse.statet.r.debug/RCmd/arguments.options")));
        String resourceValue = configuration.getAttribute("org.eclipse.statet.r.debug/RCmd/arguments.resource", "");
        IFileStore resource = null;
        IPath resourcePathAbsolute = null;
        IPath resourcePathAuto = null;
        if (resourceValue.length() > 0) {
            resource = FileUtil.expandToLocalFileStore((String)resourceValue, (IFileStore)workingDirectory, null);
            IPath workingDirectoryPath = (IPath)ObjectUtils.nonNullAssert((Object)URIUtil.toPath((URI)workingDirectory.toURI()));
            if (workingDirectoryPath.isPrefixOf(resourcePathAuto = (resourcePathAbsolute = (IPath)ObjectUtils.nonNullAssert((Object)URIUtil.toPath((URI)resource.toURI()))))) {
                resourcePathAuto = resourcePathAuto.setDevice(null);
                resourcePathAuto = resourcePathAuto.removeFirstSegments(workingDirectoryPath.segmentCount());
            }
            command.add(resourcePathAuto.toString());
        }
        m.worked(1);
        return new RunData(rEnvConfig, cmd, command, workingDirectory, resourcePathAbsolute);
    }

    private static class RunData {
        private final IREnvConfiguration rEnvConfig;
        private final String cmd;
        private final List<String> command;
        private final IFileStore workingDirectory;
        private final @Nullable IPath resourcePathAbsolute;

        public RunData(IREnvConfiguration rEnvConfig, String cmd, List<String> command, IFileStore workingDirectory, @Nullable IPath resourcePathAbsolute) {
            this.rEnvConfig = rEnvConfig;
            this.cmd = cmd;
            this.command = command;
            this.workingDirectory = workingDirectory;
            this.resourcePathAbsolute = resourcePathAbsolute;
        }
    }
}

