/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.views;

import java.util.Collection;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.LocalTaskTransfer;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.util.ToolProgressGroup;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class QueueView
extends ViewPart {
    private Composite composite;
    private ToolProgressGroup progressControl;
    private TableViewer tableViewer;
    private ToolProcess process;
    private WorkbenchToolRegistryListener toolRegistryListener;
    private static final String M_SHOW_DESCRIPTION = "QueueView.ShowDescription";
    private boolean showDescription;
    private Action showDescriptionAction;
    private static final String M_SHOW_PROGRESS = "QueueView.ShowProgress";
    private boolean showProgress;
    private Action showProgressAction;
    private Action selectAllAction;
    private Action deleteAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        String showDescription = memento != null ? memento.getString(M_SHOW_DESCRIPTION) : null;
        this.showDescription = showDescription != null && !showDescription.equals("off");
        String showProgress = memento != null ? memento.getString(M_SHOW_PROGRESS) : null;
        this.showProgress = showProgress == null || showProgress.equals("on");
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(M_SHOW_DESCRIPTION, this.showDescription ? "on" : "off");
        memento.putString(M_SHOW_PROGRESS, this.showProgress ? "on" : "off");
    }

    public void createPartControl(Composite parent) {
        this.updateContentDescription(null);
        this.composite = parent;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.showProgress) {
            this.createProgressControl();
        }
        this.tableViewer = new TableViewer(parent, 514);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(false);
        this.tableViewer.getTable().setHeaderVisible(false);
        new TableColumn(this.tableViewer.getTable(), -1);
        this.tableViewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = QueueView.this.tableViewer.getTable();
                Rectangle area = table.getClientArea();
                TableColumn column = table.getColumn(0);
                column.setWidth(area.width - 3);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.hookDND();
        WorkbenchToolRegistry toolRegistry = NicoUI.getToolRegistry();
        this.connect(toolRegistry.getActiveToolSession(this.getViewSite().getPage()).getTool());
        this.toolRegistryListener = new WorkbenchToolRegistryListener(){

            public void toolSessionActivated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueView.this.connect(tool);
                    }
                });
            }

            public void toolTerminated(WorkbenchToolSessionData sessionData) {
            }
        };
        toolRegistry.addListener(this.toolRegistryListener, this.getViewSite().getPage());
    }

    private void createProgressControl() {
        this.progressControl = new ToolProgressGroup(this.composite);
        this.progressControl.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void updateContentDescription(ToolProcess process) {
        if (this.showDescription) {
            this.setContentDescription(process != null ? process.getLabel(0) : " ");
        } else {
            this.setContentDescription("");
        }
    }

    private void createActions() {
        this.showDescriptionAction = new ShowDescriptionAction();
        this.showProgressAction = new ShowProgressAction();
        this.selectAllAction = new Action(){

            public void run() {
                QueueView.this.tableViewer.getTable().selectAll();
            }
        };
        this.deleteAction = new Action(){

            public void run() {
                Queue queue = QueueView.this.getQueue();
                if (queue != null) {
                    IStructuredSelection selection = (IStructuredSelection)QueueView.this.tableViewer.getSelection();
                    queue.remove((List)ImCollections.toList((Collection)selection.toList()));
                }
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showDescriptionAction);
        manager.add((IAction)this.showProgressAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.nico.commands.PauseEngine", null, null, null, null, null, null, null, 32, null, false)));
    }

    private void hookDND() {
        this.tableViewer.addDragSupport(2, new Transfer[]{LocalTaskTransfer.getTransfer()}, (DragSourceListener)new TableDragSourceEffect(this.tableViewer.getTable()){

            public void dragStart(DragSourceEvent event) {
                event.doit = QueueView.this.tableViewer.getTable().getSelectionCount() > 0;
                LocalTaskTransfer.getTransfer().init(QueueView.this.process);
                super.dragStart(event);
            }

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
                LocalTaskTransfer.Data data = LocalTaskTransfer.getTransfer().createData();
                if (data.process != QueueView.this.process) {
                    event.doit = false;
                    return;
                }
                data.runnables = ImCollections.toList((Collection)((IStructuredSelection)QueueView.this.tableViewer.getSelection()).toList());
                event.data = data;
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                LocalTaskTransfer.getTransfer().finished();
            }
        });
    }

    private void disconnect(final ToolProcess process) {
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueueView.this.process != null && QueueView.this.process == process) {
                    QueueView.this.connect(null);
                }
            }
        });
    }

    private void connect(Tool tool) {
        final ToolProcess process = tool instanceof ToolProcess ? (ToolProcess)tool : null;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!UIAccess.isOkToUse((Viewer)QueueView.this.tableViewer)) {
                    return;
                }
                QueueView.this.process = process;
                QueueView.this.updateContentDescription(process);
                if (QueueView.this.progressControl != null) {
                    QueueView.this.progressControl.setTool(process, true);
                }
                QueueView.this.tableViewer.setInput((Object)process);
            }
        };
        BusyIndicator.showWhile((Display)UIAccess.getDisplay(), (Runnable)runnable);
    }

    public ToolProcess getProcess() {
        return this.process;
    }

    public Queue getQueue() {
        if (this.process != null) {
            return this.process.getQueue();
        }
        return null;
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    private class ShowDescriptionAction
    extends Action {
        public ShowDescriptionAction() {
            this.setText(Messages.ShowToolDescription_name);
            this.setToolTipText(Messages.ShowToolDescription_tooltip);
            this.setChecked(QueueView.this.showDescription);
        }

        public void run() {
            QueueView.this.showDescription = this.isChecked();
            QueueView.this.updateContentDescription(QueueView.this.process);
        }
    }

    private class ShowProgressAction
    extends Action {
        public ShowProgressAction() {
            this.setText(Messages.ShowProgress_name);
            this.setToolTipText(Messages.ShowProgress_tooltip);
            this.setChecked(QueueView.this.showProgress);
        }

        public void run() {
            QueueView.this.showProgress = this.isChecked();
            if (QueueView.this.showProgress) {
                QueueView.this.createProgressControl();
                QueueView.this.progressControl.setTool(QueueView.this.process, true);
                QueueView.this.progressControl.getControl().moveAbove(QueueView.this.tableViewer.getControl());
            } else if (QueueView.this.progressControl != null) {
                QueueView.this.progressControl.getControl().dispose();
                QueueView.this.progressControl = null;
            }
            QueueView.this.composite.layout(true);
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public Image getImage(Object element) {
            return NicoUITools.getImage((ToolRunnable)element);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            return "";
        }

        public String getText(Object element) {
            ToolRunnable runnable = (ToolRunnable)element;
            return runnable.getLabel();
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider,
    IDebugEventSetListener {
        private volatile boolean expectInfoEvent = false;
        private ImList<ToolRunnable> refreshData;

        private ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && newInput == null) {
                this.unregister();
            }
            if (newInput != null) {
                ToolProcess newProcess = (ToolProcess)newInput;
                DebugPlugin manager = DebugPlugin.getDefault();
                if (manager != null) {
                    manager.addDebugEventListener((IDebugEventSetListener)this);
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements;
            if (this.refreshData != null) {
                elements = (ToolRunnable[])this.refreshData.toArray((Object[])new ToolRunnable[this.refreshData.size()]);
                this.refreshData = null;
            } else {
                elements = new ToolRunnable[]{};
                Queue queue = QueueView.this.getQueue();
                if (queue != null) {
                    this.expectInfoEvent = true;
                    queue.sendElements();
                }
            }
            return elements;
        }

        private void unregister() {
            DebugPlugin manager = DebugPlugin.getDefault();
            if (manager != null) {
                manager.removeDebugEventListener((IDebugEventSetListener)this);
            }
        }

        public void dispose() {
            this.unregister();
        }

        private void setElements(final ImList<ToolRunnable> elements) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!UIAccess.isOkToUse((Viewer)QueueView.this.tableViewer)) {
                        return;
                    }
                    ViewContentProvider.this.refreshData = elements;
                    QueueView.this.tableViewer.refresh();
                }
            });
        }

        public void handleDebugEvents(DebugEvent[] events) {
            ToolProgressGroup progress;
            ToolProcess process = QueueView.this.process;
            if (process == null) {
                return;
            }
            boolean updateProgress = false;
            Queue queue = process.getQueue();
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                Object source = event.getSource();
                if (source == queue) {
                    block0 : switch (event.getKind()) {
                        case 16: {
                            if (event.getDetail() != 512) break;
                            final Queue.TaskDelta taskDelta = (Queue.TaskDelta)event.getData();
                            switch (taskDelta.type) {
                                case 272: 
                                case 273: {
                                    DebugEvent next;
                                    if (this.expectInfoEvent) break block0;
                                    if (events.length > i + 1 && taskDelta.data.size() == 1 && (next = events[i + 1]).getSource() == queue && next.getKind() == 16 && next.getDetail() == 512) {
                                        Queue.TaskDelta nextDelta = (Queue.TaskDelta)next.getData();
                                        if (nextDelta.type == 320 && taskDelta.data.get(0) == nextDelta.data.get(0)) {
                                            updateProgress = true;
                                            ++i;
                                            break block0;
                                        }
                                    }
                                    UIAccess.getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!UIAccess.isOkToUse((Viewer)QueueView.this.tableViewer)) {
                                                return;
                                            }
                                            if (taskDelta.position >= 0) {
                                                int j = 0;
                                                while (j < taskDelta.data.size()) {
                                                    QueueView.this.tableViewer.insert(taskDelta.data.get(j), taskDelta.position + j);
                                                    ++j;
                                                }
                                            } else {
                                                QueueView.this.tableViewer.add(taskDelta.data.toArray());
                                            }
                                        }
                                    });
                                    break block0;
                                }
                                case 320: {
                                    updateProgress = true;
                                }
                                case 288: 
                                case 289: {
                                    if (this.expectInfoEvent) break block0;
                                    UIAccess.getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!UIAccess.isOkToUse((Viewer)QueueView.this.tableViewer)) {
                                                return;
                                            }
                                            QueueView.this.tableViewer.remove(taskDelta.data.toArray());
                                        }
                                    });
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 32: {
                            if (event.getDetail() != 1 || !this.expectInfoEvent) break;
                            this.expectInfoEvent = false;
                            this.setElements((ImList<ToolRunnable>)((ImList)event.getData()));
                            break;
                        }
                        case 8: {
                            QueueView.this.disconnect(process);
                            break;
                        }
                    }
                }
                ++i;
            }
            if (updateProgress && QueueView.this.showProgress && (progress = QueueView.this.progressControl) != null) {
                progress.refresh(false);
            }
        }
    }
}

