/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IIndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartition;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class VariablePartitionFactory<T extends IIndexedValue>
extends ElementPartitionFactory<IVariable, T> {
    static DebugException newNotSupported() {
        return new DebugException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", 5011, "Not supported for partitions.", null));
    }

    static DebugException newNotSupported(Throwable cause) {
        return new DebugException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", 5011, "Not supported for partitions.", cause));
    }

    static DebugException newRequestInvalidFailed(Throwable cause) {
        return new DebugException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", 5012, "Request failed.", cause));
    }

    public VariablePartitionFactory() {
        super(IVariable.class, 100);
    }

    public IVariable[] getVariables(T value) throws DebugException {
        try {
            return (IVariable[])this.getElements(value, value.getSize());
        }
        catch (UnsupportedOperationException e) {
            throw VariablePartitionFactory.newNotSupported(e);
        }
        catch (IllegalArgumentException e) {
            throw VariablePartitionFactory.newRequestInvalidFailed(e);
        }
    }

    protected IVariable createPartition(T value, ElementPartitionFactory.PartitionHandle partition) {
        return new VariablePartition<T>(value, partition);
    }

    protected IVariable[] getChildren(T value, long start, int length) {
        return value.getVariables(start, length);
    }
}

