/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences;

import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;

public class PreferencesManageListener
implements SettingsChangeNotifier.ManageListener {
    private AbstractPreferencesModelObject fModel;
    private PreferenceAccess fPrefAccess;
    private final String[] fGroupIds;

    public PreferencesManageListener(AbstractPreferencesModelObject model, PreferenceAccess prefs, String groupId) {
        this(model, prefs, new String[]{groupId});
    }

    public PreferencesManageListener(AbstractPreferencesModelObject model, PreferenceAccess prefs, String[] groupIds) {
        this.fModel = model;
        this.fPrefAccess = prefs;
        this.fGroupIds = groupIds;
        Lock lock = this.fModel.getWriteLock();
        lock.lock();
        try {
            PreferencesUtil.getSettingsChangeNotifier().addManageListener(this);
            this.fModel.load(this.fPrefAccess);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void beforeSettingsChangeNotification(Set<String> groupIds) {
        String[] stringArray = this.fGroupIds;
        int n = this.fGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (groupIds.contains(id)) {
                Lock lock = this.fModel.getWriteLock();
                lock.lock();
                try {
                    this.fModel.load(this.fPrefAccess);
                }
                finally {
                    lock.unlock();
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public void afterSettingsChangeNotification(Set<String> groupIds) {
        this.fModel.resetDirty();
    }

    public void dispose() {
        PreferencesUtil.getSettingsChangeNotifier().removeManageListener(this);
        this.fModel = null;
        this.fPrefAccess = null;
    }
}

