/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockWithNestedBlocks;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class SourceBlockNode<TType extends SourceBlockType> {
    private final TType type;
    private final @Nullable SourceBlockNode<?> parent;
    private final List<SourceBlockNode<?>> nested;
    private ImList<Line> lines;

    public SourceBlockNode(TType type, SourceBlocks.SourceBlockBuilder builder) {
        this.type = type;
        this.parent = builder.getParentNode();
        Object object = this.nested = type instanceof BlockWithNestedBlocks ? new ArrayList() : ImCollections.emptyList();
        if (this.parent != null) {
            this.parent.nested.add(this);
        }
        builder.beginNode(this);
    }

    public TType getType() {
        return this.type;
    }

    public @Nullable SourceBlockNode<?> getParent() {
        return this.parent;
    }

    public List<SourceBlockNode<?>> getNested() {
        return this.nested;
    }

    public ImList<Line> getLines() {
        return this.lines;
    }

    void setLines(ImList<Line> lines) {
        this.lines = lines;
    }

    public boolean isParagraph() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SourceBlock");
        sb.append(" type= ").append(this.type);
        sb.append(" (num nested= ").append(this.nested.size()).append(")");
        if (this.lines != null) {
            sb.append("\n").append(this.lines.toString());
        }
        return sb.toString();
    }
}

