/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

public class NetworkServerControl {
    public static final int DEFAULT_PORTNUMBER = 1527;
    private static final String DERBYNET_JAR = "derbynet.jar";
    private static final String DERBY_HOSTNAME_WILDCARD = "0.0.0.0";
    private static final String IPV6_HOSTNAME_WILDCARD = "::";
    private static final String SOCKET_PERMISSION_HOSTNAME_WILDCARD = "*";
    private NetworkServerControlImpl serverImpl;

    public NetworkServerControl(InetAddress address, int portNumber, String userName, String password) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(address, portNumber, userName, password);
    }

    public NetworkServerControl(String userName, String password) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(userName, password);
    }

    public NetworkServerControl(InetAddress address, int portNumber) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(address, portNumber);
    }

    public NetworkServerControl() throws Exception {
        this.serverImpl = new NetworkServerControlImpl();
    }

    public static void main(String[] args) {
        NetworkServerControlImpl server = null;
        boolean printErrors = true;
        try {
            server = new NetworkServerControlImpl();
            int command = server.parseArgs(args);
            if (command == 0) {
                try {
                    System.setProperty("derby.__serverStartedFromCmdLine", "true");
                }
                catch (Exception e) {
                    server.consoleExceptionPrintTrace(e);
                    System.exit(1);
                }
            }
            printErrors = false;
            server.executeWork(command);
        }
        catch (Exception e) {
            if (e.getMessage() == null || !e.getMessage().equals("Unexpected exception") || printErrors) {
                if (server != null) {
                    server.consoleExceptionPrint(e);
                } else {
                    e.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public void start(PrintWriter consoleWriter) throws Exception {
        this.serverImpl.start(consoleWriter);
    }

    public void shutdown() throws Exception {
        this.serverImpl.shutdown();
    }

    public void ping() throws Exception {
        this.serverImpl.ping();
    }

    public void trace(boolean on) throws Exception {
        this.serverImpl.trace(on);
    }

    public void trace(int connNum, boolean on) throws Exception {
        this.serverImpl.trace(connNum, on);
    }

    public void logConnections(boolean on) throws Exception {
        this.serverImpl.logConnections(on);
    }

    public void setTraceDirectory(String traceDirectory) throws Exception {
        this.serverImpl.sendSetTraceDirectory(traceDirectory);
    }

    public String getSysinfo() throws Exception {
        return this.serverImpl.sysinfo();
    }

    public String getRuntimeInfo() throws Exception {
        return this.serverImpl.runtimeInfo();
    }

    public void setMaxThreads(int max) throws Exception {
        this.serverImpl.netSetMaxThreads(max);
    }

    public int getMaxThreads() throws Exception {
        String val = this.serverImpl.getCurrentProperties().getProperty("derby.drda.maxThreads");
        return Integer.parseInt(val);
    }

    public void setTimeSlice(int timeslice) throws Exception {
        this.serverImpl.netSetTimeSlice(timeslice);
    }

    public int getTimeSlice() throws Exception {
        String val = this.serverImpl.getCurrentProperties().getProperty("derby.drda.timeSlice");
        return Integer.parseInt(val);
    }

    public Properties getCurrentProperties() throws Exception {
        return this.serverImpl.getCurrentProperties();
    }

    protected void setClientLocale(String locale) {
        this.serverImpl.setClientLocale(locale);
    }

    private static boolean hostnamesEqual(String left, String right) {
        try {
            InetAddress leftAddress = InetAddress.getByName(left);
            InetAddress rightAddress = InetAddress.getByName(right);
            return leftAddress.equals(rightAddress);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isIPV6Address(String hostname) {
        if (hostname == null) {
            return false;
        }
        int count = hostname.length();
        for (int i = 0; i < count; ++i) {
            char currentChar = hostname.charAt(i);
            if (currentChar == ':' || Character.digit(currentChar, 16) >= 0) continue;
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(hostname);
            return address instanceof Inet6Address;
        }
        catch (Exception e) {
            return false;
        }
    }
}

