/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui;

import java.net.URL;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.swt.SWT;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class AdvancedExtensionsInternal {
    public static final String CONTENTASSIST_EXTENSIONPOINT_ID = "org.eclipse.statet.ltk.AdvancedContentAssist";
    public static final String INFOHOVER_EXTENSIONPOINT_ID = "org.eclipse.statet.ltk.AdvancedInfoHover";
    public static final String CONFIG_ID_ATTRIBUTE_NAME = "id";
    public static final String CONFIG_NAME_ATTRIBUTE_NAME = "name";
    public static final String CONFIG_CONTENT_TYPE_ID_ATTRIBUTE_NAME = "contentTypeId";
    public static final String CONFIG_CATEGORY_ID_ATTRIBUTE_NAME = "categoryId";
    public static final String CONFIG_PARTITION_ELEMENT_NAME = "partition";
    public static final String CONFIG_COMPUTER_ELEMENT_NAME = "computer";
    public static final String CONFIG_CATEGORY_ELEMENT_NAME = "category";
    public static final String CONFIG_CONTENTTYPE_ID_ELEMENT_NAME = "partitionType";
    public static final String CONFIG_CLASS_ATTRIBUTE_NAME = "class";
    public static final String CONFIG_ICON_ATTRIBUTE_NAME = "icon";
    private static final Pattern MODIFIERS_PATTERN = Pattern.compile("\\s*\\+\\s*");

    public static final String getCheckedString(IConfigurationElement element, String attrName) throws CoreException {
        String s = element.getAttribute(attrName);
        if (s == null || s.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)"missing value for attribute ''{0}''", (Object)attrName), null));
        }
        return s;
    }

    public static final @Nullable ImageDescriptor getImageDescriptor(IConfigurationElement element, String attrName) throws CoreException {
        Bundle bundle;
        URL url;
        String imagePath = element.getAttribute(attrName);
        if (imagePath != null && (url = FileLocator.find((Bundle)(bundle = ContentAssistComputerRegistry.getBundle(element)), (IPath)new Path(imagePath), null)) != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public static int computeStateMask(@Nullable String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.isEmpty()) {
            return 0;
        }
        String[] mods = MODIFIERS_PATTERN.split(modifiers);
        int stateMask = 0;
        String[] stringArray = mods;
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            String modifier = stringArray[n2];
            switch (key = modifier.toUpperCase(Locale.ROOT)) {
                case "CTRL": {
                    stateMask |= 0x40000;
                    break;
                }
                case "ALT": {
                    stateMask |= 0x10000;
                    break;
                }
                case "SHIFT": {
                    stateMask |= 0x20000;
                    break;
                }
                case "COMMAND": {
                    stateMask |= 0x400000;
                    break;
                }
                case "M1": {
                    stateMask |= SWT.MOD1;
                    break;
                }
                case "M2": {
                    stateMask |= SWT.MOD2;
                    break;
                }
                case "M3": {
                    stateMask |= SWT.MOD3;
                    break;
                }
                case "M4": {
                    stateMask |= SWT.MOD4;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++n2;
        }
        return stateMask;
    }

    public static String createUnifiedStateMaskString(int stateMask) {
        if (stateMask != 0) {
            StringBuilder sb = new StringBuilder();
            if ((stateMask & SWT.MOD1) == SWT.MOD1) {
                sb.append("M1+");
            }
            if ((stateMask & SWT.MOD2) == SWT.MOD2) {
                sb.append("M2+");
            }
            if ((stateMask & SWT.MOD3) == SWT.MOD3) {
                sb.append("M3+");
            }
            if (SWT.MOD4 != 0 && (stateMask & SWT.MOD4) == SWT.MOD4) {
                sb.append("M4+");
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 1);
            }
        }
        return "";
    }
}

