/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt.util;

import java.util.function.IntFunction;
import org.eclipse.statet.jcommons.collections.IntHashMap;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class ColorCache {
    private static final IntFunction<Color> NEW_COLOR_FROM_RGB = new IntFunction<Color>(){

        @Override
        public Color apply(int rgb) {
            return new Color(rgb & 0xFF, rgb >>> 8 & 0xFF, rgb >>> 16 & 0xFF);
        }
    };
    private final IntHashMap<Color> persistentRGBMap = new IntHashMap(2048);
    private final IntHashMap<Color> tempRGBMap = new IntHashMap(2048);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Color get(int rgb) {
        IntHashMap<Color> intHashMap = this.persistentRGBMap;
        synchronized (intHashMap) {
            return (Color)this.persistentRGBMap.computeIfAbsent(rgb, NEW_COLOR_FROM_RGB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Color get(ColorDef def) {
        IntHashMap<Color> intHashMap = this.persistentRGBMap;
        synchronized (intHashMap) {
            return (Color)this.persistentRGBMap.computeIfAbsent(def.getRGB(), NEW_COLOR_FROM_RGB);
        }
    }

    public final Color get(int red, int green, int blue) {
        return this.get(red | green << 8 | blue << 16);
    }

    public final Color get(RGB def) {
        return this.get(def.red | def.green << 8 | def.blue << 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Color getTemp(int rgb) {
        Color color;
        IntHashMap<Color> intHashMap = this.persistentRGBMap;
        synchronized (intHashMap) {
            color = (Color)this.persistentRGBMap.get(rgb);
        }
        if (color != null) {
            return color;
        }
        intHashMap = this.tempRGBMap;
        synchronized (intHashMap) {
            if (this.tempRGBMap.size() > 1024) {
                color = (Color)this.tempRGBMap.get(rgb);
                this.tempRGBMap.clear();
                if (color != null) {
                    this.tempRGBMap.put(rgb, (Object)color);
                    return color;
                }
            }
            return (Color)this.tempRGBMap.computeIfAbsent(rgb, NEW_COLOR_FROM_RGB);
        }
    }

    public final Color getTemp(ColorDef def) {
        return this.getTemp(def.getRGB());
    }

    public final Color getTemp(int red, int green, int blue) {
        return this.getTemp(red | green << 8 | blue << 16);
    }

    public final Color getTemp(RGB def) {
        return this.getTemp(def.red | def.green << 8 | def.blue << 16);
    }
}

