/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.ecommons.ui.swt.util.ArrowImageDataProvider;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

@NonNullByDefault
public class DropDownButton
extends Composite {
    private @Nullable Button mainButton;
    private @Nullable Region mainButtonRegion;
    private Button downButton;
    private ArrowImageDataProvider arrowImageData;
    private @Nullable Image image;
    private @Nullable Image disabledImage;
    private int sizeZoom = -1;
    private Point imageButtonDefaultSize;
    private String arrowText;
    private @Nullable Menu menu;
    private final CopyOnWriteIdentityListSet<MenuListener> menuListeners = new CopyOnWriteIdentityListSet();

    public DropDownButton(Composite parent, int style) {
        super(parent, 0);
        this.create(style);
    }

    public DropDownButton(Composite parent) {
        this(parent, 0);
    }

    private void create(int style) {
        boolean single = (style & 4) != 0;
        int buttonStyle = style & 0xFFFFFFFB;
        this.downButton = new Button((Composite)this, 8 | buttonStyle);
        this.updateSizes(true);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = DropDownButton.this.getDropDownMenu();
                MenuUtils.setPullDownPosition(menu, (Control)DropDownButton.this);
                menu.setVisible(true);
            }
        });
        if (single) {
            this.setTabList(new Control[]{this.downButton});
        } else {
            Button mainButton;
            this.mainButton = mainButton = new Button((Composite)this, 8 | buttonStyle);
            this.setTabList(new Control[]{mainButton, this.downButton});
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        DropDownButton.this.onDisposed();
                        return;
                    }
                    case 11: 
                    case 55: {
                        DropDownButton.this.updateBounds(event);
                        return;
                    }
                    case 9: {
                        DropDownButton.this.paintButton(event);
                        return;
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.getShell().addListener(55, listener);
        this.downButton.addListener(9, listener);
    }

    protected void onDisposed() {
        this.disabledImage = null;
        this.image = null;
        this.mainButtonRegion = SwtUtils.dispose(this.mainButtonRegion);
        this.menu = SwtUtils.dispose(this.menu);
    }

    private void updateSizes(boolean force) {
        int zoom = this.getShell().getMonitor().getZoom();
        if (!force && zoom == this.sizeZoom) {
            return;
        }
        this.sizeZoom = zoom;
        Image image = this.getImage();
        int imageWidth = image.getBounds().width;
        Button button = new Button((Composite)this, 8);
        button.setImage(image);
        button.setFont(this.getFont());
        this.imageButtonDefaultSize = button.computeSize(-1, -1);
        button.dispose();
        if (this.mainButton == null) {
            GC gc = new GC((Drawable)this);
            try {
                int requiredWidth = imageWidth + (this.imageButtonDefaultSize.x - imageWidth + 1) / 2;
                Object text = " ";
                int i = 1;
                while (i < 10) {
                    if (gc.stringExtent((String)text).x >= requiredWidth) break;
                    text = (String)text + " ";
                    ++i;
                }
                this.arrowText = text;
            }
            finally {
                gc.dispose();
            }
        }
    }

    private void updateBounds(Event event) {
        this.updateSizes(false);
        Rectangle clientArea = this.getClientArea();
        Button mainButton = this.mainButton;
        if (mainButton != null) {
            int downButtonWidth = this.imageButtonDefaultSize.x;
            mainButton.setBounds(clientArea.x, clientArea.y, clientArea.width - 6, clientArea.height);
            Region region = new Region((Device)this.getDisplay());
            region.add(0, 0, clientArea.width - downButtonWidth + 1, clientArea.height);
            mainButton.setRegion(region);
            SwtUtils.dispose(this.mainButtonRegion);
            this.mainButtonRegion = region;
            this.downButton.setBounds(clientArea.x + clientArea.width - downButtonWidth, clientArea.y, downButtonWidth, clientArea.height);
        } else {
            this.downButton.setBounds(clientArea);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        Button mainButton = this.mainButton;
        if (mainButton != null) {
            downSize = this.downButton.computeSize(this.imageButtonDefaultSize.x, hHint);
            Point mainSize = wHint == -1 ? mainButton.computeSize(-1, hHint) : mainButton.computeSize(Math.max(0, wHint - downSize.x), hHint);
            width = mainSize.x + downSize.x - 1;
            height = Math.max(mainSize.y, downSize.y);
        } else {
            downSize = this.downButton.computeSize(wHint, hHint);
            width = downSize.x;
            height = downSize.y;
        }
        Rectangle trim = super.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    private Image getImage() {
        Image image = this.image;
        RGB foregroundColor = ArrowImageDataProvider.computeDefaultForegroundColor(this.downButton.getForeground(), this.downButton.getBackground());
        if (image != null && !this.arrowImageData.getForegroundColor().equals((Object)foregroundColor)) {
            this.disabledImage = null;
            image = null;
            this.image = null;
        }
        if (image == null) {
            this.arrowImageData = new ArrowImageDataProvider(1024, foregroundColor);
            this.image = image = SharedUIResources.getInstance().getImageDescriptorRegistry().getRequired(ImageDescriptor.createFromImageDataProvider((ImageDataProvider)this.arrowImageData));
        }
        return image;
    }

    private @Nullable Image getDisabledImage() {
        Image image = this.disabledImage;
        if (image == null) {
            this.disabledImage = image = SharedUIResources.getInstance().getImageDescriptorRegistry().get(ImageDescriptor.createWithFlags((ImageDescriptor)ImageDescriptor.createFromImage((Image)this.getImage()), (int)1));
        }
        return image;
    }

    private void paintButton(Event event) {
        Image image;
        Point buttonSize = this.downButton.getSize();
        Image image2 = image = this.downButton.isEnabled() ? this.getImage() : this.getDisabledImage();
        if (image == null) {
            return;
        }
        event.gc.drawImage(image, this.mainButton != null ? (buttonSize.x - image.getBounds().width) / 2 : buttonSize.x - this.imageButtonDefaultSize.x + (this.imageButtonDefaultSize.x - image.getBounds().width) / 2, (buttonSize.y - image.getBounds().height) / 2);
    }

    public void setFont(@Nullable Font font) {
        super.setFont(font);
        this.updateSizes(true);
    }

    public void setEnabled(boolean enabled) {
        Button mainButton = this.mainButton;
        if (mainButton != null) {
            mainButton.setEnabled(enabled);
        }
        this.downButton.setEnabled(enabled);
    }

    public void setText(String string) {
        Button mainButton = this.mainButton;
        if (mainButton != null) {
            mainButton.setText(string);
        } else {
            this.downButton.setText(string + this.arrowText);
        }
    }

    public void setToolTipText(@Nullable String string) {
        Button mainButton = this.mainButton;
        if (mainButton != null) {
            mainButton.setToolTipText(string);
        } else {
            this.downButton.setToolTipText(string);
        }
    }

    public void setOptionToolTipText(String string) {
        this.downButton.setToolTipText(string);
    }

    public void addSelectionListener(SelectionListener listener) {
        Button mainButton = this.mainButton;
        if (mainButton == null) {
            throw new UnsupportedOperationException();
        }
        mainButton.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        Button mainButton = this.mainButton;
        if (mainButton == null) {
            throw new UnsupportedOperationException();
        }
        mainButton.removeSelectionListener(listener);
    }

    public void addMenuListener(MenuListener listener) {
        this.menuListeners.add((Object)((MenuListener)ObjectUtils.nonNullAssert((Object)listener)));
        if (this.menu != null) {
            this.menuListeners.add((Object)listener);
        }
    }

    public void removeMenuListener(MenuListener listener) {
        this.menuListeners.remove((Object)listener);
        if (this.menu != null) {
            this.menuListeners.remove((Object)listener);
        }
    }

    public Menu getDropDownMenu() {
        Menu menu = this.menu;
        if (menu == null) {
            menu = this.createDropDownMenu();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            if (DropDownButton.this.menu == event.widget) {
                                DropDownButton.this.menu = null;
                            }
                            return;
                        }
                    }
                }
            };
            menu.addListener(12, listener);
            for (MenuListener menuListener : this.menuListeners) {
                menu.addMenuListener(menuListener);
            }
            this.menu = menu;
        }
        return menu;
    }

    protected Menu createDropDownMenu() {
        return new Menu((Control)this);
    }
}

