/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.statet.internal.rj.servi.MXNetConfig;
import org.eclipse.statet.internal.rj.servi.MXNodeConfig;
import org.eclipse.statet.internal.rj.servi.MXNodeManager;
import org.eclipse.statet.internal.rj.servi.MXPoolConfig;
import org.eclipse.statet.internal.rj.servi.MXPoolStatus;
import org.eclipse.statet.internal.rj.servi.MXUtils;
import org.eclipse.statet.internal.rj.servi.PoolManager;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.rmi.RMIRegistryManager;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.servi.RServiUtils;
import org.eclipse.statet.rj.servi.jmx.PoolServerMXBean;
import org.eclipse.statet.rj.servi.jmx.PoolStatusMX;
import org.eclipse.statet.rj.servi.node.RServiImpl;
import org.eclipse.statet.rj.servi.node.RServiNodeConfig;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.pool.NetConfig;
import org.eclipse.statet.rj.servi.pool.PoolConfig;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class JMPoolServer
implements PoolServer,
PoolServerMXBean {
    private static final byte DOWN = 0;
    private static final byte READY = 1;
    private final String id;
    private final RJContext context;
    private volatile byte state;
    private final LifetimeController lifetimeController;
    private final String jmBaseName;
    private @Nullable ObjectName jmxName;
    private final Set<Integer> rmiEmbeddedPorts = new HashSet<Integer>();
    private @Nullable RMIRegistry rmiRegistry;
    private boolean rmiHostnameSet;
    private @Nullable String poolAddress;
    private final MXNetConfig currentNetConfig;
    private volatile PoolConfig currentPoolConfig;
    private volatile RServiNodeConfig currentNodeConfig;
    private final MXNetConfig jmNetConfig;
    private final MXPoolConfig jmPoolConfig;
    private final MXNodeConfig jmNodeConfig;
    private volatile boolean jmIsNodeManagementEnabled;
    private @Nullable MXNodeManager jmNodeManager;
    private final RServiNodeFactory nodeFactory;
    private @Nullable PoolManager poolManager;

    public JMPoolServer(String id, RJContext context) throws RjInitFailedException {
        this(id, context, true);
    }

    public JMPoolServer(String id, RJContext context, boolean enableJM) throws RjInitFailedException {
        this.id = id;
        this.context = context;
        this.jmBaseName = "RServi:rservi.id=" + this.getId() + ",";
        this.currentNetConfig = (MXNetConfig)MXUtils.loadInit(new MXNetConfig(this), this.context);
        this.currentPoolConfig = (PoolConfig)MXUtils.loadInit(new PoolConfig(), this.context);
        this.currentNodeConfig = (RServiNodeConfig)MXUtils.loadInit(new RServiNodeConfig(), this.context);
        try {
            this.nodeFactory = RServiImpl.createLocalNodeFactory(this.id, this.context);
        }
        catch (RjInvalidConfigurationException e) {
            throw new RjInitFailedException("Creating local R node factory failed.", (Throwable)e);
        }
        try {
            if (enableJM) {
                this.jmxName = new ObjectName(this.jmBaseName + "type=Server");
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.jmxName);
            }
            this.jmNetConfig = this.currentNetConfig;
            if (enableJM) {
                this.jmNetConfig.initJM();
            }
            this.jmPoolConfig = new MXPoolConfig(this);
            this.jmPoolConfig.load(this.currentPoolConfig);
            if (enableJM) {
                this.jmPoolConfig.initJM();
            }
            this.jmNodeConfig = new MXNodeConfig(this);
            this.jmNodeConfig.load(this.currentNodeConfig);
            if (enableJM) {
                this.jmNodeConfig.initJM();
            }
            this.state = 1;
            this.lifetimeController = new LifetimeController();
            this.lifetimeController.start();
        }
        catch (Exception e) {
            try {
                this.disposeServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RjInitFailedException("Initializing JMX for pool server failed.", (Throwable)e);
        }
        try {
            this.nodeFactory.setConfig(this.currentNodeConfig);
        }
        catch (RjInvalidConfigurationException e) {
            this.logWarning("Setting the initial R node config failed.", e);
        }
    }

    private void disposeServer() {
        try {
            try {
                if (this.jmPoolConfig != null) {
                    this.jmPoolConfig.disposeJM();
                }
                if (this.jmNetConfig != null) {
                    this.jmNetConfig.disposeJM();
                }
                if (this.jmNodeConfig != null) {
                    this.jmNodeConfig.disposeJM();
                }
                if (this.jmxName != null) {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.jmxName);
                    this.jmxName = null;
                }
            }
            catch (Exception e) {
                this.logError("An error occured when disposing JMX for pool server.", e);
                this.state = 0;
            }
        }
        finally {
            this.state = 0;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RJContext getRJContext() {
        return this.context;
    }

    @Override
    public String getJMBaseName() {
        return this.jmBaseName;
    }

    @Override
    public void getNetConfig(NetConfig config) {
        config.load(this.currentNetConfig);
    }

    @Override
    public void setNetConfig(NetConfig config) {
        if (!(config = new NetConfig(config)).validate(null)) {
            throw new IllegalArgumentException();
        }
        this.currentNetConfig.load(config);
    }

    @Override
    public void getPoolConfig(PoolConfig config) {
        config.load(this.currentPoolConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolConfig(PoolConfig config) {
        if (!(config = new PoolConfig(config)).validate(null)) {
            throw new IllegalArgumentException();
        }
        MXPoolConfig mXPoolConfig = this.jmPoolConfig;
        synchronized (mXPoolConfig) {
            PoolManager manager = this.poolManager;
            if (manager != null) {
                manager.setConfig(config);
            }
            this.currentPoolConfig = config;
            this.jmPoolConfig.load(config);
        }
    }

    @Override
    public void getNodeConfig(RServiNodeConfig config) {
        config.load(this.currentNodeConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNodeConfig(RServiNodeConfig config) throws RjInvalidConfigurationException {
        if (!(config = new RServiNodeConfig(config)).validate(null)) {
            throw new IllegalArgumentException();
        }
        MXPoolConfig mXPoolConfig = this.jmPoolConfig;
        synchronized (mXPoolConfig) {
            this.nodeFactory.setConfig(config);
            this.currentNodeConfig = config;
            this.jmNodeConfig.load(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRMI() throws RjException, OperationsException {
        Registry registry;
        RMIAddress rmiRegistryAddress;
        boolean ssl;
        boolean embed;
        int registryPort;
        String hostAddress;
        MXNetConfig mXNetConfig = this.currentNetConfig;
        synchronized (mXNetConfig) {
            if (!MXUtils.validate(this.currentNetConfig)) {
                return;
            }
            hostAddress = (String)ObjectUtils.nonNullAssert((Object)this.currentNetConfig.getEffectiveHostAddress());
            registryPort = this.currentNetConfig.getEffectiveRegistryPort();
            embed = this.currentNetConfig.getRegistryEmbed();
            ssl = this.currentNetConfig.isSSLEnabled();
        }
        this.rmiRegistry = null;
        this.nodeFactory.setRegistry(null);
        this.poolAddress = null;
        if (System.getProperty("java.rmi.server.codebase") == null) {
            try {
                List bundles = this.context.resolveBundles((List)ImCollections.newList((Object[])new BundleSpec[]{ServerUtils.RJ_SERVER_SPEC, RServiUtils.RJ_SERVI_SPEC}));
                System.setProperty("java.rmi.server.codebase", ServerUtils.concatCodebase((Collection)bundles));
            }
            catch (StatusException e) {
                throw new RjInvalidConfigurationException("Can not resolve bundles for Java codebase of server.", (Throwable)e);
            }
        }
        if (this.rmiHostnameSet || System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", hostAddress);
            this.rmiHostnameSet = true;
        }
        try {
            rmiRegistryAddress = new RMIAddress(hostAddress, registryPort, null);
            SslRMIClientSocketFactory csf = ssl ? new SslRMIClientSocketFactory() : null;
            registry = LocateRegistry.getRegistry(null, registryPort, csf);
        }
        catch (IllegalArgumentException | UnknownHostException e) {
            throw new RjInvalidConfigurationException("Invalid RMI address.", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new RjInitFailedException("Failed to reference local registry.", (Throwable)e);
        }
        RMIRegistry rmiRegistry = null;
        if (embed) {
            try {
                rmiRegistry = new RMIRegistry(rmiRegistryAddress, registry, true);
                if (this.rmiEmbeddedPorts.add(registryPort)) {
                    this.logWarning(String.format("Found running RMI registry at port %1$s, embedded RMI registry will not be started.", registryPort));
                }
            }
            catch (RemoteException e) {
                RMIRegistryManager.INSTANCE.setEmbeddedPrivateMode(false, ssl);
                RMIRegistryManager.INSTANCE.setEmbeddedPrivatePort(registryPort);
                try {
                    rmiRegistry = RMIRegistryManager.INSTANCE.getEmbeddedPrivateRegistry((ProgressMonitor)new NullProgressMonitor());
                    this.logInfo(String.format("Embedded RMI registry at port %1$s started.", registryPort));
                }
                catch (StatusException ee) {
                    this.logError(String.format("Failed to start embedded RMI registry at port %1$s.", registryPort), ee);
                }
            }
        } else {
            try {
                rmiRegistry = new RMIRegistry(rmiRegistryAddress, registry, true);
                this.logInfo(String.format("Found running RMI registry at port %1$s.", registryPort));
            }
            catch (RemoteException e) {
                this.logError(String.format("Failed to connect to RMI registry at port %1$s.", registryPort), e);
                throw new RjInitFailedException("Initalization of RMI registry setup failed.");
            }
        }
        this.rmiRegistry = rmiRegistry;
        this.nodeFactory.setRegistry(rmiRegistry);
        this.poolAddress = NetConfig.getPoolAddress(hostAddress, registryPort, this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startManager() throws RjException {
        PoolManager poolManager = new PoolManager(this.id, this.rmiRegistry);
        MXPoolConfig mXPoolConfig = this.jmPoolConfig;
        synchronized (mXPoolConfig) {
            poolManager.setConfig(this.currentPoolConfig);
            poolManager.addNodeFactory(this.nodeFactory);
            poolManager.init();
            this.poolManager = poolManager;
        }
        MXNodeManager jmNodeManager = null;
        if (this.jmIsNodeManagementEnabled) {
            jmNodeManager = new MXNodeManager(this, poolManager);
            jmNodeManager.activate();
        }
        this.jmNodeManager = jmNodeManager;
    }

    private void stopManager() {
        PoolManager poolManager = this.poolManager;
        this.poolManager = null;
        if (poolManager != null && poolManager.isInitialized()) {
            try {
                try {
                    poolManager.stop(0);
                }
                catch (RjException e) {
                    this.logError("An error occured when stopping the pool manager.", e);
                    if (this.lifetimeController != null) {
                        this.lifetimeController.add(poolManager);
                    }
                }
            }
            finally {
                if (this.lifetimeController != null) {
                    this.lifetimeController.add(poolManager);
                }
            }
        }
    }

    @Override
    public @Nullable PoolManager getManager() {
        return this.poolManager;
    }

    @Override
    public @Nullable String getPoolAddress() {
        return this.poolAddress;
    }

    @Override
    public PoolStatusMX getPoolStatus() {
        return new MXPoolStatus(this);
    }

    @Override
    public boolean isPoolNodeManagementEnabled() {
        return this.jmIsNodeManagementEnabled;
    }

    @Override
    public synchronized void setPoolNodeManagementEnabled(boolean enable) {
        if (this.jmIsNodeManagementEnabled == enable) {
            return;
        }
        this.jmIsNodeManagementEnabled = enable;
        MXNodeManager jmNodeManager = this.jmNodeManager;
        if (enable) {
            if (jmNodeManager == null) {
                PoolManager poolManager = this.poolManager;
                if (poolManager == null) {
                    return;
                }
                this.jmNodeManager = jmNodeManager = new MXNodeManager(this, poolManager);
            }
            jmNodeManager.activate();
        } else if (jmNodeManager != null) {
            jmNodeManager.deactivate();
        }
    }

    @Override
    public synchronized void start() throws OperationsException {
        if (this.state == 0) {
            throw new OperationsException("RServi pool server is shut down.");
        }
        try {
            PoolManager poolManager = this.poolManager;
            if (poolManager != null) {
                return;
            }
            this.initRMI();
            this.startManager();
        }
        catch (RjException e) {
            this.logError("Failed to start RServi pool server.", e);
            throw new OperationsException("Failed to start RServi pool server: " + e.getMessage());
        }
    }

    @Override
    public synchronized void stop() throws OperationsException {
        this.stopManager();
    }

    @Override
    public synchronized void restart() throws OperationsException {
        this.stop();
        this.start();
    }

    public synchronized void shutdown() {
        if (this.state == 0) {
            return;
        }
        this.stopManager();
        this.disposeServer();
    }

    public void waitForDisposal(long timeoutMillis) throws InterruptedException {
        if (this.lifetimeController != null) {
            this.lifetimeController.join(timeoutMillis);
        }
    }

    private void log(byte severity, String mainMessage, @Nullable Throwable e) {
        ObjectUtils.ToStringBuilder message = new ObjectUtils.ToStringBuilder(mainMessage);
        message.addProp("poolId", this.id);
        CommonsRuntime.log((Status)Status.newStatus((int)severity, (String)"org.eclipse.statet.rj.servi", (String)message.toString(), (Throwable)e));
    }

    private void logInfo(String mainMessage) {
        this.log((byte)1, mainMessage, null);
    }

    private void logWarning(String mainMessage, Throwable e) {
        this.log((byte)2, mainMessage, e);
    }

    private void logWarning(String mainMessage) {
        this.log((byte)2, mainMessage, null);
    }

    private void logError(String mainMessage, Throwable e) {
        this.log((byte)4, mainMessage, e);
    }

    private class LifetimeController
    extends Thread
    implements Disposable {
        private final CopyOnWriteIdentityListSet<PoolManager> stoppedPoolManagers;

        public LifetimeController() {
            super(String.format("RServiPool(%1$s)-KeepAlive", JMPoolServer.this.id));
            this.stoppedPoolManagers = new CopyOnWriteIdentityListSet();
            this.setDaemon(false);
            this.setPriority(4);
            CommonsRuntime.getEnvironment().addStoppingListener((Disposable)this);
        }

        public void add(PoolManager poolManager) {
            this.stoppedPoolManagers.add((Object)poolManager);
        }

        private int checkManagers() {
            int count = 0;
            for (PoolManager manager : this.stoppedPoolManagers) {
                if (manager.isStopped()) {
                    this.stoppedPoolManagers.remove((Object)manager);
                    continue;
                }
                ++count;
            }
            return count;
        }

        @Override
        public void run() {
            boolean alive = true;
            while (alive) {
                byte state = JMPoolServer.this.state;
                int managers = this.checkManagers();
                alive = state != 0 || managers != 0;
                try {
                    LifetimeController.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void dispose() {
            if (JMPoolServer.this.state != 0) {
                JMPoolServer.this.shutdown();
            }
        }
    }
}

