/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.ServerUtils;

public class LocalREnv {
    public static final int OS_WIN = 1;
    public static final int OS_NIX = 2;
    public static final int OS_MAC = 3;
    private static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server");
    private static final int OS_TYPE;
    private static final String PATH_SPLITTER;
    private static final String DEFAULT_HOME_TEMPLATE = "${R_HOME}";
    private static final List<String> DEFAULT_PATHS_TEMPLATES;
    private final Path rHomePath;
    private final List<Path> rLibPaths;

    static {
        String osname = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        OS_TYPE = osname.contains("win") ? 1 : (osname.contains("mac") ? 3 : 2);
        PATH_SPLITTER = Pattern.compile(File.pathSeparator, 16).pattern();
        DEFAULT_PATHS_TEMPLATES = Arrays.asList("${R_LIBS}", "${R_LIBS_USER}", "${R_LIBS_SITE}", "${R_HOME}/library");
    }

    private static void add(List<Path> paths, Path pathToAdd) {
        if (pathToAdd != null && !paths.contains(pathToAdd)) {
            paths.add(pathToAdd);
        }
    }

    private static void addAll(List<Path> paths, @Nullable List<Path> pathsToAdd) {
        if (pathsToAdd != null) {
            for (Path path : pathsToAdd) {
                LocalREnv.add(paths, path);
            }
        }
    }

    public LocalREnv(String rHomeTemplate, List<String> rLibPathsTemplates, @Nullable Function<String, @Nullable String> varResolver) throws RjInvalidConfigurationException {
        if (rHomeTemplate == null) {
            throw new NullPointerException("rHomeTemplate");
        }
        if (rLibPathsTemplates == null) {
            throw new NullPointerException("rLibPathsTemplates");
        }
        if (varResolver == null) {
            varResolver = System::getenv;
        }
        this.rHomePath = this.checkPath(this.resolveTemplate(rHomeTemplate, varResolver));
        this.rLibPaths = this.resolveRLibPaths(rLibPathsTemplates, varResolver);
        this.checkSpec();
    }

    public LocalREnv() throws RjInvalidConfigurationException {
        this(DEFAULT_HOME_TEMPLATE, DEFAULT_PATHS_TEMPLATES, null);
    }

    public LocalREnv(Function<String, @Nullable String> varResolver) throws RjInvalidConfigurationException {
        this(DEFAULT_HOME_TEMPLATE, DEFAULT_PATHS_TEMPLATES, varResolver);
    }

    public LocalREnv(String rHome, List<String> rLibPaths) throws RjInvalidConfigurationException {
        if (rHome == null) {
            throw new NullPointerException("rHome");
        }
        if (rLibPaths == null) {
            throw new NullPointerException("rLibPaths");
        }
        this.rHomePath = this.checkPath(rHome);
        this.rLibPaths = this.resolveRLibPaths(rLibPaths, null);
        this.checkSpec();
    }

    public LocalREnv(Path rHomePath, List<Path> rLibPaths) throws RjInvalidConfigurationException {
        if (rHomePath == null) {
            throw new NullPointerException("rHome");
        }
        if (rLibPaths == null) {
            throw new NullPointerException("rLibPaths");
        }
        this.rHomePath = rHomePath;
        this.rLibPaths = rLibPaths;
        this.checkSpec();
    }

    protected List<Path> resolveRLibPaths(List<String> rLibPathsTemplates, @Nullable Function<String, @Nullable String> varResolver) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String template : rLibPathsTemplates) {
            String value = varResolver != null ? this.resolveTemplate(template, varResolver) : template;
            try {
                LocalREnv.addAll(paths, this.checkPathList(value));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "An error occurred when adding '" + template + "' to R library paths.", e);
            }
        }
        return paths;
    }

    protected String resolveTemplate(String s, Function<String, @Nullable String> varResolver) {
        block3: {
            if (s != null && s.indexOf(36) >= 0) {
                StringBuilder sb = new StringBuilder();
                int startIdx = 0;
                int endIdx = 0;
                while ((startIdx = s.indexOf("${", endIdx)) >= 0) {
                    String value;
                    sb.append(s, endIdx, startIdx);
                    endIdx = s.indexOf(125, startIdx += 2);
                    if (endIdx >= 0 && (value = varResolver.apply(s.substring(startIdx, endIdx))) != null) {
                        sb.append(value);
                        ++endIdx;
                        continue;
                    }
                    break block3;
                }
                sb.append(s, endIdx, s.length());
                return sb.toString();
            }
        }
        return s;
    }

    protected void checkSpec() throws RjInvalidConfigurationException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            StringBuilder sb = new StringBuilder();
            sb.append("RJClassLoader - R home path= ");
            if (this.rHomePath != null) {
                sb.append(this.rHomePath);
            } else {
                sb.append("<missing>");
            }
            sb.append('\n');
            sb.append("RJClassLoader - R library paths= ");
            if (this.rLibPaths != null) {
                if (this.rLibPaths.isEmpty()) {
                    sb.append("<empty>");
                } else {
                    ServerUtils.prettyPrint(this.rLibPaths, sb);
                }
            } else {
                sb.append("<missing>");
            }
            LOGGER.log(Level.CONFIG, sb.toString());
        }
        if (this.rHomePath == null) {
            throw new RjInvalidConfigurationException("Spec of R home path is missing.");
        }
        if (this.rLibPaths.isEmpty()) {
            throw new RjInvalidConfigurationException("Spec of R library paths is empty");
        }
    }

    public @Nullable Path checkPath(String path) {
        if (path != null && !(path = path.trim()).isEmpty()) {
            return Path.of(path, new String[0]).normalize();
        }
        return null;
    }

    public @Nullable List<Path> checkPathList(@Nullable String pathList) {
        if (pathList != null && !(pathList = pathList.trim()).isEmpty()) {
            String[] split = pathList.split(PATH_SPLITTER);
            ArrayList<Path> list = new ArrayList<Path>(split.length);
            int i = 0;
            while (i < split.length) {
                Path path = this.checkPath(split[i]);
                if (path != null) {
                    list.add(path);
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    public int getOSType() {
        return OS_TYPE;
    }

    public Path getRHomePath() {
        return this.rHomePath;
    }

    public List<Path> getRLibPaths() {
        return Collections.unmodifiableList(this.rLibPaths);
    }

    public @Nullable Path searchRPkg(String name) {
        for (Path path : this.rLibPaths) {
            try {
                Path packagePath = path.resolve(name);
                if (!Files.isRegularFile(packagePath.resolve("DESCRIPTION"), new LinkOption[0])) continue;
                return packagePath;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

