/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpath.ui;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.ltk.buildpath.ui.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElementAttribute;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathsUI;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathsUIResources;
import org.eclipse.statet.ltk.ui.util.DecoratedElementImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

@NonNullByDefault
public class BuildpathListLabelProvider
extends LabelProvider {
    private final BuildpathsUIResources buildpathsResources = BuildpathsUI.getUIResources();
    private final SharedUIResources sharedResources = SharedUIResources.getInstance();
    private final ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();

    public @Nullable Image getImage(@Nullable Object element) {
        block19: {
            block18: {
                if (!(element instanceof BuildpathListElement)) break block18;
                BuildpathListElement listElement = (BuildpathListElement)element;
                ImageDescriptor imageDescriptor = this.getListElementBaseImage(listElement);
                if (imageDescriptor != null) {
                    if (listElement.isMissing() || listElement.hasMissingChildren()) {
                        imageDescriptor = new DecoratedElementImageDescriptor(imageDescriptor, 4);
                    }
                    return this.sharedResources.getImageDescriptorRegistry().get(imageDescriptor);
                }
                break block19;
            }
            if (!(element instanceof BuildpathListElementAttribute)) break block19;
            BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)element;
            switch (attribute.getName()) {
                case "Source.path": {
                    return this.buildpathsResources.getImage("org.eclipse.statet.ltk.buildpath/images/obj/attribute-source_attachment");
                }
                case "Filter.inclusions": {
                    return this.buildpathsResources.getImage("org.eclipse.statet.ltk.buildpath/images/obj/attribute-inclusion_filter");
                }
                case "Filter.exclusions": {
                    return this.buildpathsResources.getImage("org.eclipse.statet.ltk.buildpath/images/obj/attribute-exclusion_filter");
                }
                case "Output.path": {
                    return this.buildpathsResources.getImage("org.eclipse.statet.ltk.buildpath/images/obj/attribute-output_folder");
                }
            }
        }
        return null;
    }

    public String getText(@Nullable Object element) {
        if (element instanceof BuildpathListElement) {
            return this.getListElementText((BuildpathListElement)element);
        }
        if (element instanceof BuildpathListElementAttribute) {
            BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)element;
            String text = this.getListElementAttributeText(attribute);
            if (attribute.getStatus().getCode() == 131072) {
                return NLS.bind((String)Messages.ListLabel_Attribute_NonModifiable_label, (Object)text);
            }
            return text;
        }
        return super.getText(element);
    }

    private @Nullable ImageDescriptor getListElementBaseImage(BuildpathListElement listElement) {
        switch (listElement.getType().getName()) {
            case "Project": {
                return this.workbenchImages.getImageDescriptor("IMG_OBJ_PROJECT");
            }
            case "Source": {
                if (listElement.getPath().segmentCount() == 1) {
                    return this.workbenchImages.getImageDescriptor("IMG_OBJ_PROJECT");
                }
                return this.workbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
            }
        }
        return null;
    }

    public String getListElementText(BuildpathListElement element) {
        IPath path = element.getPath();
        switch (element.getType().getName()) {
            case "Project": {
                Object label = (String)ObjectUtils.nonNullAssert((Object)path.lastSegment());
                if (element.isMissing()) {
                    label = (String)label + " " + Messages.ListLabel_Deco_Missing_label;
                }
                return label;
            }
            case "Source": {
                IResource resource;
                String pathLabel = this.getPathString(path, false);
                StringBuilder sb = new StringBuilder(pathLabel);
                IPath linkTarget = element.getLinkTarget();
                if (linkTarget != null) {
                    sb.append(" - ");
                    sb.append(MessageUtils.processPath((String)linkTarget.toOSString()));
                }
                if ((resource = element.getResource()) != null && !resource.exists()) {
                    if (element.isMissing()) {
                        sb.append(' ');
                        sb.append(Messages.ListLabel_Deco_Missing_label);
                    } else {
                        sb.append(' ');
                        sb.append(Messages.ListLabel_Deco_New_label);
                    }
                } else if (element.getOrginalPath() == null) {
                    sb.append(' ');
                    sb.append(Messages.ListLabel_Deco_New_label);
                }
                return sb.toString();
            }
        }
        return Messages.ListLabel_Element_Unknown_label;
    }

    public String getListElementAttributeText(BuildpathListElementAttribute attribute) {
        String key;
        switch (key = attribute.getName()) {
            case "Source.path": {
                IPath path = (IPath)attribute.getValue();
                String detail = path != null && !path.isEmpty() ? (attribute.getParent().getType().getName() == "Variable" ? this.getVariableString(path) : this.getPathString(path, path.getDevice() != null)) : Messages.ListLabel_Value_None_label;
                return NLS.bind((String)Messages.ListLabel_Attribute_SourceAttachment_label, (Object)detail);
            }
            case "Filter.inclusions": {
                StringBuilder sb;
                int patternsCount;
                List patterns = (List)attribute.getValue();
                String detail = patterns != null && !patterns.isEmpty() ? ((patternsCount = this.appendPatternList(patterns, sb = new StringBuilder())) > 0 ? sb.toString() : Messages.ListLabel_Value_Filter_None_label) : Messages.ListLabel_Value_Filter_All_label;
                return NLS.bind((String)Messages.ListLabel_Attribute_Inclusion_label, (Object)detail);
            }
            case "Filter.exclusions": {
                StringBuilder sb;
                int patternsCount;
                List patterns = (List)attribute.getValue();
                String detail = patterns != null && !patterns.isEmpty() ? ((patternsCount = this.appendPatternList(patterns, sb = new StringBuilder())) > 0 ? sb.toString() : Messages.ListLabel_Value_Filter_None_label) : Messages.ListLabel_Value_Filter_None_label;
                return NLS.bind((String)Messages.ListLabel_Attribute_Exclusion_label, (Object)detail);
            }
            case "Output.path": {
                IPath path = (IPath)attribute.getValue();
                String detail = path != null ? MessageUtils.processPath((String)path.toString()) : Messages.ListLabel_Value_Output_Default_label;
                return NLS.bind((String)Messages.ListLabel_Attribute_OutputFolder_label, (Object)detail);
            }
        }
        String value = (String)attribute.getValue();
        if (value == null) {
            value = Messages.ListLabel_Value_None_label;
        }
        return NLS.bind((String)Messages.ListLabel_Attribute_Generic_label, (Object)key, (Object)value);
    }

    private int appendPatternList(List<? extends IPath> patterns, StringBuilder sb) {
        int patternsCount = 0;
        for (IPath iPath : patterns) {
            if (iPath.segmentCount() <= 0) continue;
            String text = MessageUtils.processPath((String)iPath.toString());
            if (patternsCount > 0) {
                sb.append(Messages.ListLabel_Value_Path_separator);
            }
            sb.append(text);
            ++patternsCount;
        }
        return patternsCount;
    }

    private String getPathString(IPath path, boolean isExternal) {
        return MessageUtils.processPath((String)(isExternal ? path.toOSString() : path.makeRelative().toString()));
    }

    private String getVariableString(IPath path) {
        return MessageUtils.processPath((String)path.toString());
    }
}

