/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import com.ibm.icu.text.DateFormat;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RRemoteConsoleSelectionDialog
extends SelectionStatusDialog {
    private static final String SETTINGS_DIALOG_ID = "RRemoteConsoleSelection";
    private static final String SETTINGS_HOST_HISTORY_KEY = "hosts.history";
    private static final Pattern ADDRESS_MULTI_PATTERN = Pattern.compile("\\/?\\s*[\\,\\;]+\\s*");
    private Combo hostAddressControl = (Combo)ObjectUtils.nonNullLateInit();
    private TreeViewer rServerViewer = (TreeViewer)ObjectUtils.nonNullLateInit();
    private @Nullable List<RemoteR> rServerList;
    private final boolean filterOnlyRunning;
    private String username;
    private final List<String> historyAddress = new ArrayList<String>(35);
    private final List<String> additionalAddress = new ArrayList<String>(8);
    private final Map<String, SpecialAddress> specialAddress = new HashMap<String, SpecialAddress>(8);
    private @Nullable String initialAddress;

    public RRemoteConsoleSelectionDialog(Shell parentShell, boolean onlyRunning) {
        super(parentShell);
        this.setTitle(Messages.RRemoteConsoleSelectionDialog_title);
        this.setMessage(Messages.RRemoteConsoleSelectionDialog_message);
        this.setStatusLineAboveButtons(true);
        this.setDialogBoundsSettings(this.getDialogSettings(), 2);
        this.username = SystemUtils.getLocalUserName();
        this.filterOnlyRunning = onlyRunning;
    }

    public void setUser(String username) {
        if (username != null && username.length() > 0) {
            this.username = username;
        }
    }

    public void setInitialAddress(String address) {
        this.additionalAddress.remove(address);
        this.additionalAddress.add(0, address);
        this.initialAddress = address;
    }

    public void addAdditionalAddress(String label, @Nullable SpecialAddress factory) {
        this.additionalAddress.add(label);
        if (factory != null) {
            this.specialAddress.put(label, factory);
        }
    }

    public void clearAdditionaAddress(boolean specialOnly) {
        if (specialOnly) {
            for (Map.Entry<String, SpecialAddress> entry : this.specialAddress.entrySet()) {
                this.additionalAddress.remove(entry.getKey());
            }
        } else {
            this.additionalAddress.clear();
        }
        this.specialAddress.clear();
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RConsoleUIPlugin.getInstance(), (String)SETTINGS_DIALOG_ID);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.createMessageArea(area);
        IDialogSettings dialogSettings = this.getDialogSettings();
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.RRemoteConsoleSelectionDialog_Hostname_label);
        this.hostAddressControl = new Combo(composite, 4);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.hostAddressControl, (int)50);
        this.hostAddressControl.setLayoutData((Object)gd);
        @NonNull Object[] history = dialogSettings.getArray(SETTINGS_HOST_HISTORY_KEY);
        if (history != null) {
            this.historyAddress.addAll((Collection<String>)ImCollections.newList((Object[])history));
        }
        this.hostAddressControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.update();
            }
        });
        Button goButton = new Button(composite, 8);
        goButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        goButton.setText(Messages.RRemoteConsoleSelectionDialog_Update_label);
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.update();
            }
        });
        composite = new ViewerUtils.TreeComposite(area, 67588);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = LayoutUtils.hintHeight((Tree)composite.tree, (int)10);
        composite.setLayoutData((Object)gd2);
        this.rServerViewer = composite.viewer;
        composite.tree.setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)composite.viewer);
        TreeViewerColumn column = new TreeViewerColumn(this.rServerViewer, 0);
        column.getColumn().setText(Messages.RRemoteConsoleSelectionDialog_Table_UserOrEngine_label);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new RemoteRLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                String text = null;
                Image image = null;
                if (element instanceof String) {
                    text = (String)element;
                    image = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/User");
                } else if (element instanceof RemoteR) {
                    text = this.getText((RemoteR)element);
                }
                cell.setText(text);
                cell.setImage(image);
            }

            @Override
            public String getText(RemoteR r) {
                return r.info.getName();
            }
        });
        column = new TreeViewerColumn(this.rServerViewer, 0);
        column.getColumn().setText(Messages.RRemoteConsoleSelectionDialog_Table_Host_label);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new RemoteRLabelProvider(){

            @Override
            public String getText(RemoteR r) {
                return r.hostName;
            }
        });
        this.rServerViewer.setContentProvider((IContentProvider)new RemoteRContentProvider());
        this.rServerViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.updateState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.updateState();
                if (RRemoteConsoleSelectionDialog.this.getOkButton().isEnabled()) {
                    RRemoteConsoleSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        Dialog.applyDialogFont((Control)area);
        this.updateInput();
        if (this.rServerList != null) {
            this.updateStatus((IStatus)new org.eclipse.core.runtime.Status(0, "org.eclipse.statet.r.console.ui", Messages.RRemoteConsoleSelectionDialog_info_ListRestored_message));
        }
        return area;
    }

    private void update() {
        final String input = this.hostAddressControl.getText();
        this.rServerList = null;
        final AtomicReference<@Nullable IStatus> status = new AtomicReference<IStatus>();
        if (input != null && input.length() > 0) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        status.set(RRemoteConsoleSelectionDialog.this.updateRServerList(input, monitor));
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException e) {
                this.rServerList = null;
                status.compareAndSet(null, org.eclipse.core.runtime.Status.CANCEL_STATUS);
            }
        }
        if (status.get() != null) {
            this.updateStatus((IStatus)status.get());
        }
        this.getOkButton().setEnabled(false);
        List<RemoteR> list = this.rServerList;
        if (list != null && list.size() > 0) {
            if (!this.specialAddress.containsKey(input)) {
                this.historyAddress.remove(input);
                this.historyAddress.add(0, input);
            }
            if (this.filterOnlyRunning) {
                Iterator<RemoteR> iter = list.iterator();
                while (iter.hasNext()) {
                    switch (iter.next().info.getState()) {
                        case 17: 
                        case 26: {
                            iter.remove();
                        }
                    }
                }
            }
            this.updateInput();
            return;
        }
        this.rServerViewer.setInput(null);
    }

    private void updateInput() {
        final String selectedAddress = this.hostAddressControl.getText();
        ArrayList<String> list = new ArrayList<String>(this.historyAddress.size() + this.additionalAddress.size());
        list.addAll(this.historyAddress);
        for (String address : this.additionalAddress) {
            if (list.contains(address)) continue;
            list.add(address);
        }
        this.hostAddressControl.setItems(list.toArray(new String[list.size()]));
        this.rServerViewer.setInput(this.rServerList);
        if (this.username != null && this.username.length() > 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RRemoteConsoleSelectionDialog.this.initialAddress != null) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.setText(RRemoteConsoleSelectionDialog.this.initialAddress);
                        RRemoteConsoleSelectionDialog.this.initialAddress = null;
                    } else if (selectedAddress != null && selectedAddress.length() > 0) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.setText(selectedAddress);
                    } else if (RRemoteConsoleSelectionDialog.this.hostAddressControl.getItemCount() > 0) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.select(0);
                    }
                    RRemoteConsoleSelectionDialog.this.rServerViewer.expandToLevel((Object)RRemoteConsoleSelectionDialog.this.username.toLowerCase(), 1);
                    RRemoteConsoleSelectionDialog.this.updateState();
                }
            });
        }
    }

    private void updateState() {
        IStructuredSelection selection = (IStructuredSelection)this.rServerViewer.getSelection();
        this.getOkButton().setEnabled(selection.getFirstElement() instanceof RemoteR);
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.rServerViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof RemoteR) {
            this.setSelectionResult(new Object[]{((RemoteR)element).address});
        }
    }

    public boolean close() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(SETTINGS_HOST_HISTORY_KEY, this.historyAddress.toArray(new String[this.historyAddress.size()]));
        return super.close();
    }

    private @Nullable IStatus updateRServerList(String combined, IProgressMonitor monitor) {
        ArrayList<RemoteR> infos = new ArrayList<RemoteR>();
        @NonNull String[] addresses = ADDRESS_MULTI_PATTERN.split(combined, -1);
        if (addresses.length == 0) {
            return null;
        }
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RRemoteConsoleSelectionDialog_task_Gathering_message, (int)(addresses.length * 2 + 2));
        String failedHosts = null;
        ArrayList<IStatus> failedStatus = new ArrayList<IStatus>();
        m.worked(1);
        int i = 0;
        while (i < addresses.length) {
            if (monitor.isCanceled()) {
                return org.eclipse.core.runtime.Status.CANCEL_STATUS;
            }
            m.setWorkRemaining((addresses.length - i) * 2 + 1);
            String address = addresses[i];
            if (!address.isEmpty()) {
                IStatus status;
                SpecialAddress special = this.specialAddress.get(address);
                if (special != null) {
                    address = special.rmiAddress.getAddress();
                    status = RRemoteConsoleSelectionDialog.collectServerInfos(null, special, infos, m.newChild(1));
                } else {
                    status = RRemoteConsoleSelectionDialog.collectServerInfos(address, null, infos, m.newChild(1));
                }
                switch (status.getSeverity()) {
                    case 8: {
                        return status;
                    }
                    case 4: {
                        StatusManager.getManager().handle(status, 1);
                        return status;
                    }
                    case 2: {
                        failedStatus.add(status);
                        failedHosts = failedHosts == null ? address : failedHosts + ", " + address;
                        break;
                    }
                }
            }
            ++i;
        }
        if (!failedStatus.isEmpty()) {
            StatusManager.getManager().handle((IStatus)new MultiStatus("org.eclipse.statet.r.console.ui", 0, failedStatus.toArray(new IStatus[failedStatus.size()]), "Info about connection failures when browsing R engines:", null), 1);
        }
        if (!infos.isEmpty() || failedStatus.isEmpty()) {
            this.rServerList = infos;
        }
        if (failedHosts != null) {
            return new org.eclipse.core.runtime.Status(2, "org.eclipse.statet.r.console.ui", Messages.RRemoteConsoleSelectionDialog_error_ConnectionFailed_message + failedHosts);
        }
        return org.eclipse.core.runtime.Status.OK_STATUS;
    }

    private static IStatus collectServerInfos(@Nullable String addressString, @Nullable SpecialAddress special, List<RemoteR> infos, SubMonitor m) {
        try {
            Registry registry;
            String hostName;
            RMIAddress registryAddress;
            if (special != null) {
                registryAddress = special.rmiAddress;
            } else if (addressString != null) {
                registryAddress = RMIAddress.parse((String)addressString, (byte)2);
            } else {
                throw new IllegalArgumentException();
            }
            m.subTask(NLS.bind((String)Messages.RRemoteConsoleSelectionDialog_task_Resolving_message, (Object)registryAddress));
            InetAddress hostInetAddress = registryAddress.isResolved() ? registryAddress.getHostInetAddress() : null;
            String string = hostName = hostInetAddress != null ? hostInetAddress.getHostName() : registryAddress.getHost();
            String hostIp = hostInetAddress != null ? hostInetAddress.getHostAddress() : (CommonsNet.isIpAddress((String)registryAddress.getHost()) ? registryAddress.getHost() : "<unknown>");
            m.worked(1);
            if (m.isCanceled()) {
                IStatus iStatus = org.eclipse.core.runtime.Status.CANCEL_STATUS;
                return iStatus;
            }
            m.subTask(NLS.bind((String)Messages.RRemoteConsoleSelectionDialog_task_Connecting_message, (Object)hostName));
            if (special != null) {
                RMIClientSocketFactory socketFactory = special.getSocketFactory(EStatusUtils.convert((IProgressMonitor)m.newChild(5)));
                RjsComConfig.setRMIClientSocketFactory((RMIClientSocketFactory)socketFactory);
                registry = LocateRegistry.getRegistry(special.privateHost, registryAddress.getPortNum(), socketFactory);
            } else {
                RjsComConfig.setRMIClientSocketFactory(null);
                registry = LocateRegistry.getRegistry(registryAddress.getHost(), registryAddress.getPortNum());
            }
            String rmiBase = registryAddress.getAddress();
            String[] stringArray = registry.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Remote remote = registry.lookup(name);
                    if (remote instanceof Server) {
                        Server server = (Server)remote;
                        ServerInfo info = server.getInfo();
                        RemoteR r = new RemoteR(hostName, hostIp, rmiBase + name, info);
                        infos.add(r);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            IStatus iStatus = org.eclipse.core.runtime.Status.OK_STATUS;
            return iStatus;
        }
        catch (MalformedURLException | UnknownHostException e) {
            org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.ui", "Invalid address: " + e.getLocalizedMessage());
            return status;
        }
        catch (StatusException e) {
            IStatus iStatus = EStatusUtils.convert((Status)e.getStatus());
            return iStatus;
        }
        catch (RemoteException e) {
            org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(2, "org.eclipse.statet.r.console.ui", addressString);
            return status;
        }
        finally {
            RjsComConfig.clearRMIClientSocketFactory();
        }
    }

    private static class RemoteR {
        final String hostName;
        final String hostIP;
        final String address;
        final ServerInfo info;

        RemoteR(String hostName, String hostIP, String address, ServerInfo info) {
            this.hostName = hostName;
            this.hostIP = hostIP;
            this.address = address;
            this.info = info;
        }

        String createSummary() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("Address:   ").append(this.address).append('\n');
            sb.append('\n');
            sb.append("Host-Name: ").append(this.hostName).append('\n');
            sb.append("Host-IP:   ").append(this.hostIP).append('\n');
            sb.append("Date:      ").append(this.info.getTimestamp() != 0L ? DateFormat.getDateInstance().format((Object)this.info.getTimestamp()) : "<unknown>").append('\n');
            sb.append("Directory: ").append(this.info.getDirectory()).append('\n');
            sb.append("Status:    ");
            switch (this.info.getState()) {
                case 17: {
                    sb.append("New \u2013 Ready to connect and start R");
                    break;
                }
                case 20: 
                case 22: {
                    sb.append("Running \u2013 Connected (username is ");
                    sb.append(this.info.getUsername("console") != null ? this.info.getUsername("console") : "<unknown>").append(')');
                    break;
                }
                case 25: {
                    sb.append("Running \u2013 Connection lost / Ready to reconnect");
                    break;
                }
                case 24: {
                    sb.append("Running \u2013 Disconnected / Ready to reconnect");
                    break;
                }
                case 26: {
                    sb.append("Stopped");
                    break;
                }
                default: {
                    sb.append("Unknown");
                }
            }
            return sb.toString();
        }
    }

    private static class RemoteRContentProvider
    implements ITreeContentProvider {
        private final HashMap<String, List<RemoteR>> mapping = new HashMap();

        private RemoteRContentProvider() {
        }

        public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        }

        public @NonNull Object[] getElements(Object inputElement) {
            List all = (List)inputElement;
            this.mapping.clear();
            for (RemoteR r : all) {
                String username = r.info.getUsername("owner").toLowerCase();
                List<RemoteR> list = this.mapping.get(username);
                if (list == null) {
                    list = new ArrayList<RemoteR>();
                    this.mapping.put(username, list);
                }
                list.add(r);
            }
            return this.mapping.keySet().toArray();
        }

        public @Nullable Object getParent(Object element) {
            if (element instanceof RemoteR) {
                return ((RemoteR)element).info.getUsername("owner");
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public @NonNull Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                List<RemoteR> list = this.mapping.get(parentElement);
                return list != null ? list.toArray() : new Object[]{};
            }
            return null;
        }

        public void dispose() {
        }
    }

    private static abstract class RemoteRLabelProvider
    extends CellLabelProvider {
        private RemoteRLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            String text = null;
            if (element instanceof RemoteR) {
                text = this.getText((RemoteR)element);
            }
            cell.setText(text);
        }

        public abstract String getText(RemoteR var1);

        public @Nullable Font getToolTipFont(Object element) {
            if (element instanceof RemoteR) {
                return JFaceResources.getTextFont();
            }
            return null;
        }

        public @Nullable String getToolTipText(Object element) {
            if (element instanceof RemoteR) {
                return ((RemoteR)element).createSummary();
            }
            return null;
        }
    }

    public static abstract class SpecialAddress {
        private final RMIAddress rmiAddress;
        private final String privateHost;

        public SpecialAddress(RMIAddress rmiAddress, String privateHost) {
            this.rmiAddress = rmiAddress;
            this.privateHost = privateHost;
        }

        public abstract RMIClientSocketFactory getSocketFactory(ProgressMonitor var1) throws StatusException;
    }
}

