/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class Utf8Strings {
    public static boolean isValidCodepoint(int cp) {
        return cp >= 0 && cp <= 0x10FFFF && (cp & 0x1FF800) != 55296;
    }

    private static int getCodepoint0(byte[] bytes, int offset, int length) {
        if (length > 0) {
            byte byte0 = bytes[offset];
            if ((byte0 & 0xFFFFFF80) != 0) {
                if ((byte0 & 0x40) != 0) {
                    if ((byte0 & 0x20) != 0) {
                        int cp;
                        if ((byte0 & 0x10) != 0) {
                            if ((byte0 & 8) == 0 && length >= 4 && (bytes[offset + 1] & 0xFFFFFFC0) == -128 && (bytes[offset + 2] & 0xFFFFFFC0) == -128 && (bytes[offset + 3] & 0xFFFFFFC0) == -128) {
                                return ((byte0 << 6 ^ bytes[offset + 1]) << 6 ^ bytes[offset + 2]) << 6 ^ bytes[offset + 3] ^ 0x381F80;
                            }
                        } else if (length >= 3 && (bytes[offset + 1] & 0xFFFFFFC0) == -128 && (bytes[offset + 2] & 0xFFFFFFC0) == -128 && ((cp = (byte0 << 6 ^ bytes[offset + 1]) << 6 ^ bytes[offset + 2] ^ 0xFFFE1F80) & 0xF800) != 55296) {
                            return cp;
                        }
                    } else if (length >= 2 && (bytes[offset + 1] & 0xFFFFFFC0) == -128) {
                        return byte0 << 6 ^ bytes[offset + 1] ^ 0xF80;
                    }
                }
            } else {
                return byte0;
            }
        }
        return -1;
    }

    public static int getCodepoint(byte[] bytes, int offset, int endOffset) {
        if (endOffset > bytes.length || offset < 0 || offset > endOffset) {
            throw new IllegalArgumentException();
        }
        return Utf8Strings.getCodepoint0(bytes, offset, endOffset - offset);
    }

    public static int getCodepoint(byte[] bytes, int offset) {
        if (offset > bytes.length || offset < 0) {
            throw new IllegalArgumentException();
        }
        return Utf8Strings.getCodepoint0(bytes, offset, bytes.length - offset);
    }

    public static int getCodepointLength(int cp) {
        if (cp < 0) {
            return 0;
        }
        if (cp <= 127) {
            return 1;
        }
        if (cp <= 2047) {
            return 2;
        }
        if (cp <= 65535) {
            return 3;
        }
        return 4;
    }

    private Utf8Strings() {
    }
}

