/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.RContextInformationValidator;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class RContentAssistProcessor
extends ContentAssistProcessor {
    private final RHeuristicTokenScanner scanner;
    private int timeoutCounter;

    public RContentAssistProcessor(ContentAssist assistant, String partition, ContentAssistComputerRegistry registry, SourceEditor editor) {
        super(assistant, partition, registry, editor);
        this.scanner = RHeuristicTokenScanner.create((DocContentSections)editor.getDocumentContentInfo());
    }

    protected AssistInvocationContext createCompletionProposalContext(int offset, DocContentSections documentContentInfo, IProgressMonitor monitor) {
        return new Context(offset, documentContentInfo, true, monitor);
    }

    protected AssistInvocationContext createContextInformationContext(int offset, DocContentSections documentContentInfo, IProgressMonitor monitor) {
        Context context;
        if (this.timeoutCounter <= 3) {
            long startTime = System.nanoTime();
            context = new Context(offset, documentContentInfo, true, monitor);
            this.timeoutCounter = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) > 50L ? Math.min(this.timeoutCounter + 1, 10) : Math.max(this.timeoutCounter - 1, 0);
        } else {
            context = new Context(offset, documentContentInfo, false, monitor);
        }
        return context;
    }

    protected IContextInformationValidator createContextInformationValidator() {
        return new RContextInformationValidator(this.getEditor());
    }

    protected boolean forceContextInformation(AssistInvocationContext context) {
        IDocument document;
        int offset;
        block7: {
            block6: {
                offset = context.getInvocationOffset();
                if (context.getIdentifierPrefix().length() <= 0 && this.scanner != null) break block6;
                return false;
            }
            document = context.getSourceViewer().getDocument();
            if (document instanceof FragmentDocument) {
                FragmentDocument inputDoc = (FragmentDocument)document;
                document = inputDoc.getMasterDocument();
                offset += inputDoc.getOffsetInMasterDocument();
            }
            if (offset >= 2) break block7;
            return false;
        }
        try {
            char c;
            this.scanner.configure(document, RDocumentConstants.R_NO_COMMENT_CONTENT_CONSTRAINT);
            int previousOffset = this.scanner.findNonMSpaceBackward(offset, -2);
            if (previousOffset > 0 && ((c = document.getChar(previousOffset)) == '(' || c == ',')) {
                String partitionType = this.scanner.getPartition(previousOffset).getType();
                return RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partitionType);
            }
        }
        catch (BadLocationException e) {
            RUIPlugin.logUncriticalError(e);
        }
        return false;
    }

    private class Context
    extends RAssistInvocationContext {
        public Context(int offset, DocContentSections documentContentInfo, boolean isProposal, IProgressMonitor monitor) {
            super(RContentAssistProcessor.this.getEditor(), offset, documentContentInfo, RContentAssistProcessor.this.getContentType(), isProposal, RContentAssistProcessor.this.scanner, monitor);
        }

        @Override
        protected int getToolReferencesWaitTimeout() {
            return RContentAssistProcessor.this.getAssistant().isCompletionProposalAutoRequest() ? 100 : 250;
        }

        @Override
        protected void toolReferencesResolved(ImList<CombinedRElement> resolvedElements) {
            RContentAssistProcessor.this.reloadPossibleCompletions(this);
        }
    }
}

