/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableStore;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RList;

@NonNullByDefault
public class RListValue
extends RElementVariableValue<CombinedRList>
implements RIndexValueInternal {
    protected static final VariablePartitionFactory<RIndexElementValue> LIST_PARTITION_FACTORY = new VariablePartitionFactory<RIndexElementValue>(){

        protected RVariable createPartition(RIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            return new RListPartition(value, partition);
        }
    };
    private final RElementVariableStore childVariables;

    public RListValue(BasicRElementVariable variable) {
        super(variable);
        this.childVariables = new RElementVariableStore(((CombinedRList)this.element).getLength());
    }

    public final @Nullable RListValue getVariablePreviousValue() {
        return (RListValue)this.variable.getPreviousValue();
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return ((CombinedRList)this.element).getRClassName();
    }

    @Override
    public String getValueString() throws DebugException {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(((CombinedRList)this.element).getLength());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDetailString() {
        return "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return ((CombinedRList)this.element).hasModelChildren(null);
    }

    @Override
    public @NonNull IVariable[] getVariables() throws DebugException {
        return this.getPartitionFactory().getVariables((IndexedValue)this);
    }

    @Override
    public final VariablePartitionFactory<RIndexElementValue> getPartitionFactory() {
        return LIST_PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return ((CombinedRList)this.element).getLength();
    }

    public @NonNull RVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this.variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull RVariable[] getVariables(long offset, int length, RVariable parent) {
        RListValue previousValue;
        Object object = this.variable;
        synchronized (object) {
            if (this != this.variable.getCurrentValue()) {
                return NO_VARIABLES;
            }
            previousValue = this.getVariablePreviousValue();
        }
        object = this.childVariables;
        synchronized (object) {
            RVariable[] variables = new RVariable[length];
            boolean direct = parent == this.variable;
            int i = 0;
            while (i < length) {
                long idx = offset + (long)i;
                BasicRElementVariable childVariable = this.childVariables.get(idx);
                if (childVariable == null) {
                    CombinedRElement childElement = ((CombinedRList)this.element).get(idx);
                    if (previousValue != null) {
                        childVariable = this.checkPreviousVariable(previousValue, idx, childElement);
                    }
                    if (childVariable == null) {
                        childVariable = new BasicRElementVariable(childElement, this.variable.getThread(), this.stamp, this.variable);
                    }
                    this.childVariables.set(idx, childVariable);
                }
                variables[i] = direct ? childVariable : RVariableProxy.create(childVariable, parent);
                ++i;
            }
            return variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable BasicRElementVariable checkPreviousVariable(RListValue previousValue, long idx, CombinedRElement element) {
        if (idx >= 0L && idx < ((CombinedRList)previousValue.element).getLength()) {
            BasicRElementVariable previousVariable;
            RListValue rListValue = previousValue;
            synchronized (rListValue) {
                previousVariable = previousValue.childVariables.clear(idx);
            }
            if (previousVariable != null && previousVariable.update(element, this.stamp)) {
                return previousVariable;
            }
        }
        return null;
    }

    protected static class ByName
    extends RListValue {
        public ByName(BasicRElementVariable variable) {
            super(variable);
        }

        @Override
        protected @Nullable BasicRElementVariable checkPreviousVariable(RListValue previousValue, long idx, CombinedRElement element) {
            RCharacterStore names = ((CombinedRList)previousValue.element).getNames();
            if (names != null) {
                return super.checkPreviousVariable(previousValue, names.indexOf(((CombinedRList)this.element).getName(idx)), element);
            }
            return null;
        }
    }

    protected static class RListPartition
    extends RElementValue.RVariablePartition {
        public RListPartition(RIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            super(value, partition);
        }

        protected @Nullable String getNameIndexLabel(long idx) {
            return ((RList)((RIndexElementValue)this.value).getElement()).getName(idx);
        }
    }
}

