/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.sort.core.SortColumnEvent;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.core.SortModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SortPositionCommandHandler
extends AbstractLayerCommandHandler<SortDimPositionCommand> {
    private final SortModel sortModel;

    public SortPositionCommandHandler(SortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public Class<SortDimPositionCommand> getCommandClass() {
        return SortDimPositionCommand.class;
    }

    @Override
    protected boolean doCommand(SortDimPositionCommand command) {
        LayerDim layerDim = command.getDim();
        long columnId = layerDim.getPositionId(command.getPosition(), command.getPosition());
        SortDirection newSortDirection = command.getDirection();
        if (newSortDirection == null) {
            newSortDirection = this.sortModel.getSortDirection(columnId).getNextSortDirection();
        }
        this.sortModel.sort(columnId, newSortDirection, command.isAccumulate());
        SortColumnEvent sortEvent = new SortColumnEvent(layerDim, new LRange(command.getPosition()));
        layerDim.getLayer().fireLayerEvent(sortEvent);
        return true;
    }
}

