/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.swt.painters;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.TableLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class TableGridLayerPainter
extends TableLayerPainter {
    private final Color gridColor;

    public TableGridLayerPainter(NatTable natTable, Color gridColor) {
        super(natTable);
        this.gridColor = gridColor;
    }

    @Override
    protected void paintBackground(Layer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, ConfigRegistry configRegistry) {
        super.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        gc.setForeground(this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        int startX = rectangle.x;
        int endX = rectangle.x + rectangle.width;
        LayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long endPosition = CellLayerPainter.getEndPosition(dim, rectangle.y + rectangle.height);
        long position = dim.getPositionByPixel(rectangle.y);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(startX, y, endX, y);
            }
            ++position;
        }
    }

    private void drawVerticalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        int startY = rectangle.y;
        int endY = rectangle.y + rectangle.height;
        LayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long endPosition = CellLayerPainter.getEndPosition(dim, rectangle.x + rectangle.width);
        long position = dim.getPositionByPixel(rectangle.x);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int x = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(x, startY, x, endY);
            }
            ++position;
        }
    }
}

