/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.coordinate;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class LRectangle {
    public long x;
    public long y;
    public long width;
    public long height;

    public LRectangle(long x, long y, long width, long height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public LRectangle(LRange xRange, LRange yRange) {
        this.x = xRange.start;
        this.y = yRange.start;
        this.width = xRange.size();
        this.height = yRange.size();
    }

    public boolean isEmpty() {
        return this.width <= 0L || this.height <= 0L;
    }

    public boolean contains(long x, long y) {
        return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public boolean contains(LPoint pt) {
        if (pt == null) {
            throw new NullPointerException("pt");
        }
        return this.contains(pt.x, pt.y);
    }

    public boolean contains(LRectangle rect) {
        if (rect == null) {
            throw new NullPointerException("rect");
        }
        return rect.x >= this.x && rect.y >= this.y && rect.x + rect.width <= this.x + this.width && rect.y + rect.height <= this.y + this.height;
    }

    public boolean intersects(long x, long y, long width, long height) {
        return x < this.x + this.width && y < this.y + this.height && x + width > this.x && y + height > this.y;
    }

    public boolean intersects(LRectangle rect) {
        if (rect == null) {
            throw new NullPointerException("rect");
        }
        return rect == this || this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public LRectangle intersection(LRectangle rect) {
        if (rect == null) {
            throw new NullPointerException("rect");
        }
        if (this == rect) {
            return new LRectangle(this.x, this.y, this.width, this.height);
        }
        long left = this.x > rect.x ? this.x : rect.x;
        long top = this.y > rect.y ? this.y : rect.y;
        long lhs = this.x + this.width;
        long rhs = rect.x + rect.width;
        long right = lhs < rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        long bottom = lhs < rhs ? lhs : rhs;
        return new LRectangle(right < left ? 0L : left, bottom < top ? 0L : top, right < left ? 0L : right - left, bottom < top ? 0L : bottom - top);
    }

    public LRectangle union(LRectangle rect) {
        if (rect == null) {
            throw new NullPointerException("rect");
        }
        long left = this.x < rect.x ? this.x : rect.x;
        long top = this.y < rect.y ? this.y : rect.y;
        long lhs = this.x + this.width;
        long rhs = rect.x + rect.width;
        long right = lhs > rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        long bottom = lhs > rhs ? lhs : rhs;
        return new LRectangle(left, top, right - left, bottom - top);
    }

    public LRange getRange(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return new LRange(this.x, this.x + this.width);
            }
            case VERTICAL: {
                return new LRange(this.y, this.y + this.height);
            }
        }
        throw new IllegalStateException();
    }

    public long getSize(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return this.width;
            }
            case VERTICAL: {
                return this.height;
            }
        }
        throw new IllegalStateException();
    }

    public LRectangle switchOrientation() {
        return new LRectangle(this.y, this.y, this.height, this.width);
    }

    public int hashCode() {
        int h = (int)(this.x ^ this.x >>> 32);
        h ^= Integer.rotateLeft((int)(this.width ^ this.width >>> 32), 3);
        h = Integer.rotateRight(h, 15);
        h ^= (int)(this.y ^ this.y >>> 32);
        return (h ^= Integer.rotateLeft((int)(this.height ^ this.height >>> 32), 3)) ^ h >>> 7;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (obj == this) break block2;
                if (!(obj instanceof LRectangle)) break block3;
                LRectangle other = (LRectangle)obj;
                if (this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "LRectangle {" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
    }
}

