/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.copy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.ecommons.waltable.copy.CopyToClipboardCommand;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.data.ControlData;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.ui.ITableUIContext;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.statet.jcommons.collections.LongIterator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyToClipboardCommandHandler
extends AbstractLayerCommandHandler<CopyToClipboardCommand> {
    private final SelectionLayer selectionLayer;
    private final Layer columnHeaderDataLayer;
    private final Layer rowHeaderDataLayer;
    private final ITableUIContext uiContext;

    public CopyToClipboardCommandHandler(SelectionLayer selectionLayer, ITableUIContext uiContext) {
        this(selectionLayer, null, null, uiContext);
    }

    public CopyToClipboardCommandHandler(SelectionLayer selectionLayer, Layer columnHeaderDataLayer, Layer rowHeaderDataLayer, ITableUIContext uiContext) {
        if (selectionLayer == null) {
            throw new NullPointerException("selectionLayer");
        }
        if (uiContext == null) {
            throw new NullPointerException("uiContext");
        }
        this.selectionLayer = selectionLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.rowHeaderDataLayer = rowHeaderDataLayer;
        this.uiContext = uiContext;
    }

    @Override
    public boolean doCommand(CopyToClipboardCommand command) {
        this.doCopy(command);
        return true;
    }

    private void doCopy(CopyToClipboardCommand command) {
        LayerCell[][] copiedCells = this.assembleCopiedDataStructure();
        if (copiedCells.length == 0) {
            return;
        }
        int rowCount = copiedCells.length;
        int colCount = copiedCells[0].length;
        Object[][] values = new Object[rowCount][colCount];
        try {
            if (rowCount <= 1000 && colCount <= 1000) {
                int rowIdx = 0;
                while (rowIdx < rowCount) {
                    int colIdx = 0;
                    while (colIdx < colCount) {
                        LayerCell cell = copiedCells[rowIdx][colIdx];
                        if (cell != null) {
                            Object dataValue = cell.getDataValue(0, null);
                            if (dataValue instanceof ControlData) {
                                if ((((ControlData)dataValue).getCode() & 4) != 0) {
                                    this.loadAsync(copiedCells, values, rowIdx, colIdx);
                                    break;
                                }
                                if ((((ControlData)dataValue).getCode() & 1) != 0) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", 0, "Failed to load required data.", null));
                                }
                            }
                            values[rowIdx][colIdx] = dataValue;
                        }
                        ++colIdx;
                    }
                    ++rowIdx;
                }
            } else {
                this.loadAsync(copiedCells, values, 0, 0);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() != 4) {
                return;
            }
            Status status = new Status(4, "org.eclipse.statet.ecommons.waltable.core", 0, "Copy table data to clipboard failed.", (Throwable)e);
            WaLTablePlugin.log((IStatus)status);
            this.uiContext.show((IStatus)status);
            return;
        }
        String cellDelimeter = command.getCellDelimeter();
        String rowDelimeter = command.getRowDelimeter();
        StringBuilder textBuilder = new StringBuilder();
        int rowIdx = 0;
        while (rowIdx < rowCount) {
            int colIdx = 0;
            while (colIdx < colCount) {
                LayerCell cell = copiedCells[rowIdx][colIdx];
                if (cell != null) {
                    textBuilder.append(this.getTextForCell(command, cell, values[rowIdx][colIdx]));
                }
                if (++colIdx >= colCount) continue;
                textBuilder.append(cellDelimeter);
            }
            if (++rowIdx >= rowCount) continue;
            textBuilder.append(rowDelimeter);
        }
        String textData = textBuilder.toString();
        if (!textData.isEmpty()) {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            try {
                clipboard.setContents(new Object[]{textData}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void loadAsync(final LayerCell[][] copiedCells, final Object[][] values, final int startRowIdx, final int startColIdx) throws CoreException {
        try {
            this.uiContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        int rowCount = copiedCells.length;
                        int colCount = copiedCells[0].length;
                        monitor.beginTask("Collecting data to copy...", rowCount - startRowIdx);
                        int rowIdx = startRowIdx;
                        while (rowIdx < rowCount) {
                            int colIdx = rowIdx == startRowIdx ? startColIdx : 0;
                            while (colIdx < colCount) {
                                LayerCell cell = copiedCells[rowIdx][colIdx];
                                if (cell != null) {
                                    Object dataValue = cell.getDataValue(1, monitor);
                                    if (dataValue instanceof ControlData && (((ControlData)dataValue).getCode() & 1) != 0) {
                                        throw new CoreException((IStatus)(monitor.isCanceled() ? Status.CANCEL_STATUS : new Status(4, "org.eclipse.statet.ecommons.waltable.core", 0, "Failed to load required data.", null)));
                                    }
                                    values[rowIdx][colIdx] = dataValue;
                                }
                                ++colIdx;
                            }
                            if (monitor.isCanceled()) {
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                            monitor.worked(1);
                            ++rowIdx;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CoreException) {
                throw (CoreException)cause;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", 0, "An error occurred when loading required data.", cause));
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", 0, "An error occurred when loading required data.", (Throwable)e));
        }
    }

    protected String getTextForCell(CopyToClipboardCommand command, LayerCell cell, Object value) {
        return CellDisplayConversionUtils.convertDataType(cell, value, command.getConfigRegistry());
    }

    @Override
    public Class<CopyToClipboardCommand> getCommandClass() {
        return CopyToClipboardCommand.class;
    }

    protected LayerCell[][] assembleCopiedDataStructure() {
        long columnOffset;
        LRangeList selectedRowPositions = this.selectionLayer.getSelectedRowPositions();
        LRangeList selectedColumnPositions = this.selectionLayer.getSelectedColumnPositions();
        long rowOffset = this.columnHeaderDataLayer != null ? this.columnHeaderDataLayer.getRowCount() : 0L;
        long l = columnOffset = this.rowHeaderDataLayer != null ? this.rowHeaderDataLayer.getColumnCount() : 0L;
        if (selectedRowPositions.values().size() + rowOffset > Integer.MAX_VALUE || selectedColumnPositions.values().size() + columnOffset > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Selected area too large.");
        }
        LayerCell[][] cells = new LayerCell[(int)(selectedRowPositions.values().size() + rowOffset)][];
        int cellsIdx = 0;
        while ((long)cellsIdx < rowOffset) {
            cells[cellsIdx++] = this.assembleColumnHeader(selectedColumnPositions, (int)columnOffset, cellsIdx);
        }
        LongIterator rowIter = selectedRowPositions.values().iterator();
        while (rowIter.hasNext()) {
            long rowPosition = rowIter.nextLong();
            cells[cellsIdx++] = this.assembleBody(selectedColumnPositions, (int)columnOffset, rowPosition);
        }
        return cells;
    }

    protected LayerCell[] assembleColumnHeader(LRangeList selectedColumnPositions, int columnOffset, long headerRowPosition) {
        LayerCell[] headerCells = new LayerCell[(int)(selectedColumnPositions.values().size() + (long)columnOffset)];
        int headerIdx = columnOffset;
        if (this.columnHeaderDataLayer != null) {
            LongIterator columnIter = selectedColumnPositions.values().iterator();
            while (columnIter.hasNext()) {
                long columnPosition = columnIter.nextLong();
                headerCells[headerIdx] = this.columnHeaderDataLayer.getCellByPosition(columnPosition, headerRowPosition);
                ++headerIdx;
            }
        }
        return headerCells;
    }

    protected LayerCell[] assembleBody(LRangeList selectedColumnPositions, int columnOffset, long currentRowPosition) {
        LayerCell[] bodyCells = new LayerCell[(int)(selectedColumnPositions.values().size() + (long)columnOffset)];
        int bodyIdx = 0;
        if (this.rowHeaderDataLayer != null) {
            while (bodyIdx < columnOffset) {
                bodyCells[bodyIdx] = this.rowHeaderDataLayer.getCellByPosition(bodyIdx, currentRowPosition);
                ++bodyIdx;
            }
        }
        LongIterator columnIter = selectedColumnPositions.values().iterator();
        while (columnIter.hasNext()) {
            long columnPosition = columnIter.nextLong();
            if (this.selectionLayer.isCellPositionSelected(columnPosition, currentRowPosition)) {
                bodyCells[bodyIdx] = this.selectionLayer.getCellByPosition(columnPosition, currentRowPosition);
            }
            ++bodyIdx;
        }
        return bodyCells;
    }
}

