/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.setup;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.UnknownSchemeException;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

@NonNullByDefault
public class OpenWebBrowserHandler
implements ToolCommandHandler {
    public static final String OPEN_WEB_BROWSER_COMMAND_ID = "common/openWebBrowser";
    private final boolean tunnelRemote;

    public OpenWebBrowserHandler(boolean tunnelRemote) {
        this.tunnelRemote = tunnelRemote;
    }

    public OpenWebBrowserHandler() {
        this(false);
    }

    public Status execute(String id, ToolService service, ToolCommandData data, ProgressMonitor m) throws StatusException {
        switch (id) {
            case "common/openWebBrowser": {
                URL urlUrl;
                String urlString = data.getString("url");
                try {
                    URI url = urlString == null || urlString.isEmpty() || urlString.equals("about:blank") ? null : this.toLocalUrl(urlString, service, m);
                    urlUrl = url != null ? url.toURL() : null;
                }
                catch (MalformedURLException | URISyntaxException | UnknownSchemeException e) {
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.nico.ui", 0, String.format("The specified string '%1$s' is not a valid URL.", urlString), e));
                }
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                UIAccess.getDisplay().asyncExec(() -> {
                    try {
                        IWorkbenchPage workbenchPage = NicoUI.getToolRegistry().findWorkbenchPage(service.getTool());
                        this.openWebBrowser(urlUrl, browserSupport, workbenchPage);
                    }
                    catch (Exception e) {
                        NicoUIPlugin.logError(0, "An error occurred when opening the web browser.", e);
                    }
                });
                return Status.OK_STATUS;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected @Nullable URI toLocalUrl(String urlString, ToolService service, ProgressMonitor m) throws StatusException, URISyntaxException, UnknownSchemeException {
        ToolProcess toolProcess;
        ToolWorkspace toolWorkspace;
        Tool tool;
        URI url = new URI(urlString);
        if (url.getScheme() == null) {
            url = new URI(url.getHost() != null ? "http" : "file", url.getSchemeSpecificPart(), url.getFragment());
        }
        if (this.tunnelRemote && (tool = service.getTool()) instanceof ToolProcess && (toolWorkspace = (toolProcess = (ToolProcess)tool).getWorkspace()).isRemote()) {
            if (UriUtils.isFileUrl((URI)url)) {
                String toolPath = url.getPath();
                if (toolPath == null) {
                    return null;
                }
                Path path = toolWorkspace.toSystemPath(toolPath);
                return path.toUri();
            }
            String host = url.getHost();
            if (host != null && CommonsNet.isCommonLoopback((String)host)) {
                host = toolWorkspace.getHost();
                RSAccessClientSession remoteNetSession = toolWorkspace.getRemoteNetSession(m);
                if (remoteNetSession != null) {
                    PortForwardingL portForwarding = remoteNetSession.allocatePortForwardingL(url.getPort() != -1 ? new Port(url.getPort()) : CommonsNet.getDefaultPort((String)url.getScheme()));
                    url = new URI(url.getScheme(), url.getUserInfo(), portForwarding.getLocalAddress().getHostName(), portForwarding.getLocalAddress().getPort(), url.getPath(), url.getQuery(), url.getFragment());
                    toolProcess.addTerminationListener(() -> {
                        try {
                            remoteNetSession.releasePortForwarding(portForwarding);
                        }
                        catch (StatusException e) {
                            NicoUIPlugin.logError(0, "An error occurred when releasing port forwarding.", e);
                        }
                    });
                } else if (!host.equals(url.getHost())) {
                    url = new URI(url.getScheme(), url.getUserInfo(), host, url.getPort(), url.getPath(), url.getQuery(), url.getFragment());
                }
            }
        }
        return url;
    }

    protected void openWebBrowser(@Nullable URL url, IWorkbenchBrowserSupport browserSupport, IWorkbenchPage workbenchPage) throws PartInitException {
        IWebBrowser browser = browserSupport.getExternalBrowser();
        if (url != null) {
            browser.openURL(url);
        } else {
            String browserClass = browser.getClass().getName();
            if (browserClass.startsWith("org.eclipse.ui.internal.browser.")) {
                if ((browserClass = browserClass.substring(32)).startsWith("ExternalBrowser") || browserClass.startsWith("InternalBrowserEditor") || browserClass.startsWith(".browsers.MozillaBrowser")) {
                    browser.openURL(null);
                    return;
                }
                if (browserClass.startsWith("SystemBrowser")) {
                    Program program = Program.findProgram((String)"html");
                    if (program != null && program.execute("about:blank")) {
                        return;
                    }
                    Program.launch((String)"http:");
                    return;
                }
            } else {
                try {
                    browser.openURL(null);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            try {
                browser.openURL(new URI("http", null, null).toURL());
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
    }
}

