/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.input;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.FilterParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

@NonNullByDefault
public final class RegionParserInput
extends FilterParserInput {
    private ImList<? extends TextRegion> regions;
    private int regionIdx;
    private final @Nullable String regionSeparator;

    public RegionParserInput(TextParserInput source, @Nullable ImList<? extends TextRegion> regions, @Nullable String regionSeparator, int defaultBufferSize) {
        super(source, defaultBufferSize);
        this.regionSeparator = regionSeparator;
        this.regions = regions != null ? regions : ImCollections.emptyList();
        this.regionIdx = -1;
    }

    public RegionParserInput(String source, @Nullable ImList<? extends TextRegion> regions) {
        this(new StringParserInput(source).init(), regions, null, Math.min(source.length(), 2048));
    }

    public RegionParserInput(TextParserInput source, @Nullable String regionSeparator) {
        this(source, null, regionSeparator, 2048);
    }

    public RegionParserInput reset(@Nullable ImList<? extends TextRegion> regions) {
        this.regions = regions != null ? regions : ImCollections.emptyList();
        this.regionIdx = -1;
        super.reset();
        return this;
    }

    @Override
    public RegionParserInput init() {
        super.init();
        return this;
    }

    @Override
    public RegionParserInput init(int startIndex, int stopIndex) {
        this.regionIdx = -1;
        super.init(startIndex, stopIndex);
        return this;
    }

    @Override
    protected int read(TextParserInput in, char[] buffer, int[] beginIndexes, int[] endIndexes, int beginIdx, int requiredEnd, int recommendEnd) {
        if (this.regionIdx < 0) {
            this.regionIdx = 0;
            if (!this.nextRegion(in)) {
                return 0;
            }
        }
        int idx = beginIdx;
        while (idx < recommendEnd) {
            int c0 = in.get(0);
            int index = in.getIndex();
            if (c0 == -1) {
                if (!this.nextRegion(in)) break;
                String regionSeparator = this.regionSeparator;
                if (regionSeparator == null) continue;
                int i = 0;
                while (i < regionSeparator.length()) {
                    buffer[idx] = regionSeparator.charAt(i);
                    beginIndexes[idx] = index;
                    endIndexes[idx] = index;
                    ++i;
                    ++idx;
                }
                continue;
            }
            buffer[idx] = (char)c0;
            beginIndexes[idx] = index;
            endIndexes[idx] = index + in.getLengthInSource(1);
            in.consume(1);
            ++idx;
        }
        beginIndexes[idx] = in.getIndex();
        return idx;
    }

    private boolean nextRegion(TextParserInput source) {
        while (this.regionIdx < this.regions.size()) {
            int end;
            TextRegion region;
            int start;
            if ((start = Math.max((region = (TextRegion)this.regions.get(this.regionIdx++)).getStartOffset(), this.getStartIndex())) >= (end = Math.min(region.getEndOffset(), this.getStopIndex()))) continue;
            source.init(start, end);
            return true;
        }
        return false;
    }
}

