/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class BasicTextRegion
implements TextRegion {
    protected final int startOffset;
    protected final int endOffset;

    public BasicTextRegion(int startOffset, int endOffset) {
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("startOffset > endOffset: startOffset= " + startOffset + ", endOffset= " + endOffset);
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public BasicTextRegion(int offset) {
        this.startOffset = offset;
        this.endOffset = offset;
    }

    public BasicTextRegion(TextRegion region) {
        this(region.getStartOffset(), region.getEndOffset());
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final int getLength() {
        return this.endOffset - this.startOffset;
    }

    public int hashCode() {
        return this.startOffset << 24 | this.getLength() << 16;
    }

    protected boolean equalsByOffsets(TextRegion other) {
        return this.startOffset == other.getStartOffset() && this.endOffset == other.getEndOffset();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof TextRegion && this.equalsByOffsets((TextRegion)obj);
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder();
        sb.append('[', this.startOffset, this.endOffset, ')');
        return sb.toString();
    }
}

