/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RVectorImpl<TData extends RStore<?>>
extends AbstractRObject
implements RVector<TData>,
ExternalizableRObject {
    private TData data;
    private long length;
    private String className1;
    private @Nullable RStore<?> namesAttribute;

    public RVectorImpl(TData data, String className1) {
        this(data, data.getLength(), className1, null);
    }

    public RVectorImpl(TData data) {
        this(data, data.getLength(), data.getBaseVectorRClassName(), null);
    }

    public RVectorImpl(TData data, String className1, @Nullable String @Nullable [] initialNames) {
        this(data, data.getLength(), className1, initialNames);
    }

    public RVectorImpl(TData data, long length, String className1, @Nullable String @Nullable [] initialNames) {
        if (data == null || className1 == null) {
            throw new NullPointerException();
        }
        if (initialNames != null && (long)initialNames.length != length || data.getLength() >= 0L && data.getLength() != length) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.length = length;
        this.className1 = className1;
        if (initialNames != null) {
            this.namesAttribute = new RCharacter32Store(initialNames);
        }
    }

    public RVectorImpl(TData data, String className1, RStore<?> initialNames) {
        if (data == null || className1 == null) {
            throw new NullPointerException();
        }
        if (initialNames != null && initialNames.getLength() != data.getLength()) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.length = data.getLength();
        this.className1 = className1;
        this.namesAttribute = initialNames;
    }

    public RVectorImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        if ((options & 0x10) != 0) {
            this.className1 = io.readString();
        }
        this.length = io.readVULong((byte)(options & 7));
        if ((options & 0x40) != 0) {
            this.namesAttribute = factory.readNames(io, this.length);
        }
        this.data = factory.readStore(io, this.length);
        if ((options & 0x10) == 0) {
            this.className1 = this.data.getBaseVectorRClassName();
        }
        if ((options & 8) != 0) {
            this.setAttributes(factory.readAttributeList(io));
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        RList attributes;
        int options = io.getVULongGrade(this.length);
        if (!this.className1.equals(this.data.getBaseVectorRClassName())) {
            options |= 0x10;
        }
        if ((io.flags & 1) == 0 && this.namesAttribute != null) {
            options |= 0x40;
        }
        RList rList = attributes = (io.flags & 2) != 0 ? this.getAttributes() : null;
        if (attributes != null) {
            options |= 8;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), this.length);
        if ((options & 0x40) != 0) {
            factory.writeNames(this.namesAttribute, io);
        }
        factory.writeStore((RStore<?>)this.data, io);
        if ((options & 8) != 0) {
            factory.writeAttributeList(attributes, io);
        }
    }

    @Override
    public byte getRObjectType() {
        return 2;
    }

    @Override
    public String getRClassName() {
        return this.className1;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public @Nullable RStore<?> getNames() {
        return this.namesAttribute;
    }

    @Override
    public TData getData() {
        return this.data;
    }

    public void setData(TData data) {
        this.data = data;
    }

    public void insert(int idx) {
        ((RDataResizeExtension)this.data).insertNA(idx);
        ++this.length;
    }

    public void remove(int idx) {
        ((RDataResizeExtension)this.data).remove(idx);
        --this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=RVector, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.getLength());
        sb.append("\n\tdata: ");
        sb.append(this.data.toString());
        return sb.toString();
    }
}

