/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.services.util.dataaccess.RDataSubset;

@NonNullByDefault
public class LazyRStore<V> {
    public static final int DEFAULT_FRAGMENT_SIZE = 2500;
    public static final int FORCE_SYNC = 1;
    private final long columnCount;
    private long rowCount;
    private final int maxFragmentCount;
    private @Nullable Fragment<V>[] fragments;
    private int currentFragmentCount = 0;
    private final Fragment<V> topFragment = new Fragment(-1L, 0L, 0L, 0L, 0L);
    private final Fragment<V> bottomFragment = new Fragment(-1L, 0L, 0L, 0L, 0L);
    private final int fragmentRowCount;
    private final int fragmentColCount;
    private final long fragmentCountInRow;
    private final List<RDataAssignment> assignments = new ArrayList<RDataAssignment>();
    private int scheduledCount;
    private @Nullable Fragment<V> scheduleNext;
    private Updater<V> updater;

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, Updater<V> updater) {
        this(rowCount, columnCount, maxFragmentCount, 2500, updater);
    }

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, int fragmentSize, Updater<V> updater) {
        this.columnCount = columnCount;
        this.maxFragmentCount = maxFragmentCount;
        this.fragmentColCount = (int)Math.min(columnCount, 25L);
        this.fragmentCountInRow = (columnCount - 1L) / (long)this.fragmentColCount + 1L;
        this.fragmentRowCount = fragmentSize / this.fragmentColCount;
        this.updater = updater;
        this.init(rowCount);
    }

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, int fragmentRowCount, int fragmentColCount, Updater<V> updater) {
        this.columnCount = columnCount;
        this.maxFragmentCount = maxFragmentCount;
        this.fragmentColCount = fragmentColCount;
        this.fragmentCountInRow = (columnCount - 1L) / (long)fragmentColCount + 1L;
        this.fragmentRowCount = fragmentRowCount;
        this.updater = updater;
        this.init(rowCount);
    }

    private void init(long rowCount) {
        this.fragments = new Fragment[Math.min(16, this.maxFragmentCount)];
        this.clear(rowCount);
    }

    private long getNumber(long rowIdx, long columnIdx) {
        return rowIdx / (long)this.fragmentRowCount * this.fragmentCountInRow + columnIdx / (long)this.fragmentColCount;
    }

    public @Nullable Fragment<V> getFragment(long rowIdx, long columnIdx, int flags, ProgressMonitor m) {
        if (rowIdx >= this.rowCount) {
            return null;
        }
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, true);
        if ((fragment.state & 2) != 0) {
            return fragment;
        }
        boolean scheduleUpdate = this.scheduledCount == 0;
        this.scheduleNext = this.topFragment;
        if ((fragment.state & 1) == 0) {
            fragment.state = 1;
            ++this.scheduledCount;
        }
        if (scheduleUpdate || (flags & 1) != 0) {
            this.updater.scheduleUpdate(this, null, fragment, flags, m);
            if ((fragment.state & 2) != 0) {
                return fragment;
            }
        }
        return null;
    }

    public void setFragment(long rowIdx, long columnIdx, V rObject) {
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, true);
        this.updateFragment(fragment, rObject);
    }

    public @Nullable Fragment<V> getLoadedFragment(long rowIdx, long columnIdx) {
        if (rowIdx >= this.rowCount) {
            return null;
        }
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, false);
        if (fragment != null && (fragment.state & 2) != 0) {
            return fragment;
        }
        return null;
    }

    public @Nullable Fragment<V> getLoadedFragmentAny() {
        Fragment<Object> fragment = this.topFragment;
        while (fragment != null) {
            if ((fragment.state & 2) != 0) {
                return fragment;
            }
            fragment = fragment.older;
        }
        return null;
    }

    public void set(RDataAssignment assignment, int flags, ProgressMonitor m) {
        Fragment<V> fragment = this.clear(assignment);
        this.assignments.add(assignment);
        boolean scheduleUpdate = this.scheduledCount == 0;
        ++this.scheduledCount;
        if (fragment != null) {
            fragment.state = 1;
            ++this.scheduledCount;
        }
        if (scheduleUpdate) {
            this.updater.scheduleUpdate(this, assignment, fragment, flags, m);
        }
    }

    public @Nullable Fragment<V> clear(RDataSubset subset) {
        Fragment<V> firstFragment = null;
        long columnBeginIdx = subset.getColumnBeginIdx() / (long)this.fragmentColCount * (long)this.fragmentColCount;
        while (columnBeginIdx < subset.getColumnEndIdx()) {
            long rowBeginIdx = subset.getRowBeginIdx() / (long)this.fragmentRowCount * (long)this.fragmentRowCount;
            while (rowBeginIdx < subset.getRowEndIdx()) {
                long number = this.getNumber(rowBeginIdx, columnBeginIdx);
                int idx = this.indexOf(number);
                if (idx >= 0) {
                    Fragment<V> fragment = this.clearFragment(idx);
                    if (firstFragment == null) {
                        firstFragment = fragment;
                    }
                }
                rowBeginIdx = Math.min(rowBeginIdx + (long)this.fragmentRowCount, this.rowCount);
            }
            columnBeginIdx = Math.min(columnBeginIdx + (long)this.fragmentColCount, this.columnCount);
        }
        return firstFragment;
    }

    private int indexOf(long number) {
        Fragment<V>[] array = this.fragments;
        int low = 0;
        int high = this.currentFragmentCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Fragment<V> fragment = array[mid];
            if (fragment.number < number) {
                low = mid + 1;
                continue;
            }
            if (fragment.number > number) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private @Nullable Fragment<V> getFragment(long number, boolean create) {
        if (this.topFragment.older.number == number) {
            return this.topFragment.older;
        }
        Fragment<V>[] array = this.fragments;
        int low = 0;
        int high = this.currentFragmentCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Fragment<V> fragment = array[mid];
            if (fragment.number < number) {
                low = mid + 1;
                continue;
            }
            if (fragment.number > number) {
                high = mid - 1;
                continue;
            }
            fragment.newer.older = fragment.older;
            fragment.older.newer = fragment.newer;
            fragment.newer = this.topFragment;
            fragment.older = this.topFragment.older;
            this.topFragment.older.newer = fragment;
            this.topFragment.older = fragment;
            return fragment;
        }
        if (!create) {
            return null;
        }
        Fragment<V> fragment = this.createFragment(number);
        if (this.currentFragmentCount >= this.maxFragmentCount && this.removeOldestFragment() < low) {
            --low;
        }
        if (array.length == this.currentFragmentCount) {
            this.fragments = new Fragment[Math.min(this.currentFragmentCount * 2, this.maxFragmentCount)];
            System.arraycopy(array, 0, this.fragments, 0, low);
        }
        System.arraycopy(array, low, this.fragments, low + 1, this.currentFragmentCount - low);
        this.fragments[low] = fragment;
        ++this.currentFragmentCount;
        fragment.newer = this.topFragment;
        fragment.older = this.topFragment.older;
        this.topFragment.older.newer = fragment;
        this.topFragment.older = fragment;
        return fragment;
    }

    private Fragment<V> createFragment(long number) {
        long rowBeginIdx = number / this.fragmentCountInRow * (long)this.fragmentRowCount;
        long rowEndIdx = Math.min(rowBeginIdx + (long)this.fragmentRowCount, this.rowCount);
        long columnBeginIdx = number % this.fragmentCountInRow * (long)this.fragmentColCount;
        long columnEndIdx = Math.min(columnBeginIdx + (long)this.fragmentColCount, this.columnCount);
        return new Fragment(number, rowBeginIdx, rowEndIdx - rowBeginIdx, columnBeginIdx, columnEndIdx - columnBeginIdx);
    }

    private Fragment<V> clearFragment(int idx) {
        Fragment<V> oldFragment = this.fragments[idx];
        Fragment newFragment = new Fragment(oldFragment.number, oldFragment.getRowBeginIdx(), oldFragment.getRowCount(), oldFragment.getColumnBeginIdx(), oldFragment.getColumnCount());
        if (oldFragment.newer != null) {
            newFragment.newer = oldFragment.newer;
            newFragment.newer.older = newFragment;
        }
        if (oldFragment.older != null) {
            newFragment.older = oldFragment.older;
            newFragment.older.newer = newFragment;
        }
        this.fragments[idx] = newFragment;
        return this.fragments[idx];
    }

    private int removeOldestFragment() {
        Fragment fragment = (Fragment)ObjectUtils.nonNullAssert(this.bottomFragment.newer);
        if ((fragment.state & 1) != 0) {
            fragment.state = (byte)(fragment.state & 0xFFFFFFFE);
            --this.scheduledCount;
        }
        if (this.scheduleNext == fragment) {
            this.scheduleNext = fragment.older;
        }
        int idx = this.indexOf(fragment.number);
        --this.currentFragmentCount;
        System.arraycopy(this.fragments, idx + 1, this.fragments, idx, this.currentFragmentCount - idx);
        this.fragments[this.currentFragmentCount] = null;
        fragment.newer.older = this.bottomFragment;
        this.bottomFragment.newer = fragment.newer;
        fragment.newer = null;
        fragment.older = null;
        return idx;
    }

    public void clear(long rowCount) {
        Fragment<V>[] array = this.fragments;
        int i = 0;
        while (i < this.currentFragmentCount) {
            array[i].state = (byte)(array[i].state & 0xFFFFFFFE);
            array[i] = null;
            ++i;
        }
        this.currentFragmentCount = 0;
        this.topFragment.older = this.bottomFragment;
        this.bottomFragment.newer = this.topFragment;
        this.scheduledCount = 0;
        this.scheduleNext = this.topFragment;
        if (rowCount >= 0L) {
            this.rowCount = rowCount;
        }
    }

    public Fragment<V>[] getScheduledFragments() {
        Fragment[] scheduledFragments = new Fragment[this.scheduledCount];
        Fragment fragment = this.topFragment.older;
        int i = 0;
        while (i < this.scheduledCount) {
            if ((fragment.state & 1) != 0) {
                scheduledFragments[i++] = fragment;
            }
            fragment = fragment.older;
        }
        return scheduledFragments;
    }

    public @Nullable Fragment<V> getNextScheduledFragment() {
        if (this.scheduledCount == 0) {
            return null;
        }
        Fragment fragment = this.scheduleNext.older;
        while (true) {
            if ((fragment.state & 1) != 0) {
                this.scheduleNext = fragment;
                return fragment;
            }
            fragment = fragment.older;
        }
    }

    public void updateAssignment(RDataAssignment assignment, Status status) {
        if (this.assignments.remove(assignment)) {
            --this.scheduledCount;
        }
    }

    public void updateFragment(Fragment<V> fragment, V rObject) {
        if ((fragment.state & 2) != 0) {
            throw new IllegalStateException();
        }
        fragment.rObject = rObject;
        if ((fragment.state & 1) != 0) {
            --this.scheduledCount;
        }
        fragment.state = (byte)2;
    }

    public static final class Fragment<W>
    extends RDataSubset {
        private static final byte SCHEDULED = 1;
        private static final byte SET = 2;
        private final long number;
        private @Nullable W rObject;
        private Fragment<W> newer;
        private Fragment<W> older;
        private byte state;

        Fragment(long number, long rowBeginIdx, long rowCount, long columnBeginIdx, long columnCount) {
            super(rowBeginIdx, rowCount, columnBeginIdx, columnCount);
            this.number = number;
        }

        public @Nullable W getRObject() {
            return this.rObject;
        }

        public String toString() {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("LazyRStore$Fragment");
            sb.append(" " + this.number);
            sb.addProp("rows", '[', this.getRowBeginIdx(), this.getRowEndIdx(), ')');
            sb.addProp("columns", '[', this.getColumnBeginIdx(), this.getColumnEndIdx(), ')');
            return sb.toString();
        }
    }

    public static interface Updater<T> {
        public void scheduleUpdate(LazyRStore<T> var1, @Nullable RDataAssignment var2, @Nullable Fragment<T> var3, int var4, ProgressMonitor var5);
    }
}

