/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.Iterator;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.renv.core.RNumVersion;

@NonNullByDefault
public class RNumVersionConstraint {
    public static final byte NO_OP = 0;
    public static final byte EQUAL = 1;
    public static final byte UNEQUAL = 2;
    public static final byte SMALLER_EQUAL = 3;
    public static final byte SMALLER = 4;
    public static final byte GREATER_EQUAL = 5;
    public static final byte GREATER = 6;
    public static final RNumVersionConstraint ANY = new RNumVersionConstraint(0, RNumVersion.NONE);
    private final byte op;
    private final RNumVersion version;

    public static RNumVersionConstraint create(byte op, RNumVersion version) {
        ObjectUtils.nonNullAssert((Object)version);
        switch (op) {
            case 0: {
                if (version == RNumVersion.NONE) {
                    return ANY;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new RNumVersionConstraint(op, version);
            }
        }
        throw new IllegalArgumentException("operator= " + op);
    }

    public static RNumVersionConstraint create(String s, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > s.length() || startIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        if (startIndex == endIndex) {
            return ANY;
        }
        return new RNumVersionConstraint(s, startIndex, endIndex);
    }

    public static RNumVersionConstraint create(String s) {
        if (s.isEmpty()) {
            return ANY;
        }
        return new RNumVersionConstraint(s, 0, s.length());
    }

    private RNumVersionConstraint(byte op, RNumVersion version) {
        this.op = op;
        this.version = version;
    }

    private RNumVersionConstraint(String s, int startIndex, int endIndex) {
        if (endIndex - startIndex >= 2 && s.charAt(startIndex + 1) == '=') {
            switch (s.charAt(startIndex)) {
                case '!': {
                    this.op = (byte)2;
                    startIndex += 2;
                    break;
                }
                case '<': {
                    this.op = (byte)3;
                    startIndex += 2;
                    break;
                }
                case '=': {
                    this.op = 1;
                    startIndex += 2;
                    break;
                }
                case '>': {
                    this.op = (byte)5;
                    startIndex += 2;
                    break;
                }
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.op = 0;
                    break;
                }
                default: {
                    this.op = (byte)-1;
                    break;
                }
            }
        } else {
            switch (s.charAt(startIndex)) {
                case '<': {
                    this.op = (byte)4;
                    ++startIndex;
                    break;
                }
                case '>': {
                    this.op = (byte)6;
                    ++startIndex;
                    break;
                }
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.op = 0;
                    break;
                }
                default: {
                    this.op = (byte)-1;
                }
            }
        }
        block12 : switch (this.op) {
            case -1: {
                throw new IllegalArgumentException("Unknown operator");
            }
            case 0: {
                break;
            }
            default: {
                while (startIndex < endIndex) {
                    switch (s.charAt(startIndex)) {
                        case '\t': 
                        case ' ': {
                            ++startIndex;
                            break;
                        }
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block12;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid version number");
                        }
                    }
                }
                break block12;
            }
        }
        this.version = RNumVersion.create(s.substring(startIndex, endIndex));
    }

    public byte getOperator() {
        return this.op;
    }

    public RNumVersion getVersion() {
        return this.version;
    }

    public boolean isSatisfiedBy(RNumVersion version2) {
        switch (this.version != RNumVersion.NONE ? this.op : (byte)0) {
            case 1: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) == 0;
            }
            case 2: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) != 0;
            }
            case 3: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) <= 0;
            }
            case 4: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) < 0;
            }
            case 5: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) >= 0;
            }
            case 6: {
                return RNumVersion.compare(version2.getNums(), this.version.getNums()) > 0;
            }
        }
        return true;
    }

    public boolean isSatisfiedByAny(Iterator<RNumVersion> version2) {
        switch (this.version != RNumVersion.NONE ? this.op : (byte)0) {
            case 1: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) != 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) == 0) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) > 0) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) >= 0) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) < 0) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                ImIntList nums1 = this.version.getNums();
                while (version2.hasNext()) {
                    if (RNumVersion.compare(version2.next().getNums(), nums1) <= 0) continue;
                    return true;
                }
                return false;
            }
        }
        return version2.hasNext();
    }

    public boolean isSatisfiedByAny(Iterable<RNumVersion> version2) {
        return this.isSatisfiedByAny(version2.iterator());
    }

    public int hashCode() {
        return this.op * 31 + this.version.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof RNumVersionConstraint)) break block3;
                RNumVersionConstraint other = (RNumVersionConstraint)obj;
                if (this.op == other.op && this.version.equals(other.version)) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        String versionString = this.version.toString();
        return switch (this.op) {
            case 1 -> "== " + versionString;
            case 2 -> "!= " + versionString;
            case 3 -> "<= " + versionString;
            case 4 -> "< " + versionString;
            case 5 -> ">= " + versionString;
            case 6 -> "> " + versionString;
            default -> versionString;
        };
    }
}

