/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.rj.renv.core.REnvCoreInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.renv.core.BasicRLibGroup;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.util.RVersion;

@NonNullByDefault
public class BasicREnvConfiguration
implements REnvConfiguration {
    public static final String DEFAULT_R_DOC_DIRECTORY = "${r_home}/doc";
    public static final String DEFAULT_R_SHARE_DIRECTORY = "${r_home}/share";
    public static final String DEFAULT_R_INCLUDE_DIRECTORY = "${r_home}/include";
    public static final ImList<String> DEFAULT_LIB_GROUP_IDS = ImCollections.newList((Object[])new String[]{"r.common", "r.user", "r.site", "r.default"});
    public static final String DEFAULT_R_DEFAULT_LOCATION_DIRECTORY = "${r_home}/library";
    public static final String DEFAULT_R_SITE_LOCATION_DIRECTORY = "${r_home}/site-library";
    protected static final String NAME_KEY = "name";
    protected static final String R_VERSION_KEY = "RVersion";
    protected static final String R_HOME_DIRECTORY_PATH_KEY = "RHomeDirectory.path";
    protected static final String R_ARCH_CODE_KEY = "RArch.code";
    protected static final String R_SHARE_DIRECTORY_PATH_KEY = "RShareDirectory.path";
    protected static final String R_INCLUDE_DIRECTORY_PATH_KEY = "RIncludeDirectory.path";
    protected static final String R_DOC_DIRECTORY_PATH_KEY = "RDocDirectory.path";
    protected static final String R_LIBS_KEY = "RLibs";
    protected static final String R_LIBS_SITE_DIRECTORY_PATHS_KEY = "RLibs.SiteDirectory.paths";
    protected static final String R_LIBS_USER_DIRECTORY_PATHS_KEY = "RLibs.UserDirectory.paths";
    protected static final String R_LIBS_OTHER_DIRECTORY_PATHS_KEY = "RLibs.OtherDirectory.paths";
    protected static final String STATE_SHARED_TYPE_KEY = "State.Shared.type";
    protected static final String STATE_SHARED_DIRECTORY_PATH_KEY = "State.Shared.Directory.path";
    protected static final String STATE_SHARED_SERVER_URI_KEY = "State.Shared.Server.uri";
    private static final Pattern PATHS_SEPARATOR_PATTERN = Pattern.compile(":,:", 16);
    protected static final Pattern R_HOME_DIRECTORY_VAR_PATTERN = Pattern.compile("${r_home}", 16);
    protected static final Pattern USER_HOME_DIRECTORY_VAR_PATTERN = Pattern.compile("${user_home}", 16);
    protected static final int LOCAL = 1;
    protected static final int REMOTE = 2;
    protected static final int SPEC_SETUP = 4;
    private final REnv rEnv;
    private int flags;
    private String name;
    private @Nullable RVersion rVersion;
    private @Nullable String rHomeDirectory;
    private @Nullable Path rHomeDirectoryPath;
    private @Nullable String rArch;
    private @Nullable String rDocDirectory;
    private @Nullable Path rDocDirectoryPath;
    private @Nullable String rShareDirectory;
    private @Nullable Path rShareDirectoryPath;
    private @Nullable String rIncludeDirectory;
    private @Nullable Path rIncludeDirectoryPath;
    private ImList<? extends RLibGroup> rLibGroups = ImCollections.emptyList();
    private ImList<? extends RLibLocation> rLibLocations = ImCollections.emptyList();
    private final Path stateRootDirectoryPath;
    private String stateSharedType;
    private @Nullable String stateSharedDirectory;
    private @Nullable Path stateSharedDirectoryPath;
    private @Nullable String stateSharedServer;
    private @Nullable URI stateSharedServerUri;
    private Path stateLocalDirectoryPath;
    private final List<Status> pathStatus = new ArrayList<Status>();
    private @Nullable Status status;

    private static @Nullable String objToString(@Nullable Object o) {
        return o instanceof String ? (String)o : null;
    }

    private static List<String> objToPathStringList(@Nullable Object o) {
        block9: {
            Object[] array = null;
            if (o instanceof String) {
                array = PATHS_SEPARATOR_PATTERN.split((String)o);
            } else if (o instanceof List) {
                array = ((List)o).toArray();
            } else if (o instanceof Object[]) {
                array = (Object[])o;
            }
            if (array != null && array.length > 0) {
                ArrayList<String> paths = new ArrayList<String>(array.length);
                int i = 0;
                while (i < array.length) {
                    if (array[i] instanceof String) {
                        String s = REnvUtils.standardizePathString((String)array[i]);
                        if (s != null) {
                            paths.add((String)array[i]);
                        }
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return paths;
            }
        }
        return ImCollections.emptyList();
    }

    public BasicREnvConfiguration(REnv rEnv, Path stateRootDirectoryPath) {
        this.rEnv = (REnv)ObjectUtils.nonNullAssert((Object)rEnv);
        this.name = "";
        this.stateSharedType = "directory";
        this.stateRootDirectoryPath = stateRootDirectoryPath;
    }

    @Override
    public REnv getREnv() {
        return this.rEnv;
    }

    protected void onChanged(String key) {
        this.status = null;
    }

    protected final int getFlags() {
        return this.flags;
    }

    protected void setFlags(int flags) {
        if (Integer.bitCount(flags & 3) > 1) {
            throw new IllegalArgumentException(String.format("flags= 0x%1$08X", flags));
        }
        if (flags != this.flags) {
            this.flags = flags;
            this.onChanged("flags");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        ObjectUtils.nonNullAssert((Object)name);
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.onChanged(NAME_KEY);
        }
    }

    @Override
    public boolean isLocal() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isRemote() {
        return (this.flags & 2) != 0;
    }

    @Override
    public synchronized Status getValidationStatus() {
        Status status = this.status;
        if (status == null) {
            this.resolvePaths();
            status = (Status)ObjectUtils.nonNullAssert((Object)this.status);
        }
        return status;
    }

    public void logValidationStatus(int minSeverity) {
        Status status = this.getValidationStatus();
        if (status.getSeverity() >= minSeverity) {
            REnvCoreInternals.log(status);
        }
    }

    @Override
    public @Nullable RVersion getRVersion() {
        return null;
    }

    protected void setRVersion(@Nullable RVersion rVersion) {
        if (!Objects.equals((Object)rVersion, (Object)this.rVersion)) {
            this.rVersion = rVersion;
            this.onChanged(R_VERSION_KEY);
        }
    }

    @Override
    public @Nullable String getRHomeDirectory() {
        return this.rHomeDirectory;
    }

    @Override
    public @Nullable Path getRHomeDirectoryPath() {
        return this.rHomeDirectoryPath;
    }

    protected void setRHomeDirectory(@Nullable String directory) {
        if (!Objects.equals(directory = REnvUtils.standardizePathString(directory), this.rHomeDirectory)) {
            this.rHomeDirectory = directory;
            this.onChanged(R_HOME_DIRECTORY_PATH_KEY);
        }
    }

    @Override
    public @Nullable String getRArch() {
        return this.rArch;
    }

    protected void setRArch(@Nullable String arch) {
        if (!Objects.equals(arch = this.normalizeRArch(arch), this.rArch)) {
            this.rArch = arch;
            this.onChanged(R_ARCH_CODE_KEY);
        }
    }

    protected byte getOs() {
        return (this.flags & 1) != 0 ? SystemUtils.getLocalOs() : (byte)0;
    }

    protected @Nullable String normalizeRArch(@Nullable String arch) {
        String knownArch;
        if (arch == null || arch.isEmpty()) {
            return null;
        }
        if (arch.charAt(0) == '/') {
            if (arch.length() == 1) {
                return null;
            }
            arch = arch.substring(1);
        }
        if (arch.equals("exec")) {
            return null;
        }
        if (this.getOs() == 1 && (knownArch = SystemUtils.getArch((String)arch)) != null) {
            return knownArch;
        }
        return arch;
    }

    @Override
    public @Nullable String getRShareDirectory() {
        return this.rShareDirectory;
    }

    @Override
    public @Nullable Path getRShareDirectoryPath() {
        return this.rShareDirectoryPath;
    }

    protected void setRShareDirectory(@Nullable String directory) {
        if (!Objects.equals(directory = REnvUtils.standardizePathString(directory), this.rShareDirectory)) {
            this.rShareDirectory = directory;
            this.onChanged(R_SHARE_DIRECTORY_PATH_KEY);
        }
    }

    @Override
    public @Nullable String getRIncludeDirectory() {
        return this.rIncludeDirectory;
    }

    @Override
    public @Nullable Path getRIncludeDirectoryPath() {
        return this.rIncludeDirectoryPath;
    }

    protected void setRIncludeDirectory(@Nullable String directory) {
        if (!Objects.equals(directory = REnvUtils.standardizePathString(directory), this.rIncludeDirectory)) {
            this.rIncludeDirectory = directory;
            this.onChanged(R_INCLUDE_DIRECTORY_PATH_KEY);
        }
    }

    @Override
    public @Nullable String getRDocDirectory() {
        return this.rDocDirectory;
    }

    @Override
    public @Nullable Path getRDocDirectoryPath() {
        return this.rDocDirectoryPath;
    }

    protected void setRDocDirectory(@Nullable String directory) {
        if (!Objects.equals(directory = REnvUtils.standardizePathString(directory), this.rDocDirectory)) {
            this.rDocDirectory = directory;
            this.onChanged(R_DOC_DIRECTORY_PATH_KEY);
        }
        this.rDocDirectory = REnvUtils.standardizePathString(directory);
    }

    @Override
    public ImList<? extends RLibGroup> getRLibGroups() {
        return this.rLibGroups;
    }

    @Override
    public @Nullable RLibGroup getRLibGroup(String id) {
        for (RLibGroup group : this.rLibGroups) {
            if (group.getId() != id) continue;
            return group;
        }
        return null;
    }

    @Override
    public ImList<? extends RLibLocation> getRLibLocations() {
        return this.rLibLocations;
    }

    protected void setRLibGroups(ImList<? extends RLibGroup> libGroups) {
        ObjectUtils.nonNullAssert(libGroups);
        if (!Objects.equals(libGroups, this.rLibGroups)) {
            this.rLibGroups = libGroups;
            this.rLibLocations = REnvCoreInternals.listRLibLocations(libGroups);
            this.onChanged(R_LIBS_KEY);
        }
    }

    @Override
    public String getStateSharedType() {
        return this.stateSharedType;
    }

    protected void setStateSharedType(String type) {
        ObjectUtils.nonNullAssert((Object)type);
        if (!Objects.equals(type, this.stateSharedType)) {
            this.stateSharedType = type.intern();
            this.onChanged(STATE_SHARED_TYPE_KEY);
        }
    }

    @Override
    public @Nullable String getStateSharedDirectory() {
        return this.stateSharedDirectory;
    }

    @Override
    public @Nullable Path getStateSharedDirectoryPath() {
        return this.stateSharedDirectoryPath;
    }

    protected void setStateSharedDirectory(@Nullable String directory) {
        if (!Objects.equals(directory = REnvUtils.standardizePathString(directory), this.stateSharedDirectory)) {
            this.stateSharedDirectory = directory;
            this.stateSharedDirectoryPath = null;
            this.onChanged(STATE_SHARED_DIRECTORY_PATH_KEY);
        }
    }

    @Override
    public @Nullable String getStateSharedServer() {
        return this.stateSharedServer;
    }

    @Override
    public @Nullable URI getStateSharedServerUri() {
        return this.stateSharedServerUri;
    }

    protected void setStateSharedServer(@Nullable String uri) {
        if (!Objects.equals(uri, this.stateSharedServer)) {
            this.stateSharedServer = uri;
            this.stateSharedServerUri = null;
            this.onChanged(STATE_SHARED_SERVER_URI_KEY);
        }
    }

    @Override
    public Path getStateLocalDirectoryPath() {
        return this.stateLocalDirectoryPath;
    }

    protected Path getDataRootDirectory() {
        return this.stateRootDirectoryPath;
    }

    protected void resolvePaths() {
        this.pathStatus.clear();
        if ((this.flags & 5) == 5) {
            this.rHomeDirectoryPath = this.resolveDirectoryPath(this.getRHomeDirectory(), true, "R home directory");
            if (this.rHomeDirectoryPath != null) {
                this.rDocDirectoryPath = this.resolveRDirectoryPath(this.rDocDirectory, false, "R documentation installation directory");
                this.rShareDirectoryPath = this.resolveRDirectoryPath(this.rShareDirectory, false, "R share installation directory");
                this.rIncludeDirectoryPath = this.resolveRDirectoryPath(this.rIncludeDirectory, false, "R include installation directory");
                for (RLibLocation libLocation : this.rLibLocations) {
                    if (!(libLocation instanceof BasicRLibLocation)) continue;
                    ((BasicRLibLocation)libLocation).setDirectoryPath(this.resolveRDirectoryPath(libLocation.getDirectory(), false, "R library location directory"));
                }
            } else {
                this.rDocDirectoryPath = null;
                this.rShareDirectoryPath = null;
                this.rIncludeDirectoryPath = null;
                for (RLibLocation libLocation : this.rLibLocations) {
                    if (!(libLocation instanceof BasicRLibLocation)) continue;
                    ((BasicRLibLocation)libLocation).setDirectoryPath(null);
                }
            }
        }
        this.stateSharedDirectoryPath = this.getStateSharedType() == "directory" && this.stateSharedDirectory != null ? this.resolveDirectoryPath(this.stateSharedDirectory, true, "shared state directory") : this.getDataRootDirectory().resolve("shared");
        this.stateLocalDirectoryPath = this.getDataRootDirectory().resolve("local");
        if (this.getStateSharedType() == "server") {
            URI url = this.resolveURL(this.stateSharedServer, true, "shared state server");
            if (url != null) {
                try {
                    String path;
                    String scheme = url.getScheme();
                    if (scheme == null) {
                        scheme = "http";
                    }
                    if ((path = url.getPath()) == null || path.isEmpty() || path.equals("/")) {
                        path = "/default";
                    } else if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    url = new URI(scheme, url.getUserInfo(), url.getHost(), url.getPort(), path, null, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this.stateSharedServerUri = url;
        }
        this.status = !this.pathStatus.isEmpty() ? new MultiStatus("org.eclipse.statet.rj.services", String.format("Issues detected in R environment configuration '%1$s'.", this.getName()), null, ImCollections.toList(this.pathStatus)) : Status.OK_STATUS;
    }

    protected @Nullable Path resolveDirectoryPath(@Nullable String spec, boolean required, String label) {
        if (spec == null) {
            if (required) {
                this.pathStatus.add((Status)new ErrorStatus("org.eclipse.statet.rj.services", String.format("%1$s: the specification of the resource path is missing.", label)));
            }
            return null;
        }
        try {
            return this.resolvePath(spec);
        }
        catch (Exception e) {
            this.pathStatus.add(Status.newStatus((int)(required ? 4 : 2), (String)"org.eclipse.statet.rj.services", (int)0, (String)String.format("%1$s: failed to resolve the specified resource path '%2$s'.", label, spec), (Throwable)e));
            return null;
        }
    }

    protected @Nullable Path resolveRDirectoryPath(@Nullable String spec, boolean required, String label) {
        if (spec == null) {
            if (required) {
                this.pathStatus.add((Status)new ErrorStatus("org.eclipse.statet.rj.services", String.format("%1$s: the specification of the resource path is missing.", label)));
            }
            return null;
        }
        try {
            Matcher matcher = R_HOME_DIRECTORY_VAR_PATTERN.matcher(spec);
            if (matcher.find()) {
                spec = matcher.replaceAll(Matcher.quoteReplacement(this.rHomeDirectoryPath.toString()));
            }
            if ((matcher = USER_HOME_DIRECTORY_VAR_PATTERN.matcher(spec)).find()) {
                spec = matcher.replaceAll(Matcher.quoteReplacement(FileUtils.getUserHomeDirectory().toString()));
            }
            return this.resolvePath(spec);
        }
        catch (Exception e) {
            this.pathStatus.add(Status.newStatus((int)(required ? 4 : 2), (String)"org.eclipse.statet.rj.services", (int)0, (String)String.format("%1$s: failed to resolve the specified resource path '%2$s'.", label, spec), (Throwable)e));
            return null;
        }
    }

    protected @Nullable URI resolveURL(@Nullable String spec, boolean required, String label) {
        URI url;
        block5: {
            if (spec == null) {
                if (required) {
                    this.pathStatus.add((Status)new ErrorStatus("org.eclipse.statet.rj.services", String.format("%1$s: the specification of the url is missing.", label)));
                }
                return null;
            }
            try {
                url = new URI(spec);
                String host = url.getHost();
                if (host != null && !host.isEmpty()) break block5;
                this.pathStatus.add((Status)new ErrorStatus("org.eclipse.statet.rj.services", String.format("%1$s: The specified url '%2$s' is invalid, a host is required.", label, spec)));
                return null;
            }
            catch (Exception e) {
                this.pathStatus.add((Status)new ErrorStatus("org.eclipse.statet.rj.services", String.format("%1$s: The specified url '%2$s' is invalid.", label, spec), (Throwable)e));
                return null;
            }
        }
        return url;
    }

    protected void load(Map<?, ?> settings) {
        block13: {
            this.setName((String)ObjectUtils.nonNullElse((Object)BasicREnvConfiguration.objToString(settings.get(NAME_KEY)), (Object)""));
            if ((this.getFlags() & 4) == 0) break block13;
            this.setRHomeDirectory(BasicREnvConfiguration.objToString(settings.get(R_HOME_DIRECTORY_PATH_KEY)));
            this.setRArch(BasicREnvConfiguration.objToString(settings.get(R_ARCH_CODE_KEY)));
            this.setRShareDirectory(BasicREnvConfiguration.objToString(settings.get(R_SHARE_DIRECTORY_PATH_KEY)));
            this.setRIncludeDirectory(BasicREnvConfiguration.objToString(settings.get(R_INCLUDE_DIRECTORY_PATH_KEY)));
            this.setRDocDirectory(BasicREnvConfiguration.objToString(settings.get(R_DOC_DIRECTORY_PATH_KEY)));
            ImList<String> libGroupIds = DEFAULT_LIB_GROUP_IDS;
            ArrayList<BasicRLibGroup> libGroups = new ArrayList<BasicRLibGroup>(libGroupIds.size());
            for (String groupId : libGroupIds) {
                ArrayList<RLibLocation> locations = new ArrayList<RLibLocation>();
                String key = this.getLibGroupDirectoryPathsKey(groupId);
                if (key != null) {
                    List<String> pathList = BasicREnvConfiguration.objToPathStringList(settings.get(key));
                    for (String path : pathList) {
                        locations.add(new BasicRLibLocation("user", path, null));
                    }
                }
                if (!this.completeLibGroup(groupId, locations)) continue;
                libGroups.add(new BasicRLibGroup(groupId, this.getLibGroupLabel(groupId, libGroups.size() + 1), (List<? extends RLibLocation>)ImCollections.toList(locations)));
            }
            this.setRLibGroups((ImList<? extends RLibGroup>)ImCollections.toList(libGroups));
            this.setStateSharedType((String)ObjectUtils.nonNullElse((Object)BasicREnvConfiguration.objToString(settings.get(STATE_SHARED_TYPE_KEY)), (Object)"directory"));
            switch (this.getStateSharedType()) {
                case "directory": {
                    this.setStateSharedDirectory(BasicREnvConfiguration.objToString(settings.get(STATE_SHARED_DIRECTORY_PATH_KEY)));
                    break;
                }
                case "server": {
                    this.setStateSharedServer(BasicREnvConfiguration.objToString(settings.get(STATE_SHARED_SERVER_URI_KEY)));
                    break;
                }
            }
        }
    }

    protected @Nullable String getLibGroupDirectoryPathsKey(String id) {
        switch (id) {
            case "r.site": {
                return R_LIBS_SITE_DIRECTORY_PATHS_KEY;
            }
            case "r.user": {
                return R_LIBS_USER_DIRECTORY_PATHS_KEY;
            }
            case "r.common": {
                return R_LIBS_OTHER_DIRECTORY_PATHS_KEY;
            }
        }
        return null;
    }

    protected String getLibGroupLabel(String id, int num) {
        String label = REnvCoreInternals.getRLibGroupLabel(id);
        return label != null ? label : String.format("Libraries %1$s", num);
    }

    protected boolean completeLibGroup(String id, List<RLibLocation> locations) {
        switch (id) {
            case "r.default": {
                locations.clear();
                locations.add(new BasicRLibLocation("r", DEFAULT_R_DEFAULT_LOCATION_DIRECTORY, null));
                return true;
            }
        }
        return true;
    }

    protected @Nullable Path resolvePath(String spec) throws Exception {
        return Path.of(spec, new String[0]);
    }

    public int hashCode() {
        return this.rEnv.hashCode();
    }

    protected boolean equalsType(REnvConfiguration other) {
        return other instanceof BasicREnvConfiguration && this.flags == ((BasicREnvConfiguration)other).flags;
    }

    public boolean equals(@Nullable Object obj) {
        REnvConfiguration other;
        return this == obj || obj instanceof REnvConfiguration && this.rEnv.equals((other = (REnvConfiguration)obj).getREnv()) && this.equalsType(other) && this.name.equals(other.getName()) && ((this.flags & 4) == 0 || Objects.equals(this.rHomeDirectory, other.getRHomeDirectory()) && Objects.equals(this.rArch, other.getRArch()) && Objects.equals(this.rDocDirectory, other.getRDocDirectory()) && Objects.equals(this.rShareDirectory, other.getRShareDirectory()) && Objects.equals(this.rIncludeDirectory, other.getRIncludeDirectory()) && Objects.equals(this.rLibGroups, other.getRLibGroups())) && Objects.equals(this.stateSharedDirectory, other.getStateSharedDirectory()) && Objects.equals(this.stateSharedServer, other.getStateSharedServer());
    }

    public String toString() {
        return this.rEnv.getId() + " (" + this.getName() + ", " + this.getRHomeDirectory() + ")";
    }
}

