/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server.jetty;

import java.net.URI;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.statet.internal.rhelp.core.server.JettyREnvHelpAccess;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.internal.rhelp.core.server.ServerREnvHelpAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rhelp.core.http.ee8.jetty.JettyRHelpUtils;

@NonNullByDefault
public class JettyServerClientSupport
extends ServerClientSupport {
    private final HttpClient httpClient = new HttpClient();

    public JettyServerClientSupport() {
        this.httpClient.setExecutor(JettyRHelpUtils.getExecutor());
        this.httpClient.setAddressResolutionTimeout(10000L);
        this.httpClient.setConnectTimeout(10000L);
    }

    public void configureAdditional(HttpClient additional) {
        additional.setAuthenticationStore(this.httpClient.getAuthenticationStore());
    }

    @Override
    public ServerREnvHelpAccess newREnvHelpAccess(URI url) throws Exception {
        return new JettyREnvHelpAccess(url, this.httpClient);
    }
}

