/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.BasicAssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.LinkedNamesAssistProposal;

@NonNullByDefault
public class WikitextLinkedNamesAssistProposal
extends LinkedNamesAssistProposal<AssistInvocationContext> {
    public static final int IN_FILE = 1;
    private final WikitextNameAccess access;
    private final int mode;

    public WikitextLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, WikitextNameAccess access) {
        super(WikitextLinkedNamesAssistProposal.init(invocationContext, mode, false));
        this.mode = mode;
        this.access = access;
    }

    private static BasicAssistProposal.ProposalParameters<AssistInvocationContext> init(AssistInvocationContext invocationContext, int mode, boolean withRegion) {
        switch (mode) {
            case 1: {
                return new BasicAssistProposal.ProposalParameters(invocationContext, "org.eclipse.statet.ltk.commands.QuickAssistRenameInFile", Messages.Proposal_RenameInFile_label, Messages.Proposal_RenameInFile_description, 90);
            }
        }
        throw new IllegalArgumentException();
    }

    protected void collectPositions(IDocument document, LinkedPositionGroup group) throws BadLocationException {
        WikitextAstNode nameNode;
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)this.access.getAllInUnit());
        int current = allAccess.indexOf((Object)this.access);
        if (current < 0) {
            return;
        }
        int idx = 0;
        WikitextAstNode nameNode2 = (WikitextAstNode)ObjectUtils.nonNullAssert((Object)((WikitextAstNode)this.access.getNameNode()));
        idx = this.addPosition(group, document, nameNode2, idx);
        if (idx == 0) {
            return;
        }
        if (this.mode == 1) {
            int i = current + 1;
            while (i < allAccess.size()) {
                nameNode = (WikitextAstNode)((WikitextNameAccess)allAccess.get(i)).getNameNode();
                if (nameNode != null) {
                    idx = this.addPosition(group, document, nameNode, idx);
                }
                ++i;
            }
        }
        if (this.mode == 1) {
            int i = 0;
            while (i < current) {
                nameNode = (WikitextAstNode)((WikitextNameAccess)allAccess.get(i)).getNameNode();
                if (nameNode != null) {
                    idx = this.addPosition(group, document, nameNode, idx);
                }
                ++i;
            }
        }
    }

    protected int addPosition(LinkedPositionGroup group, IDocument document, WikitextAstNode nameNode, int idx) throws BadLocationException {
        return this.addPosition(group, document, WikitextNameAccess.getTextPosition((WikitextAstNode)nameNode), idx);
    }
}

