/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.model.DslLabelAccess;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.jcommons.collections.ImCollections;

public class LabelAccess
extends DslLabelAccess {
    public static final int A_READ = 0;
    public static final int A_WRITE = 2;
    private final Shared shared;
    private final DslAstNode node;
    private final DslAstNode nameNode;
    int flags;

    protected LabelAccess(Shared shared, DslAstNode node, DslAstNode labelNode) {
        this.shared = shared;
        shared.all.add(this);
        this.node = node;
        this.nameNode = labelNode;
    }

    public int getType() {
        return 65;
    }

    public String getSegmentName() {
        return this.shared.label;
    }

    public String getDisplayName() {
        return this.shared.label;
    }

    public DslElementName getNextSegment() {
        return null;
    }

    public DslAstNode getNode() {
        return this.node;
    }

    public DslAstNode getNameNode() {
        return this.nameNode;
    }

    public List<? extends DslLabelAccess> getAllInUnit() {
        return this.shared.all;
    }

    public boolean isWriteAccess() {
        return (this.flags & 2) != 0;
    }

    static class Shared {
        private final String label;
        private List<DslLabelAccess> all;

        public Shared(String label) {
            this.label = label;
            this.all = new ArrayList<DslLabelAccess>(8);
        }

        public void finish() {
            this.all = ImCollections.toList(this.all);
        }

        public List<DslLabelAccess> getAll() {
            return this.all;
        }
    }
}

