/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.source.ast.Alias;
import org.eclipse.statet.dsl.core.source.ast.Collection;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.KeyValuePair;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.core.source.ast.PropertiesContainer;
import org.eclipse.statet.dsl.core.source.ast.Scalar;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.AbortException;

@NonNullByDefault
public class ElementNameCreator
extends DslAstVisitor {
    private final StringBuilder sb = new StringBuilder();
    private int maxLength = 100;

    public void setLengthSoftLimit(int length) {
        this.maxLength = length;
    }

    public DslElementName createSeqEntry(int index) {
        return DslElementName.create((int)82, (String)Integer.toString(index + 1));
    }

    public DslElementName createMapKey(@Nullable DslAstNode node) {
        if (node == null) {
            return DslElementName.create((int)0, (String)"<?>");
        }
        switch (node.getNodeType()) {
            case SCALAR: {
                return DslElementName.create((int)16, (String)node.getText());
            }
            case ALIAS: {
                return DslElementName.create((int)65, (String)node.getText());
            }
        }
        this.sb.setLength(0);
        try {
            node.acceptInDsl((DslAstVisitor)this);
        }
        catch (InvocationTargetException | AbortException throwable) {
            // empty catch block
        }
        return DslElementName.create((int)96, (String)(this.sb.length() > 1 ? this.sb.substring(1) : ""));
    }

    public void visit(PropertiesContainer node) throws InvocationTargetException {
        node.getNode().acceptInDsl((DslAstVisitor)this);
    }

    public void visit(Collection node) throws InvocationTargetException {
        String open;
        String close = switch (node.getNodeType()) {
            case NodeType.SEQ -> {
                open = " [";
                yield " ]";
            }
            case NodeType.MAP -> {
                open = " {";
                yield " }";
            }
            default -> throw new RuntimeException();
        };
        this.sb.append(open);
        try {
            if (node.hasChildren()) {
                node.getChild(0).acceptInDsl((DslAstVisitor)this);
                int i = 1;
                while (i < node.getChildCount()) {
                    this.sb.append(',');
                    node.getChild(i).acceptInDsl((DslAstVisitor)this);
                    ++i;
                }
            }
        }
        finally {
            this.sb.append(close);
        }
    }

    public void visit(KeyValuePair node) throws InvocationTargetException {
        node.getKey().acceptInDsl((DslAstVisitor)this);
        this.sb.append(" :");
        node.getValue().acceptInDsl((DslAstVisitor)this);
    }

    private void checkLength() {
        if (this.sb.length() >= this.maxLength) {
            this.sb.append(" \u2026");
            throw new AbortException();
        }
    }

    public void visit(Scalar node) throws InvocationTargetException {
        this.checkLength();
        String text = node.getText();
        if (text == null) {
            this.sb.append("<null>");
        } else {
            this.sb.append(" \"");
            int max = Math.max(10, this.maxLength - this.sb.length());
            if (text.length() > max) {
                this.sb.append(text, 0, max);
            } else {
                this.sb.append(text);
            }
            this.sb.append('\"');
        }
    }

    public void visit(Alias node) throws InvocationTargetException {
        this.checkLength();
        String text = node.getText();
        this.sb.append(" *");
        if (text == null) {
            this.sb.append("<missing>");
        } else {
            this.sb.append(text);
        }
    }
}

