/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.rtm.base.ui.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.statushandlers.StatusManager;

public class PerspectiveUtil {
    private static String QUALIFIER = "org.eclipse.statet.rtm.base.ui/perspectives";

    public void updatePerspective(String finalPerspId) {
        IPerspectiveDescriptor currentPersp;
        IWorkbenchPage page;
        if (finalPerspId == null) {
            return;
        }
        Preference.NullableStringPref pref = new Preference.NullableStringPref(QUALIFIER, "SwitchTo-" + finalPerspId + "-.action");
        String prefValue = (String)EPreferences.getInstancePrefs().getPreferenceValue((Preference)pref);
        if ("never".equals(prefValue)) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Object idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", NLS.bind((String)"Unable to find perspective with id ''{0}''.", (Object)finalPerspId)));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        this.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        List<String> preferred = this.getPreferedPerspectives(finalPerspId);
        for (String preferedId : preferred) {
            this.addPerspectiveAndDescendants(preferredPerspIds, preferedId);
        }
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow((boolean)true);
        if (window != null && (page = window.getActivePage()) != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
            return;
        }
        if (!"always".equals(prefValue) && !this.confirmPerspectiveSwitch(window, finalPersp, (Preference<String>)pref)) {
            return;
        }
        try {
            PlatformUI.getWorkbench().showPerspective(finalPerspId, window);
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", 0, NLS.bind((String)"An error occurred when opening the {0} perspective, associated with the R task.", (Object)finalPersp.getLabel()), (Throwable)e));
        }
    }

    private List<String> getPreferedPerspectives(String perspId) {
        return Collections.emptyList();
    }

    private void addPerspectiveAndDescendants(List<String> perspectiveIds, String id) {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectives = registry.getPerspectives();
        int i = 0;
        while (i < perspectives.length) {
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)perspectives[i];
            if (descriptor.getOriginalId().equals(id)) {
                perspectiveIds.add(descriptor.getId());
            }
            ++i;
        }
    }

    private boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp, Preference<String> pref) {
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)Messages.NewTask_PerspSwitch_message, (Object)finalPersp.getLabel()) : NLS.bind((String)Messages.NewTask_PerspSwitch_WithDesc_message, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)Messages.NewTask_PerspSwitch_title, (String)message, null, (boolean)false, null, null);
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String prefValue = result == 2 ? "always" : "never";
            PreferenceUtils.setPrefValue((IScopeContext)InstanceScope.INSTANCE, pref, (Object)prefValue, (int)2);
        }
        return result == 2;
    }
}

