/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.services.RVersion;

@NonNullByDefault
public final class RPlatform
implements Externalizable {
    public static final String OS_WINDOWS = "windows";
    public static final String OS_UNIX = "unix";
    private String osType;
    private String fileSep;
    private String pathSep;
    private String versionString;
    private @Nullable RVersion version;
    private String osName;
    private String osArch;
    private String osVersion;

    public RPlatform(String osType, String fileSep, String pathSep, String version, String osName, String osArch, String osVersion) {
        this.osType = osType;
        this.fileSep = fileSep;
        this.pathSep = pathSep;
        this.versionString = version;
        this.osName = osName;
        this.osArch = osArch;
        this.osVersion = osVersion;
    }

    public RPlatform() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.osType = in.readUTF();
        this.fileSep = in.readUTF();
        this.pathSep = in.readUTF();
        this.versionString = in.readUTF();
        this.osName = in.readUTF();
        this.osArch = in.readUTF();
        this.osVersion = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.osType);
        out.writeUTF(this.fileSep);
        out.writeUTF(this.pathSep);
        out.writeUTF(this.versionString);
        out.writeUTF(this.osName);
        out.writeUTF(this.osArch);
        out.writeUTF(this.osVersion);
    }

    public String getOsType() {
        return this.osType;
    }

    public String getFileSep() {
        return this.fileSep;
    }

    public String getPathSep() {
        return this.pathSep;
    }

    public RVersion getRVersion() {
        RVersion version = this.version;
        if (version == null) {
            this.version = version = new RVersion(this.versionString);
        }
        return version;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getOSArch() {
        return this.osArch;
    }

    public String getOSVersion() {
        return this.osVersion;
    }
}

