/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.gr.Coord;
import org.eclipse.statet.rj.server.gr.GraOp;

@NonNullByDefault
public final class GraOpCmdItem
extends MainCmdItem
implements GraOp {
    private static final int OV_WITHDATA = 0x1000000;
    private static final int OV_WITHSTATUS = 0x8000000;
    private final int devId;
    private final byte op;
    private RJIOExternalizable data;

    public GraOpCmdItem(int devId, byte op) {
        this.devId = devId;
        this.op = op;
    }

    public GraOpCmdItem(int devId, byte op, @Nullable RJIOExternalizable data) {
        this.devId = devId;
        this.op = op;
        if (data != null) {
            this.data = data;
            this.options |= 0x1000000;
        }
    }

    public GraOpCmdItem(RJIO in) throws IOException {
        this.requestId = in.readInt();
        this.options = in.readInt();
        this.devId = in.readInt();
        this.op = in.readByte();
        if ((this.options & 0x8000000) != 0) {
            this.data = new RjsStatus(in);
        } else if ((this.options & 0x1000000) != 0) {
            switch (this.op) {
                case 16: 
                case 17: {
                    this.data = new Coord(in);
                    break;
                }
            }
        }
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeInt(this.options);
        out.writeInt(this.devId);
        out.writeByte(this.op);
        if ((this.options & 0x9000000) != 0) {
            this.data.writeExternal(out);
        }
    }

    @Override
    public byte getCmdType() {
        return 18;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        assert (status != null);
        if (status.getSeverity() == 0) {
            this.options = this.options & 0xF00FFFFF | 0x40000000;
            this.data = null;
        } else {
            this.options = this.options & 0xF00FFFFF | 0x48000000;
            this.data = status;
        }
    }

    public void setAnswer(@Nullable RJIOExternalizable data) {
        this.options = this.options & 0xF00FFFFF | 0x40000000;
        if (data != null) {
            this.options |= 0x1000000;
        }
        this.data = data;
    }

    public int getDevId() {
        return this.devId;
    }

    @Override
    public byte getOp() {
        return this.op;
    }

    @Override
    public boolean isOK() {
        return (this.options & 0x8000000) == 0 || this.data == null;
    }

    @Override
    public @Nullable RjsStatus getStatus() {
        if ((this.options & 0x40000000) != 0) {
            return (this.options & 0x8000000) == 0 ? RjsStatus.OK_STATUS : (RjsStatus)this.data;
        }
        return null;
    }

    @Override
    public @Nullable String getDataText() {
        return null;
    }

    @Override
    public byte @Nullable [] getDataTextUtf8() {
        return null;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (other instanceof GraOpCmdItem) {
            GraOpCmdItem otherItem = (GraOpCmdItem)other;
            if (this.devId == otherItem.devId && this.op == otherItem.op && this.options == otherItem.options) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("GDOpCmdItem ");
        switch (this.op) {
            case 1: {
                sb.append("CLOSE");
                break;
            }
            default: {
                sb.append(this.op);
            }
        }
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        if ((this.options & 0x8000000) != 0) {
            sb.append("\nwith status: ");
            sb.append(this.data == null ? RjsStatus.OK_STATUS : this.data);
        } else if ((this.options & 0x1000000) != 0) {
            sb.append("\n<DATA>\n");
            sb.append(this.data);
            sb.append("\n</DATA>");
        } else {
            sb.append("\n<DATA/>");
        }
        return sb.toString();
    }
}

