/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrFieldNameCompletionProposal;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.r.core.model.RPkgDescrFieldDefinition;
import org.eclipse.statet.r.core.model.RPkgDescriptions;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceUnitModelInfo;
import org.eclipse.statet.r.ui.sourceediting.RPkgDescrAssistInvocationContext;

@NonNullByDefault
public class RPkgDescrFieldCompletionComputer
implements ContentAssistComputer {
    protected static final int COMMON_PRIO = 40;
    protected static final int PRESENT_PRIO = -40;
    private static final Set<RPkgDescrFieldDefinition> COMMON_FIELDS = Set.of(RPkgDescriptions.Type_FIELD, RPkgDescriptions.Authors_R_FIELD, RPkgDescriptions.SystemRequirements_FIELD, RPkgDescriptions.Depends_FIELD, RPkgDescriptions.Imports_FIELD, RPkgDescriptions.Suggests_FIELD, RPkgDescriptions.Enhances_FIELD, RPkgDescriptions.URL_FIELD);
    private int searchMatchRules;

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof RPkgDescrAssistInvocationContext && context.getInvocationContentType() == "RPkgDescr.FieldName") {
            this.computeCompletionProposals((RPkgDescrAssistInvocationContext)context, mode, proposals, monitor);
        }
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof RPkgDescrAssistInvocationContext && context.getInvocationContentType() == "RPkgDescr.FieldName") {
            this.computeContextProposals((RPkgDescrAssistInvocationContext)context, proposals, monitor);
        }
    }

    protected void computeCompletionProposals(RPkgDescrAssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RPkgDescrSourceUnitModelInfo modelInfo = context.getModelInfo();
        String prefix = context.getIdentifierPrefix();
        if (modelInfo == null || prefix == null) {
            return;
        }
        RPkgDescrFieldNameCompletionProposal.FieldNameElementProposalParameters parameters = new RPkgDescrFieldNameCompletionProposal.FieldNameElementProposalParameters(context, context.getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix));
        for (RPkgDescrFieldDefinition fieldDef : RPkgDescriptions.getAllFieldDefinitions()) {
            if ((fieldDef.getFlags() & 0xA) != 0 || !parameters.matchesNamePattern(fieldDef.getName())) continue;
            parameters.fieldDef = fieldDef;
            parameters.baseRelevance = modelInfo != null && modelInfo.getField(fieldDef.getName()) != null ? -40 : ((fieldDef.getFlags() & 1) != 0 || COMMON_FIELDS.contains(fieldDef) ? 40 : 0);
            proposals.add((AssistProposal)new RPkgDescrFieldNameCompletionProposal(parameters));
        }
    }

    public void computeContextProposals(RPkgDescrAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
    }
}

