/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.debug.core.RElementVariable;
import org.eclipse.statet.r.debug.core.RIndexedVariableItem;
import org.eclipse.statet.r.debug.core.RStackFrame;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractDebugHandler
extends AbstractHandler {
    private @Nullable Position expressionPosition;

    protected static void showView(IWorkbenchPart activePart, String viewId) {
        if (activePart.getSite().getId().equals(viewId)) {
            return;
        }
        IWorkbenchPage page = activePart.getSite().getPage();
        if (page == null) {
            page = UIAccess.getActiveWorkbenchPage((boolean)true);
        }
        if (page != null) {
            IViewPart part = page.findView(viewId);
            if (part != null) {
                page.bringToTop((IWorkbenchPart)part);
            } else {
                try {
                    page.showView(viewId);
                }
                catch (PartInitException e) {
                    StatusManager.getManager().handle(e.getStatus());
                }
            }
        }
    }

    protected static Point preparePopup(TextViewer viewer, @Nullable Position position) {
        try {
            if (position != null && !position.isDeleted()) {
                IRegion lineInfo = viewer.getDocument().getLineInformationOfOffset(position.getOffset());
                Region region = position.getOffset() + position.getLength() > lineInfo.getOffset() + lineInfo.getLength() ? new Region(position.getOffset(), lineInfo.getOffset() + lineInfo.getLength() - position.getOffset()) : new Region(position.getOffset(), position.getLength());
                StyledText textWidget = viewer.getTextWidget();
                if (viewer instanceof ITextViewerExtension5) {
                    ((ITextViewerExtension5)viewer).exposeModelRange((IRegion)region);
                }
                IRegion widgetRange = viewer.modelRange2WidgetRange((IRegion)region);
                int midOffset = widgetRange.getOffset() + widgetRange.getLength() / 2;
                Point point = textWidget.getLocationAtOffset(midOffset);
                point.y += textWidget.getLineHeight(midOffset) / 2;
                point = textWidget.toDisplay(point);
                return point;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    protected static @Nullable StructuredViewer getStructuredViewer(IWorkbenchPart part) {
        Viewer viewer;
        IDebugView debugView = (IDebugView)part.getAdapter(IDebugView.class);
        if (debugView != null && (viewer = debugView.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    private static Point getPopupAnchor(Control control) {
        Tree tree;
        TreeItem[] selection;
        if (control instanceof Tree && (selection = (tree = (Tree)control).getSelection()).length > 0) {
            Rectangle bounds = selection[0].getBounds();
            return tree.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
        }
        return null;
    }

    protected static @Nullable Point preparePopup(StructuredViewer viewer, IStructuredSelection selection) {
        viewer.setSelection((ISelection)selection, true);
        return AbstractDebugHandler.getPopupAnchor(viewer.getControl());
    }

    protected static @Nullable Point preparePopup(IWorkbenchPart part) {
        Control widget = null;
        if (part instanceof PageBookView) {
            IPage page = ((PageBookView)part).getCurrentPage();
            if (page != null) {
                widget = page.getControl();
            }
        } else {
            widget = (Control)part.getAdapter(Control.class);
        }
        return AbstractDebugHandler.getPopupAnchor(widget);
    }

    protected static void disposePosition(IDocument document, @Nullable Position position) {
        if (position != null) {
            document.removePosition(position);
        }
    }

    protected RElementVariable getElementVariable(RVariable variable) {
        while (variable != null) {
            if (variable instanceof RElementVariable) {
                return (RElementVariable)variable;
            }
            variable = variable.getParent();
        }
        return null;
    }

    protected long[] getVariableItemIndex(RVariable variable) {
        if (variable instanceof RIndexedVariableItem) {
            return ((RIndexedVariableItem)variable).getIndex();
        }
        return null;
    }

    protected @Nullable String getExpressionText(RElementVariable elementVariable) {
        RElementName elementName = elementVariable.getFQElementName();
        if (elementName != null) {
            return elementName.getDisplayName(3);
        }
        return null;
    }

    protected @Nullable String getExpressionText(ITextSelection textSelection, SourceEditor sourceEditor) {
        if (textSelection.getLength() == 0) {
            try {
                RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)sourceEditor.getDocumentContentInfo());
                IDocument document = sourceEditor.getViewer().getDocument();
                scanner.configure(document);
                IRegion region = scanner.findRWord(textSelection.getOffset(), false, true);
                if (region != null) {
                    String expression = document.get(region.getOffset(), region.getLength());
                    this.expressionPosition = new Position(region.getOffset(), region.getLength());
                    return expression;
                }
            }
            catch (BadLocationException scanner) {}
        } else {
            String selectedText = textSelection.getText();
            String expression = selectedText.trim();
            if (!expression.isEmpty()) {
                if (expression != selectedText && !(textSelection instanceof IBlockTextSelection)) {
                    int offset = textSelection.getOffset() + selectedText.indexOf(expression);
                    this.expressionPosition = new Position(offset, expression.length());
                } else {
                    this.expressionPosition = new Position(textSelection.getOffset(), textSelection.getLength());
                }
                return expression;
            }
        }
        return null;
    }

    protected @Nullable Position markExpressionPosition(IDocument document) {
        if (this.expressionPosition != null) {
            try {
                document.addPosition(this.expressionPosition);
                return this.expressionPosition;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected IAdaptable getViewInput(IWorkbenchPart part) {
        Object input;
        if (part instanceof IDebugView && (input = ((IDebugView)part).getViewer().getInput()) instanceof IAdaptable) {
            return (IAdaptable)input;
        }
        return null;
    }

    private @Nullable IAdaptable getWorkbenchDebugContext(IWorkbenchPart workbenchPart) {
        Object firstElement;
        ISelection contexts;
        if (workbenchPart != null && (contexts = DebugUITools.getDebugContextForPart((IWorkbenchPart)workbenchPart)) instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)contexts).getFirstElement()) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        return DebugUITools.getDebugContext();
    }

    protected @Nullable IDebugElement getContextElement(IAdaptable context, IWorkbenchPart workbenchPart) {
        if (context == null && (context = this.getWorkbenchDebugContext(workbenchPart)) == null) {
            return null;
        }
        if (context instanceof IDebugElement) {
            return (IDebugElement)context;
        }
        if (context instanceof ILaunch) {
            return ((ILaunch)context).getDebugTarget();
        }
        return (IDebugElement)context.getAdapter(IDebugElement.class);
    }

    protected @Nullable RStackFrame getContextStackFrame(IWorkbenchPart workbenchPart) {
        @Nullable IDebugElement contextElement = this.getContextElement(null, workbenchPart);
        if (contextElement != null) {
            return (RStackFrame)contextElement.getAdapter(RStackFrame.class);
        }
        return null;
    }

    protected String addIndex(String name, long[] index) {
        if (name == null) {
            return null;
        }
        if (index == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.append('[');
        sb.append(index[0] + 1L);
        int i = 1;
        while (i < index.length) {
            sb.append(", ");
            sb.append(index[i] + 1L);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

