/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.rmodel.FilteredSourceFrame;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.PackageReferences;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModelManager;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RSrcFrame;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.statet.r.core.source.ast.RAstNode;

@NonNullByDefault
public final class RModel {
    public static final String R_TYPE_ID = "R";
    public static final String RPKG_DESCRIPTION_TYPE_ID = "RPkg.Descr";
    public static final String RPKG_SPEC_VALUE_TYPE_ID = "RPkg.SpecValue";
    public static final RElementName GLOBAL_ENV_NAME = RElementName.create(37, ".GlobalEnv");

    public static RModelManager getRModelManager() {
        return RCorePlugin.getInstance().getRModelManager();
    }

    public static @Nullable RSourceUnitModelInfo getRModelInfo(@Nullable SourceUnitModelInfo modelInfo) {
        if (modelInfo != null) {
            if (modelInfo instanceof RSourceUnitModelInfo) {
                return (RSourceUnitModelInfo)modelInfo;
            }
            for (Object aAttachment : modelInfo.getAttachments()) {
                if (!(aAttachment instanceof RSourceUnitModelInfo)) continue;
                return (RSourceUnitModelInfo)aAttachment;
            }
        }
        return null;
    }

    public static @Nullable RSrcStrFrame searchFrame(@Nullable RAstNode node) {
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof RSrcStrFrame)) continue;
                return (RSrcStrFrame)attachment;
            }
            node = node.getRParent();
        }
        return null;
    }

    private static @Nullable String checkValidPkgFrame(RFrame<?> frame) {
        RElementName elementName;
        return frame.getFrameType() == 2 && (elementName = frame.getElementName()) != null ? elementName.getSegmentName() : null;
    }

    private static boolean isValidFrame(RFrame<?> frame, @Nullable String pkgName) {
        String name;
        return pkgName == null || (name = RModel.checkValidPkgFrame(frame)) != null && name.equals(pkgName);
    }

    private static boolean isValidFrame(RFrame<?> frame, @Nullable Set<String> pkgNames) {
        String name;
        return pkgNames == null || (name = RModel.checkValidPkgFrame(frame)) != null && pkgNames.contains(name);
    }

    public static void collectDirectFrames(RFrame<?> frame, @Nullable RElementName expliciteScope, List<RFrame<?>> list) {
        String pkgName = expliciteScope != null && RElementName.isPackageFacetScopeType(expliciteScope.getType()) ? expliciteScope.getSegmentName() : null;
        int idx = 0;
        if (RModel.isValidFrame(frame, pkgName)) {
            list.add(frame);
        }
        while (idx < list.size()) {
            List<RFrame<?>> ps = list.get(idx++).getPotentialParents();
            for (RFrame<?> parent : ps) {
                if (!RModel.isValidFrame(parent, pkgName) || list.contains(parent)) continue;
                list.add(parent);
            }
        }
    }

    public static List<? extends RFrame<?>> createDirectFrameList(RFrame<?> frame) {
        ArrayList list = new ArrayList();
        RModel.collectDirectFrames(frame, null, list);
        return list;
    }

    public static Set<String> createImportedPackageList(RSourceUnitModelInfo modelInfo) {
        HashSet<String> importedPackages = new HashSet<String>();
        importedPackages.add("base");
        if (modelInfo != null) {
            PackageReferences packages = modelInfo.getReferencedPackages();
            for (String name : packages.getAllPackageNames()) {
                if (!packages.isImported(name)) continue;
                importedPackages.add(name);
            }
        }
        return importedPackages;
    }

    public static List<RSrcFrame<?>> createProjectFrameList(@Nullable RProject project1, RSourceUnit scope, boolean pkgImports, boolean projectDependencies, @Nullable Set<String> importedPackages, @Nullable Set<String> pkgNames) throws CoreException {
        ArrayList list = new ArrayList();
        RModelManager manager = RModel.getRModelManager();
        if (project1 == null && scope instanceof WorkspaceSourceUnit) {
            if (pkgImports && importedPackages == null) {
                importedPackages = RModel.createImportedPackageList((RSourceUnitModelInfo)scope.getModelInfo(R_TYPE_ID, 2, null));
            }
            project1 = RProjects.getRProject(((WorkspaceSourceUnit)scope).getResource().getProject());
        }
        if (pkgImports && importedPackages == null) {
            importedPackages = ImCollections.emptySet();
        }
        if (pkgNames == null) {
            pkgNames = new HashSet<String>();
        }
        if (project1 != null) {
            RSrcFrame<?> frame = manager.getProjectFrame(project1);
            if (frame != null && (projectDependencies || pkgImports && RModel.isValidFrame(frame, (Set<String>)importedPackages))) {
                String name = RModel.checkValidPkgFrame(frame);
                if (name != null) {
                    pkgNames.add(name);
                }
                list.add(new FilteredSourceFrame(frame, scope));
            }
            ArrayList<RProjectNature> projects = new ArrayList<RProjectNature>();
            try {
                IProject[] referencedProjects;
                IProject[] iProjectArray = referencedProjects = project1.getProject().getReferencedProjects();
                int n = referencedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    RProjectNature rProject = RProjectNature.getRProject(referencedProject);
                    if (rProject != null) {
                        projects.add(rProject);
                    }
                    ++n2;
                }
            }
            catch (CoreException referencedProjects) {
                // empty catch block
            }
            int i = 0;
            while (i < projects.size()) {
                RProject project = (RProject)projects.get(i);
                RSrcFrame<?> frame2 = manager.getProjectFrame(project);
                if (frame2 != null && (projectDependencies || pkgImports && RModel.isValidFrame(frame2, (Set<String>)importedPackages))) {
                    String name = RModel.checkValidPkgFrame(frame2);
                    if (name != null) {
                        pkgNames.add(name);
                    }
                    list.add(frame2);
                }
                try {
                    IProject[] referencedProjects;
                    IProject[] iProjectArray = referencedProjects = project.getProject().getReferencedProjects();
                    int n = referencedProjects.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProject referencedProject = iProjectArray[n3];
                        RProjectNature rProject = RProjectNature.getRProject(referencedProject);
                        if (rProject != null && !projects.contains(rProject)) {
                            projects.add(rProject);
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (pkgImports && importedPackages != null) {
            for (String pkgName : importedPackages) {
                RSrcFrame<?> frame;
                if (pkgNames.contains(pkgName) || (frame = manager.getPkgProjectFrame(pkgName)) == null) continue;
                list.add(frame);
            }
        }
        return list;
    }

    public static List<? extends RSrcFrame<?>> createProjectFrameList(@Nullable RProject project1, RSourceUnit scope) throws CoreException {
        return RModel.createProjectFrameList(project1, scope, true, true, null, null);
    }

    public static List<SourceElement> searchDeclaration(RElementAccess access, RSourceUnit su) throws CoreException {
        assert (access != null);
        ArrayList<SourceElement> list = new ArrayList<SourceElement>();
        if (access.getSegmentName() == null) {
            return list;
        }
        RSrcStrFrame suFrame = access.getFrame();
        List<RFrame<?>> directFrames = RModel.createDirectFrameList(suFrame);
        for (RFrame<?> frame : directFrames) {
            if (!RModel.checkFrame(frame, access, list)) continue;
            return list;
        }
        List<RSrcFrame<?>> projectFrames = RModel.createProjectFrameList(null, su);
        for (RSrcFrame<?> frame : projectFrames) {
            if (!RModel.checkFrame(frame, access, list)) continue;
            return list;
        }
        return list;
    }

    private static boolean checkFrame(RFrame<?> frame, RElementAccess access, List<SourceElement> list) {
        List<?> elements = frame.getModelChildren(null);
        for (RElement element : elements) {
            RElementName name = element.getElementName();
            if (name == null || access.getType() != name.getType() || !Objects.equals(access.getSegmentName(), name.getSegmentName()) || !(element instanceof SourceElement)) continue;
            list.add((SourceElement)element);
        }
        if (!list.isEmpty()) {
            SourceElement first = list.get(0);
            switch (first.getElementType() & 0xFF0) {
                case 1408: 
                case 1552: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static @Nullable RElementName getFQElementName(@Nullable RElement var) {
        List<RElementName> segments = RModel.getFQFullName(var, 0);
        return segments != null ? RElementName.create(segments) : null;
    }

    private static @Nullable List<RElementName> getFQFullName(@Nullable RElement var, int count) {
        RElementName elementName;
        if (var != null && (elementName = var.getElementName()) != null) {
            List<RElementName> segments;
            RElementName segment = elementName;
            do {
                ++count;
            } while ((segment = segment.getNextSegment()) != null);
            RElementName scope = elementName.getScope();
            if (scope != null) {
                if (RElementName.isScopeType(scope.getType())) {
                    segments = new ArrayList<RElementName>(count + 1);
                    segments.add(scope);
                } else {
                    segments = RModel.getFQFullName((RElement)var.getModelParent(), count);
                }
            } else {
                segments = RElementName.isScopeType(elementName.getType()) ? new ArrayList<RElementName>(count) : RModel.getFQFullName((RElement)var.getModelParent(), count);
            }
            if (segments != null) {
                RElementName segment2 = elementName;
                do {
                    segments.add(segment2);
                } while ((segment2 = segment2.getNextSegment()) != null);
                return segments;
            }
        }
        return null;
    }

    private RModel() {
    }
}

