/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.ExportedRClass;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.internal.r.core.builder.ExportedRMethod;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.rlang.RClassSrcElement;
import org.eclipse.statet.r.core.model.rlang.RLangSrcElement;
import org.eclipse.statet.r.core.model.rlang.RMethodSrcElement;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.project.RProject;

@NonNullByDefault
public class RModelIndexOrder {
    protected final RProjectNature rProject;
    protected final String projectName;
    protected @Nullable RPkgData pkgData;
    protected final List<Result> updated = new ArrayList<Result>();
    protected final List<String> removed = new ArrayList<String>();
    protected final List<String> modelTypeIds;
    protected final boolean isFullBuild;

    public RModelIndexOrder(RProject rProject, List<String> modelTypeIds, boolean isFullBuild) {
        this.rProject = (RProjectNature)rProject;
        this.projectName = rProject.getProject().getName();
        this.modelTypeIds = modelTypeIds;
        this.isFullBuild = isFullBuild;
    }

    protected @Nullable Result createResult(RSourceUnit sourceUnit, @Nullable RSourceUnitModelInfo model) {
        if (model == null) {
            return null;
        }
        RSrcStrFrame topFrame = model.getTopFrame();
        List children = topFrame.getModelChildren(null);
        ArrayList<ExportedRElement> exports = new ArrayList<ExportedRElement>(children.size());
        RUnitElement root = new RUnitElement(sourceUnit, exports);
        for (RLangSrcElement element : children) {
            int n = element.getElementType();
            switch (n & 0xF00) {
                case 1280: {
                    exports.add(new ExportedRMethod((RLangSrcElement<?>)root, (RMethodSrcElement)element));
                    break;
                }
                case 1024: {
                    exports.add(new ExportedRClass((RLangSrcElement<?>)root, (RClassSrcElement)element));
                    break;
                }
                case 1536: {
                    exports.add(new ExportedRElement(root, element));
                    break;
                }
            }
        }
        HashSet<String> names = new HashSet<String>();
        names.addAll(topFrame.getAllAccessNames());
        Map<String, ? extends RSrcStrFrame> frames = model.getReferencedFrames();
        for (RSrcStrFrame rSrcStrFrame : frames.values()) {
            names.addAll(rSrcStrFrame.getAllAccessNames());
        }
        return new Result(root, names);
    }

    protected void addRemovedUnit(String unitId) {
        if (!this.isFullBuild) {
            this.removed.add(unitId);
        }
    }

    protected static class Result {
        public final String unitId;
        public final RUnitElement exportedElement;
        public final Set<String> defaultNames;

        public Result(RUnitElement root, Set<String> defaultNames) {
            this.unitId = root.getId();
            this.exportedElement = root;
            this.defaultNames = defaultNames;
        }
    }
}

