/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.statet.internal.r.core.pkgmanager.BasicRPkgVersions;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgData;
import org.eclipse.statet.internal.r.core.pkgmanager.ReverseReferences;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.model.core.NamedElement;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RPkgVersions;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.BasicRPkgList;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibPaths;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;

public class FullRPkgSet
implements IRPkgSet.Ext {
    public static final FullRPkgSet DUMMY = new FullRPkgSet();
    private final REnv rEnv;
    private int providing;
    private final RLibPaths rLibPaths;
    private final BasicRPkgCompilation<IRPkgInfoAndData> installed;
    private final List<String> priorities = new ArrayList<String>((Collection<String>)DEFAULT_PRIORITIES);
    private final RPkgCompilation<IRPkgData> available;
    private final BasicRPkgList<ReverseReferences> reverse;
    private List<String> names;

    private FullRPkgSet() {
        this.rEnv = null;
        this.rLibPaths = null;
        this.installed = new BasicRPkgCompilation(0);
        this.available = new BasicRPkgCompilation(0);
        this.reverse = new BasicRPkgList(0);
    }

    public FullRPkgSet(REnv rEnv, RLibPaths rLibPaths, RPkgCompilation<IRPkgData> available) {
        this.rEnv = rEnv;
        this.providing = 17;
        if (!available.getSources().isEmpty()) {
            this.providing |= 0x20;
        }
        this.rLibPaths = rLibPaths;
        this.installed = new BasicRPkgCompilation(rLibPaths.getRLibLocations().size());
        this.available = available;
        this.reverse = new BasicRPkgList(4);
    }

    public @NonNull REnv getREnv() {
        return this.rEnv;
    }

    public int getProviding() {
        return this.providing;
    }

    public @NonNull RLibPaths getRLibPaths() {
        return this.rLibPaths;
    }

    @Override
    public synchronized List<String> getNames() {
        if (this.names == null) {
            List availableNames = this.available.getNames();
            SortedArraySet names = new SortedArraySet((Object[])availableNames.toArray(new String[availableNames.size() + 16]), availableNames.size(), (Comparator)RPkgUtils.NAMES_COLLATOR);
            names.addAll((Collection)this.installed.getNames());
            this.names = Collections.unmodifiableList(names);
        }
        return this.names;
    }

    public BasicRPkgCompilation<IRPkgInfoAndData> getInstalled() {
        return this.installed;
    }

    @Override
    public List<String> getPriorities() {
        return this.priorities;
    }

    public RPkgCompilation<IRPkgData> getAvailable() {
        return this.available;
    }

    private List<RPkgList<? extends IRPkgData>> getAll() {
        return ImCollections.concatList((Collection)this.installed.getAll(), (Collection)this.available.getAll());
    }

    public ReverseReferences getReverse(String name) {
        ReverseReferences info;
        int idx = this.reverse.indexOf(name);
        if (idx >= 0) {
            info = (ReverseReferences)this.reverse.get(idx);
        } else {
            RPkgList depends = null;
            RPkgList imports = null;
            RPkgList linkingTo = null;
            RPkgList suggests = null;
            RPkgList enhances = null;
            Predicate<NamedElement> isNameEqual = e -> name.equals(e.getName());
            for (RPkgList<? extends IRPkgData> list : this.getAll()) {
                int i = 0;
                while (i < list.size()) {
                    IRPkgData pkg = (IRPkgData)list.get(i);
                    if (!isNameEqual.test((NamedElement)pkg)) {
                        if (pkg.getDepends().anyMatch(isNameEqual)) {
                            if (depends == null) {
                                depends = new BasicRPkgList(4);
                            }
                            this.addRev((BasicRPkgList<BasicRPkgVersions>)depends, pkg);
                        }
                        if (pkg.getImports().anyMatch(isNameEqual)) {
                            if (imports == null) {
                                imports = new BasicRPkgList(4);
                            }
                            this.addRev((BasicRPkgList<BasicRPkgVersions>)imports, pkg);
                        }
                        if (pkg.getLinkingTo().anyMatch(isNameEqual)) {
                            if (linkingTo == null) {
                                linkingTo = new BasicRPkgList(4);
                            }
                            this.addRev((BasicRPkgList<BasicRPkgVersions>)linkingTo, pkg);
                        }
                        if (pkg.getSuggests().anyMatch(isNameEqual)) {
                            if (suggests == null) {
                                suggests = new BasicRPkgList(4);
                            }
                            this.addRev((BasicRPkgList<BasicRPkgVersions>)suggests, pkg);
                        }
                        if (pkg.getEnhances().anyMatch(isNameEqual)) {
                            if (enhances == null) {
                                enhances = new BasicRPkgList(4);
                            }
                            this.addRev((BasicRPkgList<BasicRPkgVersions>)enhances, pkg);
                        }
                    }
                    ++i;
                }
            }
            info = new ReverseReferences(name, (RPkgList<? extends RPkgVersions>)(depends != null ? depends : RPkgList.emptyList()), (RPkgList<? extends RPkgVersions>)(imports != null ? imports : RPkgList.emptyList()), (RPkgList<? extends RPkgVersions>)(linkingTo != null ? linkingTo : RPkgList.emptyList()), (RPkgList<? extends RPkgVersions>)(suggests != null ? suggests : RPkgList.emptyList()), (RPkgList<? extends RPkgVersions>)(enhances != null ? enhances : RPkgList.emptyList()));
            this.reverse.add(~idx, (Object)info);
        }
        return info;
    }

    private void addRev(BasicRPkgList<BasicRPkgVersions> depends, RPkg v) {
        depends.compute((NamedElement)v, (add, versions) -> {
            if (versions != null) {
                versions.addVersion(v.getVersion());
                return versions;
            }
            return new BasicRPkgVersions(v.getName(), v.getVersion());
        });
    }

    public void checkPkgInfo(RPkgData pkg) {
        String priority = pkg.getPriority();
        if (!this.priorities.contains(priority)) {
            pkg.setPriority("other");
        }
    }
}

