/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.statet.ecommons.ui.components.ShortedLabel;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.IProgressInfo;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.progress.WorkbenchJob;

public class ToolProgressGroup {
    private static final int TOTAL_TICKS = 65535;
    private static final IProgressInfo DUMMY_INFO = new IProgressInfo(){

        public String getLabel() {
            return "";
        }

        public String getSubLabel() {
            return "";
        }

        public double getWorked() {
            return 0.0;
        }

        public ToolRunnable getRunnable() {
            return null;
        }
    };
    private static final int SCHEDULE_ON_EVENT = 50;
    private static final int SCHEDULE_DEFAULT = 150;
    private final DebugEventListener debugEventListener;
    private final Job refreshJob;
    private Composite composite;
    private Label imageLabel;
    private ShortedLabel mainLabel;
    private ProgressBar progressBar;
    private ShortedLabel subLabel;
    private ToolInfo toolInfo = new ToolInfo(null);

    public ToolProgressGroup(Composite parent) {
        this.debugEventListener = new DebugEventListener();
        this.refreshJob = new RefreshJob();
        this.createControls(parent);
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.addDebugEventListener((IDebugEventSetListener)this.debugEventListener);
        }
    }

    private void createControls(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolProgressGroup.this.dispose();
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        this.composite.setLayout((Layout)layout);
        this.imageLabel = new Label(this.composite, 0);
        GridData gd = new GridData(16384, 128, false, false);
        gd.verticalSpan = 2;
        gd.verticalIndent = 2;
        gd.widthHint = 16;
        gd.heightHint = 16;
        this.imageLabel.setLayoutData((Object)gd);
        this.mainLabel = new ShortedLabel(this.composite, 0);
        this.mainLabel.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.subLabel = new ShortedLabel(this.composite, 0);
        gd = new GridData(4, 0x1000000, true, false);
        this.subLabel.getControl().setLayoutData((Object)gd);
        this.progressBar = new ProgressBar(this.composite, 256);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(65535);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.progressBar.setLayoutData((Object)gd);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setTool(ToolProcess tool, boolean directRefresh) {
        this.toolInfo = new ToolInfo(tool);
        this.refresh(directRefresh);
    }

    public void refresh(boolean directRefresh) {
        if (directRefresh) {
            this.refreshJob.cancel();
            this.internalRefresh();
            this.refreshJob.schedule(150L);
        } else {
            this.refreshJob.schedule(50L);
        }
    }

    private void internalRefresh() {
        if (!UIAccess.isOkToUse((Control)this.composite)) {
            return;
        }
        ToolInfo info = this.toolInfo;
        ToolController controller = info.process != null ? info.process.getController() : null;
        IProgressInfo progressInfo = controller != null ? controller.getProgressInfo() : DUMMY_INFO;
        Image image = null;
        ToolRunnable runnable = progressInfo.getRunnable();
        if (runnable != null) {
            image = NicoUITools.getImage(runnable);
        }
        if (image == null && info.process != null) {
            image = this.getToolImage(info);
        }
        if (image == null) {
            image = NicoUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.nico/images/obj/task.commanddummy");
        }
        if (!image.equals((Object)this.imageLabel.getImage())) {
            this.imageLabel.setImage(image);
        }
        this.mainLabel.setText(progressInfo.getLabel());
        this.subLabel.setText(progressInfo.getSubLabel());
        this.progressBar.setSelection((int)(Math.max(progressInfo.getWorked(), 0.0) * 65535.0));
    }

    private Image getToolImage(ToolInfo tool) {
        if (tool.imageCache == null) {
            tool.imageCache = NicoUITools.getImage(tool.process);
        }
        return tool.imageCache;
    }

    private void dispose() {
        this.toolInfo = new ToolInfo(null);
        this.refreshJob.cancel();
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.removeDebugEventListener((IDebugEventSetListener)this.debugEventListener);
        }
    }

    private class DebugEventListener
    implements IDebugEventSetListener {
        private DebugEventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            ToolInfo info = ToolProgressGroup.this.toolInfo;
            if (info.process != null) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getSource() == info.process.getQueue() && Queue.isStateChange((DebugEvent)event)) {
                        Queue.StateDelta delta = (Queue.StateDelta)event.getData();
                        info.scheduleRefresh = delta.newState == 2;
                        ToolProgressGroup.this.refreshJob.schedule(50L);
                    }
                    ++n2;
                }
            }
        }
    }

    private class RefreshJob
    extends WorkbenchJob {
        RefreshJob() {
            super("ToolProgress Refresh");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ToolProgressGroup.this.internalRefresh();
            ToolInfo info = ToolProgressGroup.this.toolInfo;
            if (info.scheduleRefresh) {
                this.schedule(150L);
            }
            return Status.OK_STATUS;
        }
    }

    private static class ToolInfo {
        final ToolProcess process;
        Image imageCache;
        boolean scheduleRefresh = false;

        ToolInfo(ToolProcess process) {
            this.process = process;
            this.scheduleRefresh = process != null ? process.getToolStatus().isRunning() : false;
        }
    }
}

