/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.prefs.ColorPref;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.console.ExtStylingConfiguration;
import org.eclipse.statet.internal.nico.ui.console.ExtStylingEngine;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.ui.NicoUIPreferences;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.graphics.Color;

@NonNullByDefault
public class NIConsoleStreamAdapter {
    private static final List<String> STREAM_IDS = ImCollections.newList((Object[])new String[]{"org.eclipse.statet.nico.ui.InfoStream", "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "org.eclipse.statet.nico.ui.SystemOutputStream", "org.eclipse.statet.nico.ui.InfoStream-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks"});
    private static final StreamConfigDef INFO_STREAM_DEF = new StreamConfigDef("org.eclipse.statet.nico.ui.InfoStream", "InfoStream.color", "InfoStream.bold", "InfoStream.italic");
    private static final StreamConfigDef OTHER_TASKS_INFO_STREAM_DEF = new StreamConfigDef("org.eclipse.statet.nico.ui.InfoStream-OtherTasks", "InfoStream.color", "InfoStream.bold", "InfoStream.italic", NicoUIPreferences.OUTPUT_OTHER_TASKS_BACKGROUND_COLOR_PREF);
    private static final StreamConfigDef STD_INPUT_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "StdInputStream.color", "StdInputStream.bold", "StdInputStream.italic");
    private static final StreamConfigDef OTHER_TASKS_STD_INPUT_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks", "StdInputStream.color", "StdInputStream.bold", "StdInputStream.italic", NicoUIPreferences.OUTPUT_OTHER_TASKS_BACKGROUND_COLOR_PREF);
    private static final StreamConfigDef STD_OUTPUT_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", "StdOutputStream.color", "StdOutputStream.bold", "StdOutputStream.italic");
    private static final StreamConfigDef OTHER_TASKS_STD_OUTPUT_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks", "StdOutputStream.color", "StdOutputStream.bold", "StdOutputStream.italic", NicoUIPreferences.OUTPUT_OTHER_TASKS_BACKGROUND_COLOR_PREF);
    private static final StreamConfigDef STD_ERROR_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "StdErrorStream.color", "StdErrorStream.bold", "StdErrorStream.italic");
    private static final StreamConfigDef OTHER_TASKS_STD_ERROR_STREAM_DEF = new StreamConfigDef("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks", "StdErrorStream.color", "StdErrorStream.bold", "StdErrorStream.italic", NicoUIPreferences.OUTPUT_OTHER_TASKS_BACKGROUND_COLOR_PREF);
    private static final StreamConfigDef SYSTEM_OUTPUT_STREAM_DEF = new StreamConfigDef("org.eclipse.statet.nico.ui.SystemOutputStream", "SystemOutputStream.color", "SystemOutputStream.bold", "SystemOutputStream.italic");
    private @Nullable NIConsole console;
    private final int escSequenceMode;
    private final PreferenceAccess prefAccess;

    private static @Nullable StreamConfigDef getStreamConfigDef(String streamId) {
        return switch (streamId) {
            case "org.eclipse.statet.nico.ui.InfoStream" -> INFO_STREAM_DEF;
            case "org.eclipse.statet.nico.ui.InfoStream-OtherTasks" -> OTHER_TASKS_INFO_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM" -> STD_INPUT_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks" -> OTHER_TASKS_STD_INPUT_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM" -> STD_OUTPUT_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks" -> OTHER_TASKS_STD_OUTPUT_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM" -> STD_ERROR_STREAM_DEF;
            case "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks" -> OTHER_TASKS_STD_ERROR_STREAM_DEF;
            case "org.eclipse.statet.nico.ui.SystemOutputStream" -> SYSTEM_OUTPUT_STREAM_DEF;
            default -> null;
        };
    }

    public NIConsoleStreamAdapter(int escSequenceMode) {
        this.escSequenceMode = escSequenceMode;
        this.prefAccess = EPreferences.getInstancePrefs();
    }

    public NIConsoleStreamAdapter(ILaunchConfiguration launchConfiguration) throws CoreException {
        this(launchConfiguration.getAttribute("org.eclipse.statet.nico/io/ControlSequences.AnsiEsc.process", true) ? 1 : 0);
    }

    public List<String> getStreamIds() {
        return STREAM_IDS;
    }

    void connect(ToolProcess process, NIConsole console) {
        this.console = console;
        ToolController controller = process.getController();
        if (controller != null) {
            ToolStreamProxy proxy = controller.getStreams();
            PreferenceAccess prefs = EPreferences.getInstancePrefs();
            EnumSet includeSet = (EnumSet)prefs.getPreferenceValue(NicoUIPreferences.OUTPUT_FILTER_SUBMITTYPES_INCLUDE_PREF);
            EnumSet<SubmitType> allTypes = EnumSet.allOf(SubmitType.class);
            EnumSet<SubmitType> otherTypes = EnumSet.of(SubmitType.OTHER);
            EnumSet<SubmitType> defaultTypes = EnumSet.complementOf(otherTypes);
            console.connect(proxy.getInfoStreamMonitor(), "org.eclipse.statet.nico.ui.InfoStream", defaultTypes, 0);
            console.connect(proxy.getInfoStreamMonitor(), "org.eclipse.statet.nico.ui.InfoStream-OtherTasks", otherTypes, 0);
            console.connect(proxy.getInputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", defaultTypes, 0);
            console.connect(proxy.getOutputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", defaultTypes, this.escSequenceMode);
            console.connect(proxy.getErrorStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", defaultTypes, this.escSequenceMode);
            if (includeSet.contains(SubmitType.OTHER)) {
                console.connect(proxy.getInputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks", otherTypes, 0);
                console.connect(proxy.getOutputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks", otherTypes, this.escSequenceMode);
                console.connect(proxy.getErrorStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks", otherTypes, this.escSequenceMode);
            }
            console.connect(proxy.getSystemOutputMonitor(), "org.eclipse.statet.nico.ui.SystemOutputStream", includeSet.contains(SubmitType.OTHER) ? allTypes : defaultTypes, this.escSequenceMode);
            this.updateSettings();
        }
    }

    void updateSettings() {
        NIConsole console = this.console;
        if (console == null) {
            return;
        }
        ExtStylingConfiguration newExtStylingConfig = new ExtStylingConfiguration((ImList<? extends ColorDef>)NicoUIPreferences.OUTPUT_COLOR_PALETTE_8_PREFS.map(arg_0 -> ((PreferenceAccess)this.prefAccess).getPreferenceValue(arg_0)).toList());
        UIAccess.getDisplay().syncExec(() -> {
            for (NIConsoleOutputStream stream : console.getStreams()) {
                StreamConfigDef configDef = NIConsoleStreamAdapter.getStreamConfigDef(stream.getId());
                if (configDef == null) continue;
                stream.setColor(this.getColor((Preference<ColorDef>)configDef.foregroundColorPref));
                stream.setBackgroundColor(this.getColor((Preference<ColorDef>)configDef.backgroundColorPref));
                stream.setFontStyle(this.getFontStyle(configDef));
            }
            ExtStylingEngine stylingEngine = console.getPartitioner().getStylingEngine();
            ExtStylingConfiguration oldExtStylingConfig = stylingEngine.getConfig();
            if (!Objects.equals(stylingEngine.getConfig(), newExtStylingConfig)) {
                stylingEngine.setExtStyling(newExtStylingConfig);
                console.firePropertyChange((Object)console, "ExtStyling", oldExtStylingConfig, newExtStylingConfig);
            }
        });
    }

    public void disconnect() {
        this.console = null;
    }

    private @Nullable Color getColor(@Nullable Preference<@Nullable ColorDef> preference) {
        ColorDef color;
        if (preference != null && (color = (ColorDef)this.prefAccess.getPreferenceValue(preference)) != null) {
            return SwtUtils.getColors().get(color);
        }
        return null;
    }

    private int getFontStyle(StreamConfigDef configDef) {
        int style = 0;
        if (((Boolean)this.prefAccess.getPreferenceValue((Preference)configDef.boldPref)).booleanValue()) {
            style |= 1;
        }
        if (((Boolean)this.prefAccess.getPreferenceValue((Preference)configDef.italicPref)).booleanValue()) {
            style |= 2;
        }
        return style;
    }

    public static ColorPref getForegroundColorPref(String streamId) {
        StreamConfigDef configDef = NIConsoleStreamAdapter.getStreamConfigDef(streamId);
        if (configDef == null) {
            throw new IllegalArgumentException("streamId= " + streamId);
        }
        return configDef.foregroundColorPref;
    }

    public static @Nullable ColorPref getBackgroundColorPref(String streamId) {
        StreamConfigDef configDef = NIConsoleStreamAdapter.getStreamConfigDef(streamId);
        if (configDef == null) {
            throw new IllegalArgumentException("streamId= " + streamId);
        }
        return configDef.backgroundColorPref;
    }

    private static class StreamConfigDef {
        final String id;
        final ColorPref foregroundColorPref;
        final Preference.BooleanPref boldPref;
        final Preference.BooleanPref italicPref;
        final @Nullable ColorPref backgroundColorPref;

        public StreamConfigDef(String id, ColorPref foregroundColorPref, Preference.BooleanPref boldPref, Preference.BooleanPref italicPref, @Nullable ColorPref backgroundColorPref) {
            this.id = id;
            this.foregroundColorPref = foregroundColorPref;
            this.boldPref = boldPref;
            this.italicPref = italicPref;
            this.backgroundColorPref = backgroundColorPref;
        }

        public StreamConfigDef(String id, String foregroundColorKey, String boldKey, String italicKey, ColorPref backgroundColorPef) {
            this(id, (ColorPref)new ColorPref.RGBDec("org.eclipse.statet.nico.ui/console/output", foregroundColorKey), new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", boldKey), new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", italicKey), backgroundColorPef);
        }

        public StreamConfigDef(String id, String foregroundColorKey, String boldKey, String italicKey) {
            this(id, (ColorPref)new ColorPref.RGBDec("org.eclipse.statet.nico.ui/console/output", foregroundColorKey), new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", boldKey), new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", italicKey), null);
        }
    }
}

