/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IPageSite;

@NonNullByDefault
public abstract class AbstractToolScopeHandler<TTool extends Tool>
extends AbstractScopeHandler {
    private final ActiveToolListener toolListener = this::onToolChanged;
    private @Nullable ToolProvider toolProvider;
    private @Nullable TTool currentTool;

    protected AbstractToolScopeHandler(IWorkbenchWindow scope, @Nullable String commandId) {
        this.init(scope, null, commandId);
    }

    protected AbstractToolScopeHandler(IPageSite scope, ToolProvider toolProvider, @Nullable String commandId) {
        this.init(scope, toolProvider, commandId);
    }

    protected void init(Object scope, @Nullable ToolProvider toolProvider, @Nullable String commandId) {
        super.init(scope, commandId);
        if (toolProvider == null) {
            IWorkbenchPage workbenchPage;
            if (scope instanceof ToolProvider) {
                toolProvider = (ToolProvider)scope;
            } else if (scope instanceof IWorkbenchWindow && (workbenchPage = ((IWorkbenchWindow)scope).getActivePage()) != null) {
                toolProvider = NicoUI.getToolRegistry().getToolProvider(workbenchPage);
            }
        }
        if (toolProvider != null) {
            this.toolProvider = toolProvider;
            toolProvider.addToolListener(this.toolListener);
        }
    }

    public void dispose() {
        ToolProvider toolProvider = this.toolProvider;
        if (toolProvider != null) {
            this.toolProvider = null;
            toolProvider.removeToolListener(this.toolListener);
        }
        super.dispose();
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return (IWorkbenchWindow)ObjectUtils.nonNullAssert((Object)super.getWorkbenchWindow());
    }

    protected @Nullable Tool getTool(@Nullable IEvaluationContext evalContext) {
        ToolProvider toolProvider = this.toolProvider;
        if (toolProvider != null) {
            return toolProvider.getTool();
        }
        return null;
    }

    private void onToolChanged(ActiveToolListener.ActiveToolEvent event) {
        if (this.toolProvider != null) {
            this.setEnabled(null);
        }
    }

    protected @Nullable TTool getCurrentTool(@Nullable IEvaluationContext evalContext) {
        @Nullable TTool currentTool = this.currentTool;
        Tool tool = this.getTool(evalContext);
        if (tool != currentTool) {
            this.currentTool = currentTool = tool != null && this.isSupported(tool) ? tool : null;
        }
        return currentTool;
    }

    protected boolean isSupported(Tool tool) {
        return true;
    }

    public void setEnabled(@Nullable IEvaluationContext context) {
        TTool currentTool = this.getCurrentTool(context);
        boolean refresh = this.updateState(currentTool);
        if (refresh) {
            this.refreshCommandElements();
        }
    }

    protected boolean updateState(@Nullable TTool tool) {
        this.setBaseEnabled(tool != null && this.evaluateIsEnabled(tool));
        return false;
    }

    protected boolean evaluateIsEnabled(TTool tool) {
        return !tool.isTerminated();
    }

    protected @Nullable Object execute(ExecutionEvent event, IEvaluationContext evalContext) throws ExecutionException {
        TTool currentTool = this.getCurrentTool(evalContext);
        if (currentTool != null && this.evaluateIsEnabled(currentTool)) {
            return this.execute(event, currentTool, evalContext);
        }
        return null;
    }

    protected abstract @Nullable Object execute(ExecutionEvent var1, TTool var2, IEvaluationContext var3) throws ExecutionException;
}

