/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.util.List;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.console.AnsiEscSequence;
import org.eclipse.statet.internal.nico.ui.console.ControlMarker;
import org.eclipse.statet.internal.nico.ui.console.InternArrayList;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartition;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartitioner;
import org.eclipse.statet.internal.nico.ui.console.StyleData;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
final class StreamProcessor {
    private static final char BEL = '\u0007';
    private static final char BS = '\b';
    private static final char LF = '\n';
    private static final char VT = '\u000b';
    private static final char FF = '\f';
    private static final char CR = '\r';
    private static final char ESC = '\u001b';
    private static final int BUFFER_DEFAULT_SIZE = 8192;
    private static final byte S_CREATED = 1;
    private static final byte S_APPLIED = 2;
    private static final byte S_DONE = 4;
    private final NIConsolePartitioner partitioner;
    private byte state;
    private @Nullable String docLF;
    private @Nullable String docVT;
    private boolean finish;
    private int docLength;
    private final StringBuilder text = new StringBuilder(8192);
    private int textOffsetInDoc;
    private int lineStartInText;
    private List<@Nullable NIConsolePartitioner.PendingPartition> partitions;
    private @Nullable InternArrayList<ControlMarker> controlMarkers;
    private int lastPartitionInsertGap;
    private final IntArrayList tmpIntList = new IntArrayList();
    private @Nullable String incompleteEscSequence;

    public StreamProcessor(NIConsolePartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void prepareUpdate(ImList<@Nullable NIConsolePartitioner.PendingPartition> pendingPartitions, int pendingLength) {
        if ((this.state & 2) == 0) {
            this.lastPartitionInsertGap = 0;
        }
        this.clear();
        this.text.setLength(0);
        this.partitions = pendingPartitions;
        AbstractDocument document = this.partitioner.getDocument();
        if (document != null) {
            this.docLength = document.getLength();
            boolean mayCombineLast = true;
            this.textOffsetInDoc = this.docLength;
            this.lineStartInText = 0;
            this.text.ensureCapacity(pendingLength);
            for (NIConsolePartitioner.PendingPartition pp : pendingPartitions) {
                if (pp != null) {
                    this.processPartition(pp, mayCombineLast);
                    mayCombineLast = false;
                    continue;
                }
                this.finish = true;
            }
            this.state = (byte)(this.state | 1);
        } else {
            for (NIConsolePartitioner.PendingPartition pp : pendingPartitions) {
                if (pp != null) continue;
                this.finish = true;
                break;
            }
        }
    }

    public boolean hasUpdate() {
        return this.state == 1;
    }

    public void updateApplied() {
        this.state = (byte)(this.state | 2);
    }

    public void updateDone() {
        this.state = (byte)(this.state | 4);
        if (this.finish ? this.text.capacity() > 32768 : this.text.capacity() > 327680 && this.text.capacity() / 2 > this.text.length()) {
            this.text.setLength(8192);
            this.text.trimToSize();
        }
    }

    public void clear() {
        this.state = 0;
    }

    public String getText() {
        return this.text.toString();
    }

    public int getTextOffsetInDoc() {
        return this.textOffsetInDoc;
    }

    public int getTextReplaceLengthInDoc() {
        return this.docLength - this.textOffsetInDoc;
    }

    public List<@Nullable NIConsolePartitioner.PendingPartition> getPartitions() {
        return this.partitions;
    }

    public boolean wasFinished() {
        return this.finish;
    }

    private void processPartition(NIConsolePartitioner.PendingPartition pp, boolean mayCombineLast) {
        try {
            int pOffset;
            StringBuilder pText = pp.getText();
            StringBuilder text = this.text;
            int insertIdx = pOffset = text.length();
            int readIdx = 0;
            int doneIdx = 0;
            int pLineStart = pOffset;
            StyleData initalStyleData = pp.getStream().lastStyleData;
            if (this.incompleteEscSequence != null) {
                if (mayCombineLast) {
                    pText.insert(readIdx, this.incompleteEscSequence);
                }
                this.incompleteEscSequence = null;
            }
            if (mayCombineLast && pLineStart == 0 && this.lastPartitionInsertGap > 0) {
                mayCombineLast = false;
                this.prependLastDocLine(pp, text);
                insertIdx = Math.max(text.length() - this.lastPartitionInsertGap, pLineStart);
            }
            while (readIdx < pText.length()) {
                char c = pText.charAt(readIdx);
                switch (c) {
                    case '\u0007': {
                        insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        this.bell();
                        doneIdx = ++readIdx;
                        break;
                    }
                    case '\b': {
                        insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        if (mayCombineLast && pLineStart == 0) {
                            mayCombineLast = false;
                            insertIdx += this.prependLastDocLine(pp, text);
                        }
                        if (insertIdx > pLineStart) {
                            --insertIdx;
                        }
                        doneIdx = ++readIdx;
                        break;
                    }
                    case '\n': {
                        if (insertIdx < text.length()) {
                            this.copy(pText, doneIdx, readIdx, text, insertIdx);
                            insertIdx = text.length();
                            doneIdx = readIdx;
                        }
                        pLineStart = insertIdx + ++readIdx - doneIdx;
                        break;
                    }
                    case '\u000b': {
                        this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        if (this.docVT == null) {
                            this.initDocTemplates();
                        }
                        text.append(this.docVT);
                        pLineStart = insertIdx = text.length();
                        doneIdx = ++readIdx;
                        break;
                    }
                    case '\f': {
                        int count;
                        insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        if (this.docLF == null) {
                            this.initDocTemplates();
                        }
                        if (pLineStart == pOffset) {
                            count = insertIdx - this.lineStartInText;
                            if (this.lineStartInText == 0) {
                                count += this.getLastDocLineLength();
                            }
                        } else {
                            count = insertIdx - pLineStart;
                        }
                        text.append(this.docLF);
                        pLineStart = insertIdx = text.length();
                        insertIdx += this.append(' ', count, text);
                        doneIdx = ++readIdx;
                        break;
                    }
                    case '\r': {
                        if (readIdx + 1 < pText.length() && pText.charAt(readIdx + 1) == '\n') {
                            if (insertIdx < text.length()) {
                                this.copy(pText, doneIdx, readIdx, text, insertIdx);
                                insertIdx = text.length();
                                doneIdx = readIdx;
                            }
                            ++readIdx;
                            break;
                        }
                        this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        if (mayCombineLast && pLineStart == 0) {
                            mayCombineLast = false;
                            this.prependLastDocLine(pp, text);
                        }
                        insertIdx = pLineStart;
                        this.deleteMarkersAfter(this.textOffsetInDoc + insertIdx);
                        doneIdx = ++readIdx;
                        break;
                    }
                    case '\u001b': {
                        if (pp.getStream().getEscSequenceMode() != 0 && readIdx + 1 < pText.length() && pText.charAt(readIdx + 1) == '[') {
                            insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                            readIdx += this.parseEscSequence(pText, readIdx, this.textOffsetInDoc + insertIdx, pp.getStream());
                            doneIdx = readIdx;
                            break;
                        }
                        ++readIdx;
                        break;
                    }
                    default: {
                        ++readIdx;
                    }
                }
            }
            this.lineStartInText = pLineStart;
            if (doneIdx == 0 && text.length() == pOffset) {
                text.append((CharSequence)pText);
                this.lastPartitionInsertGap = 0;
            } else {
                insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                this.lastPartitionInsertGap = text.length() - insertIdx;
            }
            pp.setFinalData(this.textOffsetInDoc + pOffset, this.textOffsetInDoc + text.length(), initalStyleData, this.controlMarkers);
        }
        finally {
            this.controlMarkers = null;
        }
    }

    private int parseEscSequence(StringBuilder src, int srcStart, int offset, NIConsoleOutputStream stream) {
        char command;
        this.tmpIntList.clear();
        int index = srcStart + 2;
        do {
            command = '\u0000';
            int argStart = index;
            boolean validSGR = true;
            block7: while (index < src.length()) {
                char c = src.charAt(index++);
                command = c;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    case ';': {
                        if (!validSGR) continue block7;
                        break block7;
                    }
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': {
                        validSGR = false;
                        break;
                    }
                    case '@': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        break block7;
                    }
                    default: {
                        command = '\u0000';
                        break block7;
                    }
                }
            }
            if (!validSGR) continue;
            if (argStart < index - 1) {
                this.tmpIntList.add(Integer.parseInt(src, argStart, index - 1, 10));
                continue;
            }
            this.tmpIntList.add(0);
        } while (command == ';');
        if (command >= '@') {
            AnsiEscSequence escSeq = new AnsiEscSequence(command, ImCollections.toIntList((IntList)this.tmpIntList), offset, stream);
            this.addControlMarker(escSeq);
            stream.lastStyleData = escSeq.evaluateStyle(stream.lastStyleData);
            return index - srcStart;
        }
        if (index == src.length()) {
            this.incompleteEscSequence = src.substring(srcStart, index - 1);
        }
        return index - srcStart - 1;
    }

    private void addControlMarker(ControlMarker marker) {
        InternArrayList<ControlMarker> controlMarkers = this.controlMarkers;
        if (controlMarkers == null) {
            this.controlMarkers = controlMarkers = new InternArrayList();
        }
        controlMarkers.add(marker);
    }

    private void deleteMarkersAfter(int offset) {
        InternArrayList<ControlMarker> controlMarkers = this.controlMarkers;
        if (controlMarkers != null) {
            int idx = controlMarkers.size() - 1;
            while (idx >= 0) {
                ControlMarker marker = (ControlMarker)controlMarkers.get(idx);
                if (marker.getOffset() < offset) break;
                --idx;
            }
            if (++idx < controlMarkers.size()) {
                controlMarkers.removeTail(idx);
            }
        }
    }

    private int copy(StringBuilder src, int srcStart, int srcEnd, StringBuilder dest, int destIdx) {
        int length = srcEnd - srcStart;
        if (length == 0) {
            return 0;
        }
        if (destIdx == dest.length()) {
            if (length == 1) {
                dest.append(src.charAt(srcStart));
            } else {
                dest.append(src, srcStart, srcEnd);
            }
        } else if (length == 1) {
            dest.setCharAt(destIdx, src.charAt(srcStart));
        } else if (destIdx + length < dest.length()) {
            dest.replace(destIdx, destIdx + length, src.substring(srcStart, srcEnd));
        } else {
            dest.setLength(destIdx);
            dest.append(src, srcStart, srcEnd);
        }
        return length;
    }

    private int append(char c, int count, StringBuilder dest) {
        int i = 0;
        while (i < count) {
            dest.append(c);
            ++i;
        }
        return count;
    }

    private void bell() {
        final Display display = UIAccess.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.beep();
            }
        });
    }

    private int prependLastDocLine(NIConsolePartitioner.PendingPartition pp, StringBuilder dest) {
        NIConsolePartition lastPartition = this.partitioner.getLastPartition();
        if (lastPartition != null && lastPartition.getStream() == pp.getStream() && lastPartition.getOffset() + lastPartition.getLength() == this.docLength) {
            try {
                AbstractDocument document = (AbstractDocument)ObjectUtils.nonNullAssert((Object)this.partitioner.getDocument());
                int start = Math.max(lastPartition.getOffset(), document.getLineOffset(document.getNumberOfLines() - 1));
                int length = this.docLength - start;
                if (length > 0) {
                    dest.insert(0, document.get(start, length));
                    this.textOffsetInDoc = start;
                    return length;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int getLastDocLineLength() {
        try {
            AbstractDocument document = (AbstractDocument)ObjectUtils.nonNullAssert((Object)this.partitioner.getDocument());
            int start = document.getLineOffset(document.getNumberOfLines() - 1);
            int length = this.textOffsetInDoc - start;
            if (length > 0) {
                return length;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private void initDocTemplates() {
        this.docLF = this.partitioner.getConsole().getProcess().getWorkspace().getLineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.docLF);
        sb.append(this.docLF);
        sb.append(this.docLF);
        sb.append(this.docLF);
        this.docVT = sb.toString();
    }
}

