/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.statet.internal.nico.ui.console.AnsiColors;
import org.eclipse.statet.internal.nico.ui.console.ControlMarker;
import org.eclipse.statet.internal.nico.ui.console.StyleData;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.IntListIterator;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.graphic.core.RGBColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;

@NonNullByDefault
public class AnsiEscSequence
extends ControlMarker {
    public static final char SGR_COMMAND = 'm';
    public static final int SGR_OP_RESET = 0;
    public static final int SGR_OP_INTENSITY_BRIGHT = 1;
    public static final int SGR_OP_INTENSITY_FAINT = 2;
    public static final int SGR_OP_ITALIC_ON = 3;
    public static final int SGR_OP_UNDERLINE_ON = 4;
    public static final int SGR_OP_BLINK_SLOW = 5;
    public static final int SGR_OP_BLINK_FAST = 6;
    public static final int SGR_OP_NEGATIVE_ON = 7;
    public static final int SGR_OP_CONCEAL_ON = 8;
    public static final int SGR_OP_CROSSOUT_ON = 9;
    public static final int SGR_OP_UNDERLINE_DOUBLE = 21;
    public static final int SGR_OP_INTENSITY_NORMAL = 22;
    public static final int SGR_OP_ITALIC_OFF = 23;
    public static final int SGR_OP_UNDERLINE_OFF = 24;
    public static final int SGR_OP_BLINK_OFF = 25;
    public static final int SGR_OP_NEGATIVE_OFF = 27;
    public static final int SGR_OP_CONCEAL_OFF = 28;
    public static final int SGR_OP_CROSSOUT_OFF = 29;
    public static final int SGR_OP_COLOR_FOREGROUND_8_0 = 30;
    public static final int SGR_OP_COLOR_BACKGROUND_8_0 = 40;
    public static final int SGR_OP_COLOR_FOREGROUND_8_BRIGHT_0 = 90;
    public static final int SGR_OP_COLOR_BACKGROUND_8_BRIGHT_0 = 100;
    public static final int SGR_OP_COLOR_FOREGROUND_EXT = 38;
    public static final int SGR_OP_COLOR_BACKGROUND_EXT = 48;
    public static final int SGR_OP_COLOR_FOREGROUND_RESET = 39;
    public static final int SGR_OP_COLOR_BACKGROUND_RESET = 49;
    public static final int SGR_OP_FRAMED_ON = 51;
    public static final int SGR_OP_FRAMED_OFF = 54;
    private final char command;
    private final ImIntList arguments;
    private @Nullable StyleData style;

    public AnsiEscSequence(char command, ImIntList arguments, int offset, NIConsoleOutputStream stream) {
        super(offset, stream);
        this.command = command;
        this.arguments = arguments;
    }

    public char getCommand() {
        return this.command;
    }

    public ImIntList getArguments() {
        return this.arguments;
    }

    public String getSequence() {
        StringBuilder sb = new StringBuilder("\u001b[");
        if (!this.arguments.isEmpty()) {
            IntListIterator iter = this.arguments.iterator();
            sb.append(iter.nextInt());
            while (iter.hasNext()) {
                sb.append(';');
                sb.append(iter.nextInt());
            }
        }
        if (this.command != '\u0000') {
            sb.append(this.command);
        }
        return sb.toString();
    }

    @Override
    public boolean isStyleMarker() {
        return this.command == 'm';
    }

    @Override
    public @Nullable StyleData getStyle() {
        return this.style;
    }

    /*
     * Enabled aggressive block sorting
     */
    public @Nullable StyleData evaluateStyle(@Nullable StyleData previous) {
        if (this.command != 'm') {
            return previous;
        }
        StyleData.Builder styleBuilder = new StyleData.Builder(previous);
        IntListIterator argIter = this.arguments.iterator();
        block54: while (argIter.hasNext()) {
            int op = argIter.nextInt();
            switch (op) {
                case 0: {
                    styleBuilder.reset();
                    break;
                }
                case 39: {
                    styleBuilder.setForegroundColor(null);
                    break;
                }
                case 49: {
                    styleBuilder.setBackgroundColor(null);
                    break;
                }
                case 30: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BLACK);
                    break;
                }
                case 31: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_RED);
                    break;
                }
                case 32: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_GREEN);
                    break;
                }
                case 33: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_YELLOW);
                    break;
                }
                case 34: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BLUE);
                    break;
                }
                case 35: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_MAGENTA);
                    break;
                }
                case 36: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_CYAN);
                    break;
                }
                case 37: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_WHITE);
                    break;
                }
                case 90: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_BLACK);
                    break;
                }
                case 91: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_RED);
                    break;
                }
                case 92: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_GREEN);
                    break;
                }
                case 93: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_YELLOW);
                    break;
                }
                case 94: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_BLUE);
                    break;
                }
                case 95: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_MAGENTA);
                    break;
                }
                case 96: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_CYAN);
                    break;
                }
                case 97: {
                    styleBuilder.setForegroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_WHITE);
                    break;
                }
                case 40: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BLACK);
                    break;
                }
                case 41: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_RED);
                    break;
                }
                case 42: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_GREEN);
                    break;
                }
                case 43: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_YELLOW);
                    break;
                }
                case 44: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BLUE);
                    break;
                }
                case 45: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_MAGENTA);
                    break;
                }
                case 46: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_CYAN);
                    break;
                }
                case 47: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_WHITE);
                    break;
                }
                case 100: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_BLACK);
                    break;
                }
                case 101: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_RED);
                    break;
                }
                case 102: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_GREEN);
                    break;
                }
                case 103: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_YELLOW);
                    break;
                }
                case 104: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_BLUE);
                    break;
                }
                case 105: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_MAGENTA);
                    break;
                }
                case 106: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_CYAN);
                    break;
                }
                case 107: {
                    styleBuilder.setBackgroundColor((ColorDef)AnsiColors.PALETTE_8_BRIGHT_WHITE);
                    break;
                }
                case 38: {
                    ColorDef color = this.readColorExt(argIter);
                    styleBuilder.setForegroundColor(color);
                    if (color != null) break;
                    break block54;
                }
                case 48: {
                    ColorDef color = this.readColorExt(argIter);
                    styleBuilder.setBackgroundColor(color);
                    if (color != null) break;
                    break block54;
                }
                case 7: {
                    styleBuilder.setInvert(true);
                    break;
                }
                case 27: {
                    styleBuilder.setInvert(false);
                    break;
                }
                case 8: {
                    styleBuilder.setHide(true);
                    break;
                }
                case 28: {
                    styleBuilder.setHide(false);
                    break;
                }
                case 1: {
                    styleBuilder.setBold(true);
                    break;
                }
                case 2: 
                case 22: {
                    styleBuilder.setBold(false);
                    break;
                }
                case 3: {
                    styleBuilder.setItalic(true);
                    break;
                }
                case 23: {
                    styleBuilder.setItalic(false);
                    break;
                }
                case 4: {
                    styleBuilder.setUnderline((byte)1);
                    break;
                }
                case 21: {
                    styleBuilder.setUnderline((byte)2);
                    break;
                }
                case 24: {
                    styleBuilder.setUnderline((byte)0);
                    break;
                }
                case 9: {
                    styleBuilder.setStrikethrough(true);
                    break;
                }
                case 29: {
                    styleBuilder.setStrikethrough(false);
                    break;
                }
                case 51: {
                    styleBuilder.setFramed(true);
                    break;
                }
                case 54: {
                    styleBuilder.setFramed(false);
                }
            }
        }
        this.style = !styleBuilder.isEmpty() ? styleBuilder.build() : null;
        return this.style;
    }

    private @Nullable ColorDef readColorExt(IntListIterator argIter) {
        return switch (argIter.nextIntElse(-1)) {
            case 5 -> {
                int index = argIter.nextIntElse(-1);
                if ((index & 0xFFFFFF00) != 0) {
                    yield null;
                }
                yield AnsiColors.getPalette256Color(index);
            }
            case 2 -> {
                int r = argIter.nextIntElse(-1);
                int g = argIter.nextIntElse(-1);
                int b = argIter.nextIntElse(-1);
                if ((r & 0xFFFFFF00) != 0 || (g & 0xFFFFFF00) != 0 || (b & 0xFFFFFF00) != 0) {
                    yield null;
                }
                yield new RGBColorDef(r, g, b);
            }
            default -> null;
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ESC[");
        if (!this.arguments.isEmpty()) {
            IntListIterator iter = this.arguments.iterator();
            sb.append(iter.nextInt());
            while (iter.hasNext()) {
                sb.append(';');
                sb.append(iter.nextInt());
            }
        }
        if (this.command != '\u0000') {
            sb.append(this.command);
        }
        return sb.toString();
    }
}

