/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistCompletionInformationProposalWrapper;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistCategory;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class ContentAssistProcessor
extends ContentAssist.Processor
implements IContentAssistProcessor {
    private static final boolean DEBUG_LOG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.ltk/debug/ContentAssist/log"));
    private static final Collator NAME_COLLATOR = Collator.getInstance();
    static final Comparator<AssistProposal> PROPOSAL_COMPARATOR = new Comparator<AssistProposal>(){

        @Override
        public int compare(AssistProposal proposal1, AssistProposal proposal2) {
            int diff = proposal2.getRelevance() - proposal1.getRelevance();
            if (diff != 0) {
                return diff;
            }
            return NAME_COLLATOR.compare(proposal1.getSortingString(), proposal2.getSortingString());
        }
    };
    private static final long INFO_ITER_SPAN = 3000000000L;
    private final ContentAssistComputerRegistry computerRegistry;
    private final SourceEditor editor;
    private char[] completionProposalsAutoActivationCharacters;
    private char[] contextInformationAutoActivationCharacters;
    private boolean isCompletionProposalSession;
    private int sessionCounter;
    private int iterationPos = -1;
    private boolean noIteration;
    private final CopyOnWriteIdentityListSet<ContentAssistCategory> expliciteCategories = new CopyOnWriteIdentityListSet();
    private List<ContentAssistCategory> availableCategories;
    private List<List<ContentAssistCategory>> categoryIteration;
    private @Nullable AssistInvocationContext completionProposalContext;
    private @Nullable IContextInformationValidator contextInformationValidator;
    private long informationModeTimestamp;
    private long informationModeModificationStamp;
    private int informationModeOffset;
    private @NonNull ICompletionProposal @Nullable [] reloadCompletionProposals;

    public ContentAssistProcessor(ContentAssist assistant, String contentType, ContentAssistComputerRegistry registry, SourceEditor editor) {
        super(assistant, contentType);
        assert (registry != null);
        assert (editor != null);
        this.computerRegistry = registry;
        this.editor = editor;
        this.getAssistant().enableColoredLabels(true);
        this.getAssistant().addCompletionListener(new CompletionListener());
    }

    protected SourceEditor getEditor() {
        return this.editor;
    }

    protected final boolean isInCompletionProposalSession() {
        return this.isCompletionProposalSession;
    }

    protected final int getSessionCounter() {
        return this.sessionCounter;
    }

    public void addCategory(ContentAssistCategory category) {
        this.expliciteCategories.add((Object)((ContentAssistCategory)ObjectUtils.nonNullAssert((Object)category)));
    }

    @Override
    protected @NonNull ICompletionProposal @Nullable [] doComputeCompletionProposals(ITextViewer viewer, int offset) {
        if (!this.isInCompletionProposalSession()) {
            this.startCompletionSession();
        }
        this.clearState();
        if (this.reloadCompletionProposals != null) {
            return this.reloadCompletionProposals;
        }
        return this.computeCompletionProposals(offset);
    }

    private final @NonNull ICompletionProposal @Nullable [] computeCompletionProposals(int offset) {
        ContentAssist assistant = this.getAssistant();
        long startTime = System.nanoTime();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)this.createProgressMonitor());
        m.beginTask(EditingMessages.ContentAssistProcessor_ComputingProposals_task, 14);
        try {
            long filter;
            int mode;
            AssistInvocationContext context = this.getCompletionProposalContext(offset, (IProgressMonitor)m.newChild(3));
            long setup = DEBUG_LOG ? System.nanoTime() : 0L;
            long modificationStamp = ((AbstractDocument)context.getSourceViewer().getDocument()).getModificationStamp();
            if (assistant.isCompletionProposalSpecificSession()) {
                mode = 2;
            } else {
                if (!(assistant.isProposalPopupActive1() || startTime - this.informationModeTimestamp <= 3000000000L && offset == this.informationModeOffset && assistant.isContextInfoPopupActive1() && modificationStamp == this.informationModeModificationStamp || !this.forceContextInformation(context))) {
                    assistant.setRepeatedInvocationMode(true);
                    assistant.setShowEmptyList(true);
                    assistant.enableAutoInsertTemporarily();
                    assistant.setStatusLineVisible(true);
                    assistant.setStatusMessage(EditingMessages.ContentAssistProcessor_ContextSelection_label);
                    ICompletionProposal[] iCompletionProposalArray = this.computeContextInformationProposals(context, modificationStamp, m.newChild(10));
                    return iCompletionProposalArray;
                }
                this.iterate();
                mode = this.iterationPos == 0 ? 1 : 2;
                assistant.enableAutoInsertSetting();
            }
            List<ContentAssistCategory> categories = this.getCurrentCategories();
            m.subTask(EditingMessages.ContentAssistProcessor_ComputingProposals_Collecting_task);
            AssistProposalCollector proposals = this.createProposalCollector();
            this.collectCompletionProposals(context, mode, categories, proposals, m.newChild(10));
            long collect = DEBUG_LOG ? System.nanoTime() : 0L;
            m.subTask(EditingMessages.ContentAssistProcessor_ComputingProposals_Sorting_task);
            @NonNull ICompletionProposal[] result = this.filterAndSortCompletionProposals(proposals, context, m.newChild(1));
            long l = filter = DEBUG_LOG ? System.nanoTime() : 0L;
            if (DEBUG_LOG) {
                StringBuilder sb = new StringBuilder("Code Assist Stats");
                sb.append(" (").append(result.length).append(" proposals)");
                sb.append("\n\tsetup=   ").append(setup - startTime);
                sb.append("\n\tcollect= ").append(collect - setup);
                sb.append("\n\tsort=    ").append(filter - collect);
                System.out.println(sb);
            }
            ICompletionProposal[] iCompletionProposalArray = result;
            return iCompletionProposalArray;
        }
        finally {
            m.done();
        }
    }

    private void startCompletionSession() {
        this.isCompletionProposalSession = true;
        ++this.sessionCounter;
        ContentAssist assistant = this.getAssistant();
        this.availableCategories = assistant.isCompletionProposalSpecificSession() ? this.computerRegistry.getCategory(assistant.getSpecificMode()) : this.computerRegistry.getCategories();
        this.categoryIteration = this.createCategoryIteration();
        this.notifySessionStarted();
        this.iterationPos = -1;
        if (this.categoryIteration.size() == 1) {
            assistant.setRepeatedInvocationMode(false);
            assistant.setShowEmptyList(false);
        } else {
            assistant.setRepeatedInvocationMode(true);
            assistant.setShowEmptyList(true);
            assistant.setStatusLineVisible(true);
            assistant.setStatusMessage(this.createIterationMessage(0));
        }
    }

    private void restartCompletionSession() {
        assert (this.isCompletionProposalSession);
        if (this.iterationPos >= 0) {
            --this.iterationPos;
        }
        this.completionProposalContext = null;
    }

    private void endCompletionSession() {
        assert (this.isCompletionProposalSession);
        this.isCompletionProposalSession = false;
        ContentAssist assistant = this.getAssistant();
        this.notifySessionEnded();
        this.availableCategories = null;
        this.categoryIteration = null;
        this.iterationPos = -1;
        assistant.setRepeatedInvocationTrigger(null);
        assistant.setRepeatedInvocationMode(false);
        assistant.setShowEmptyList(false);
        assistant.enableAutoInsertSetting();
        assistant.setStatusLineVisible(false);
        this.completionProposalContext = null;
    }

    private void clearState() {
    }

    private boolean collectCompletionProposals(AssistInvocationContext context, int mode, List<ContentAssistCategory> categories, AssistProposalCollector proposals, SubMonitor m) {
        m.setWorkRemaining(categories.size());
        for (ContentAssistCategory category : categories) {
            List<ContentAssistComputer> computers = category.getComputers(this.getContentType());
            SubMonitor m1 = m.newChild(1);
            for (ContentAssistComputer computer : computers) {
                try {
                    computer.computeCompletionProposals(context, mode, proposals, (IProgressMonitor)m1);
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.core", "An error occurred when computing content assistant completion proposals.", (Throwable)e));
                }
            }
        }
        return true;
    }

    @Override
    protected @NonNull IContextInformation @Nullable [] doComputeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)this.createProgressMonitor(), (String)EditingMessages.ContentAssistProcessor_ComputingContexts_task, (int)14);
        try {
            if (!this.isCompletionProposalSession) {
                ++this.sessionCounter;
                this.availableCategories = this.computerRegistry.getCategories();
                this.notifySessionStarted();
            }
            AssistInvocationContext context = this.getContextInformationContext(offset, m.newChild(3));
            long modificationStamp = !this.getAssistant().isContextInformationAutoRequest() ? ((AbstractDocument)context.getSourceViewer().getDocument()).getModificationStamp() : 0L;
            AssistProposal[] proposals = this.computeContextInformationProposals(context, modificationStamp, m.newChild(10));
            IContextInformation[] iContextInformationArray = proposals != null ? this.toInformationProposals(proposals, context) : null;
            return iContextInformationArray;
        }
        finally {
            if (!this.isCompletionProposalSession) {
                this.notifySessionEnded();
                this.availableCategories = null;
            }
            m.done();
        }
    }

    private @NonNull AssistProposal @Nullable [] computeContextInformationProposals(AssistInvocationContext context, long modificationStamp, SubMonitor m) {
        boolean ok;
        m.setWorkRemaining(11);
        m.subTask(EditingMessages.ContentAssistProcessor_ComputingContexts_Collecting_task);
        ContentAssist assistant = this.getAssistant();
        ArrayList<ContentAssistCategory> defaultGroup = new ArrayList<ContentAssistCategory>();
        ArrayList<ContentAssistCategory> otherGroup = new ArrayList<ContentAssistCategory>();
        for (ContentAssistCategory category : this.availableCategories) {
            if (category.isEnabledInDefault()) {
                defaultGroup.add(category);
                continue;
            }
            if (!category.isEnabledInCircling()) continue;
            otherGroup.add(category);
        }
        AssistProposalCollector proposals = this.createProposalCollector();
        if (modificationStamp == 0L) {
            ok = false;
            if (this.collectInformationProposals(context, defaultGroup, true, proposals, m.newChild(5)) && (proposals.getCount() == 1 || this.collectInformationProposals(context, otherGroup, true, proposals, m.newChild(5)) && proposals.getCount() == 1)) {
                ok = true;
            }
        } else {
            ok = true;
            this.collectInformationProposals(context, defaultGroup, false, proposals, m.newChild(5));
            if (proposals.getCount() == 0) {
                this.collectInformationProposals(context, otherGroup, false, proposals, m.newChild(5));
            }
        }
        if (!ok) {
            return null;
        }
        m.setWorkRemaining(1);
        m.subTask(EditingMessages.ContentAssistProcessor_ComputingContexts_Sorting_task);
        @NonNull AssistProposal[] result = this.filterAndSortCompletionProposals(proposals, context, m.newChild(1));
        if (modificationStamp != 0L) {
            this.informationModeOffset = context.getInvocationOffset();
            this.informationModeTimestamp = System.nanoTime();
            this.informationModeModificationStamp = modificationStamp;
        }
        return result;
    }

    private boolean collectInformationProposals(AssistInvocationContext context, List<ContentAssistCategory> categories, boolean single, AssistProposalCollector proposals, SubMonitor m) {
        m.setWorkRemaining(categories.size());
        for (ContentAssistCategory category : categories) {
            List<ContentAssistComputer> computers = category.getComputers(this.getContentType());
            SubMonitor m1 = m.newChild(1);
            for (ContentAssistComputer computer : computers) {
                block7: {
                    computer.onSessionStarted(context.getEditor(), this.getAssistant());
                    try {
                        try {
                            computer.computeInformationProposals(context, proposals, (IProgressMonitor)m1);
                        }
                        catch (Exception e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.core", "An error occurred when computing content assistant context information.", (Throwable)e));
                            computer.onSessionEnded();
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        computer.onSessionEnded();
                        throw throwable;
                    }
                    computer.onSessionEnded();
                }
                if (!single || proposals.getCount() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    protected AssistProposalCollector createProposalCollector() {
        return new AssistProposalCollector();
    }

    protected @NonNull AssistProposal[] filterAndSortCompletionProposals(AssistProposalCollector proposals, AssistInvocationContext context, SubMonitor m) {
        @NonNull AssistProposal[] array = proposals.toArray();
        if (array.length > 1) {
            Arrays.sort(array, PROPOSAL_COMPARATOR);
        }
        return array;
    }

    protected @NonNull AssistInformationProposal @Nullable [] toInformationProposals(@NonNull AssistProposal[] proposals, AssistInvocationContext context) {
        AssistInformationProposal[] infoProposals = new AssistInformationProposal[proposals.length];
        int i = 0;
        while (i < proposals.length) {
            AssistProposal proposal = proposals[i];
            infoProposals[i] = proposal instanceof AssistInformationProposal ? (AssistInformationProposal)((Object)proposal) : new AssistCompletionInformationProposalWrapper(proposal, context);
            ++i;
        }
        return infoProposals;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.completionProposalsAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalsAutoActivationCharacters;
    }

    public final void setContextInformationAutoActivationCharacters(char[] activationSet) {
        this.contextInformationAutoActivationCharacters = activationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationAutoActivationCharacters;
    }

    public @Nullable String getErrorMessage() {
        return null;
    }

    public final @Nullable IContextInformationValidator getContextInformationValidator() {
        IContextInformationValidator contextInformationValidator = this.contextInformationValidator;
        if (contextInformationValidator == null) {
            this.contextInformationValidator = contextInformationValidator = this.createContextInformationValidator();
        }
        return contextInformationValidator;
    }

    protected @Nullable IContextInformationValidator createContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    private AssistInvocationContext getCompletionProposalContext(int offset, IProgressMonitor monitor) {
        AssistInvocationContext context = this.completionProposalContext;
        DocContentSections documentContentInfo = this.editor.getDocumentContentInfo();
        if (context == null || !context.reuse(this.editor, offset, documentContentInfo)) {
            this.completionProposalContext = context = this.createCompletionProposalContext(offset, documentContentInfo, monitor);
        }
        context.session = this.sessionCounter;
        return context;
    }

    protected AssistInvocationContext createCompletionProposalContext(int offset, DocContentSections documentContentInfo, IProgressMonitor monitor) {
        return new AssistInvocationContext(this.getEditor(), offset, this.getEditor().getDocumentContentInfo(), this.getContentType(), 0, monitor);
    }

    private AssistInvocationContext getContextInformationContext(int offset, SubMonitor m) {
        AssistInvocationContext context = this.completionProposalContext;
        DocContentSections documentContentInfo = this.editor.getDocumentContentInfo();
        if (context == null || !context.reuse(this.editor, offset, documentContentInfo)) {
            context = this.createContextInformationContext(offset, documentContentInfo, (IProgressMonitor)m);
        }
        return context;
    }

    protected AssistInvocationContext createContextInformationContext(int offset, DocContentSections documentContentInfo, IProgressMonitor monitor) {
        return new AssistInvocationContext(this.getEditor(), offset, documentContentInfo, this.getContentType(), 0, monitor);
    }

    protected boolean forceContextInformation(AssistInvocationContext context) {
        return false;
    }

    private void iterate() {
        if (this.categoryIteration == null) {
            this.noIteration = false;
            return;
        }
        if (this.noIteration) {
            if (this.iterationPos < 0) {
                this.iterationPos = 0;
            }
            this.noIteration = false;
            return;
        }
        ++this.iterationPos;
        if (this.iterationPos >= this.categoryIteration.size()) {
            this.iterationPos = 0;
        }
    }

    private List<ContentAssistCategory> getCurrentCategories() {
        if (this.categoryIteration == null) {
            return this.availableCategories;
        }
        int iterationPos = this.iterationPos % this.categoryIteration.size();
        ContentAssist assistant = this.getAssistant();
        assistant.setStatusMessage(this.createIterationMessage(iterationPos));
        assistant.setEmptyMessage(this.createEmptyMessage(iterationPos));
        return this.categoryIteration.get(iterationPos);
    }

    private List<List<ContentAssistCategory>> createCategoryIteration() {
        ArrayList<List<ContentAssistCategory>> sequence = new ArrayList<List<ContentAssistCategory>>(this.availableCategories.size());
        sequence.add(this.createDefaultCategories());
        for (ContentAssistCategory category : this.createSeparateCategories()) {
            sequence.add((List<ContentAssistCategory>)ImCollections.newList((Object)category));
        }
        return sequence;
    }

    private List<ContentAssistCategory> createDefaultCategories() {
        ArrayList<ContentAssistCategory> included = new ArrayList<ContentAssistCategory>(this.availableCategories.size());
        for (ContentAssistCategory category : this.availableCategories) {
            if (!category.isEnabledInDefault() || !category.hasComputers(this.getContentType())) continue;
            included.add(category);
        }
        for (ContentAssistCategory category : this.expliciteCategories) {
            if (!category.isEnabledInDefault() || !category.hasComputers(this.getContentType())) continue;
            included.add(category);
        }
        return included;
    }

    private List<ContentAssistCategory> createSeparateCategories() {
        ArrayList<ContentAssistCategory> sorted = new ArrayList<ContentAssistCategory>(this.availableCategories.size());
        for (ContentAssistCategory category : this.availableCategories) {
            if (!category.isEnabledInCircling() || !category.hasComputers(this.getContentType())) continue;
            sorted.add(category);
        }
        return sorted;
    }

    private void notifySessionStarted() {
        for (ContentAssistCategory category : this.availableCategories) {
            List<ContentAssistComputer> computers = category.getComputers(this.getContentType());
            for (ContentAssistComputer computer : computers) {
                computer.onSessionStarted(this.editor, this.getAssistant());
            }
        }
    }

    private void notifySessionEnded() {
        if (this.availableCategories == null) {
            return;
        }
        for (ContentAssistCategory category : this.availableCategories) {
            List<ContentAssistComputer> computers = category.getComputers(this.getContentType());
            for (ContentAssistComputer computer : computers) {
                try {
                    computer.onSessionEnded();
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, "Error by contributed content assist computer.", (Throwable)e));
                }
            }
        }
    }

    protected String createEmptyMessage(int iterationPosition) {
        return NLS.bind((String)EditingMessages.ContentAssistProcessor_Empty_message, (Object[])new String[]{this.getCategoryName(iterationPosition)});
    }

    protected String createIterationMessage(int iterationPosition) {
        StringBuilder sb = new StringBuilder(this.getCategoryName(iterationPosition));
        if (this.categoryIteration.size() > 0) {
            sb.append("\u2004\u2004");
            sb.append(NLS.bind((String)SharedMessages.DoToShow_message, (Object)this.getAssistant().getCompletionProposalIterationGesture(), (Object)this.getCategoryName(iterationPosition + 1)));
        }
        return sb.toString();
    }

    protected String getCategoryName(int repetition) {
        if (repetition < 0) {
            return EditingMessages.ContentAssistProcessor_ContextSelection_label;
        }
        int iterationPosition = repetition % this.categoryIteration.size();
        if (iterationPosition == 0) {
            return EditingMessages.ContentAssistProcessor_DefaultProposalCategory;
        }
        return this.categoryIteration.get(iterationPosition).get(0).getDisplayName();
    }

    protected void reloadPossibleCompletions(final AssistInvocationContext context) {
        if (this.isInCompletionProposalSession() && context.session == this.getSessionCounter()) {
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SourceViewer viewer = context.getSourceViewer();
                    if (ContentAssistProcessor.this.isInCompletionProposalSession() && context.session == ContentAssistProcessor.this.getSessionCounter() && UIAccess.isOkToUse((Viewer)viewer) && viewer.getTextWidget().isFocusControl() && context.isInitialState() && ContentAssistProcessor.this.getAssistant().getCompletionProposalSelectionCounter() <= 1) {
                        ContentAssistProcessor.this.noIteration = true;
                        try {
                            ContentAssistProcessor.this.reloadCompletionProposals = ContentAssistProcessor.this.computeCompletionProposals(context.getInvocationOffset());
                            if (ContentAssistProcessor.this.reloadCompletionProposals != null && ContentAssistProcessor.this.reloadCompletionProposals.length > 0) {
                                ContentAssistProcessor.this.getAssistant().reloadPossibleCompletions();
                            }
                        }
                        finally {
                            ContentAssistProcessor.this.noIteration = false;
                            ContentAssistProcessor.this.reloadCompletionProposals = null;
                        }
                    }
                }
            });
        }
    }

    private final class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor == ContentAssistProcessor.this) {
                ContentAssistProcessor.this.startCompletionSession();
            }
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            if (ContentAssistProcessor.this.isInCompletionProposalSession()) {
                if (event.processor == ContentAssistProcessor.this) {
                    ContentAssistProcessor.this.restartCompletionSession();
                } else {
                    ContentAssistProcessor.this.endCompletionSession();
                }
            }
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (ContentAssistProcessor.this.isInCompletionProposalSession()) {
                ContentAssistProcessor.this.endCompletionSession();
            }
        }

        public void selectionChanged(@Nullable ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

