/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.assist;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.ecommons.text.core.DocumentEnhancement;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.ExclusivePositionUpdater;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class LinkedModeBracketLevel
implements LinkedModeUI.IExitPolicy,
ILinkedModeListener {
    public static final int CONSOLE_MODE = 1;
    public static final int AUTODELETE = 0x1000000;
    private static final String POSITION_CATEGORY = "org.eclipse.statet.ecommons.text.ui.BracketLevel";
    private static final IPositionUpdater POSITION_UPDATER = new ExclusivePositionUpdater("org.eclipse.statet.ecommons.text.ui.BracketLevel");
    private final IDocument document;
    private final DocContentSections documentContentInfo;
    private final List<? extends LinkedPosition> positions;
    private final int mode;
    private boolean hasOwnPositions;
    private @Nullable DocumentData documentData;

    public LinkedModeBracketLevel(LinkedModeModel model, IDocument document, DocContentSections documentContentInfo, List<? extends LinkedPosition> positions, int mode) {
        this.document = document;
        this.documentContentInfo = documentContentInfo;
        this.positions = positions;
        this.mode = mode;
        this.init(model);
    }

    protected void init(LinkedModeModel model) {
        DocumentData documentData;
        if ((this.mode & 0x1000000) != 0 && this.document instanceof IDocumentExtension && (documentData = this.fetchDocumentData()) != null) {
            this.documentData = documentData;
            try {
                model.addLinkingListener((ILinkedModeListener)this);
                this.setupPositionCategory(documentData);
                for (LinkedPosition linkedPosition : this.positions) {
                    if (!(linkedPosition instanceof InBracketPosition)) continue;
                    InBracketPosition inPos = (InBracketPosition)linkedPosition;
                    inPos.createOpenClosePositions(this.document);
                }
            }
            catch (Exception exception) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An error occurred when preparing auto-undo of autoedit insertions.", (Throwable)exception));
            }
        }
    }

    private void setupPositionCategory(DocumentData documentData) {
        this.hasOwnPositions = true;
        ++documentData.counter;
        if (!this.document.containsPositionCategory(POSITION_CATEGORY)) {
            this.document.addPositionCategory(POSITION_CATEGORY);
            this.document.addPositionUpdater(POSITION_UPDATER);
        }
    }

    private void disposePositionCategory() {
        if (this.document.containsPositionCategory(POSITION_CATEGORY)) {
            try {
                this.document.removePositionCategory(POSITION_CATEGORY);
                this.document.removePositionUpdater(POSITION_UPDATER);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
    }

    protected final DocumentData fetchDocumentData() {
        DocumentEnhancement documentEnhancement = DocumentEnhancement.get((IDocument)this.document);
        DocumentData data = (DocumentData)documentEnhancement.getData(POSITION_CATEGORY);
        if (data == null) {
            data = new DocumentData();
            documentEnhancement.setData(POSITION_CATEGORY, (Object)data);
        }
        return data;
    }

    protected final int getPositionIdx(int offset) {
        int i = 0;
        while (i < this.positions.size()) {
            if (this.positions.get(i).includes(offset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
        try {
            int nextIdx;
            int posIdx = this.getPositionIdx(offset);
            InBracketPosition inPos = posIdx >= 0 && this.positions.get(posIdx) instanceof InBracketPosition ? (InBracketPosition)this.positions.get(posIdx) : null;
            switch (event.character) {
                case '\n': 
                case '\r': {
                    if ((this.mode & 1) != 0) {
                        return new LinkedModeUI.ExitFlags(1, true);
                    }
                    if (length > 0 || inPos != null && inPos.insertCR(offset)) {
                        return new LinkedModeUI.ExitFlags(0, true);
                    }
                    return null;
                }
                case '\b': {
                    if ((this.mode & 0x1000000) != 0 && !this.hasOwnPositions && length == 0 && inPos != null && inPos.getOffset() == offset && inPos.getLength() == 0) {
                        int count = 2;
                        int i = posIdx + 1;
                        while (i < this.positions.size()) {
                            LinkedPosition position = this.positions.get(i);
                            if (position instanceof InBracketPosition) {
                                if (position.getOffset() != offset + count || position.getLength() != 0) break;
                                count += 2;
                            }
                            ++i;
                        }
                        this.document.replace(offset - 1, count, "");
                        return new LinkedModeUI.ExitFlags(0, false);
                    }
                    return null;
                }
            }
            if (length == 0 && inPos != null && inPos.matchesClose(this, offset, event.character)) {
                this.skipChars(event, 1);
                if (posIdx == this.positions.size() - 1) {
                    return new LinkedModeUI.ExitFlags(0, false);
                }
                return null;
            }
            if (length == 0 && (posIdx < 0 || !this.positions.get(posIdx).includes(offset + 1)) && (nextIdx = this.getPositionIdx(offset + 1)) > 0 && this.positions.get(nextIdx) instanceof InBracketPosition && ((InBracketPosition)this.positions.get(nextIdx)).matchesOpen(this, offset, event.character)) {
                this.skipChars(event, 1);
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public void resume(LinkedModeModel model, int flags) {
    }

    public void suspend(LinkedModeModel model) {
    }

    public void left(LinkedModeModel model, int flags) {
        if ((this.mode & 0x1000000) != 0 && this.hasOwnPositions && flags == 8) {
            ((IDocumentExtension)this.document).registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument document, @Nullable IDocumentListener owner) {
                    LinkedModeBracketLevel.this.checkOwnPositionCleanup();
                    try {
                        int startOffset = -1;
                        int endOffset = -1;
                        for (LinkedPosition linkedPosition : LinkedModeBracketLevel.this.positions) {
                            if (!(linkedPosition instanceof InBracketPosition)) continue;
                            InBracketPosition inPos = (InBracketPosition)linkedPosition;
                            if (!inPos.hasOpenClosePositions()) break;
                            if (startOffset < 0) {
                                if (!inPos.getOpenPosition().isDeleted() && inPos.getOpenPosition().getLength() != 0 || !inPos.isDeleted() && inPos.getLength() != 0 || inPos.getClosePosition().isDeleted()) continue;
                                startOffset = inPos.getClosePosition().getOffset();
                                endOffset = inPos.getClosePosition().getOffset() + inPos.getCloseLength();
                                continue;
                            }
                            if (inPos.getOpenPosition().getOffset() != endOffset || inPos.getOpenPosition().isDeleted() || !inPos.isDeleted() && inPos.getLength() != 0 || inPos.getClosePosition().isDeleted()) break;
                            endOffset = inPos.getClosePosition().getOffset() + inPos.getCloseLength();
                        }
                        if (startOffset >= 0 && endOffset > startOffset) {
                            document.replace(startOffset, endOffset - startOffset, "");
                        }
                    }
                    catch (Exception e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An error occurred when performing auto-undo of autoedit insertions.", (Throwable)e));
                    }
                }
            });
            return;
        }
        this.checkOwnPositionCleanup();
    }

    private void checkOwnPositionCleanup() {
        DocumentData documentData = this.documentData;
        if (documentData == null) {
            return;
        }
        if (this.hasOwnPositions) {
            --documentData.counter;
            if (documentData.counter == 0) {
                this.disposePositionCategory();
            }
        }
    }

    private void skipChars(VerifyEvent event, int n) {
        event.doit = false;
        StyledText styledText = (StyledText)event.widget;
        SwtUtils.setSelection((StyledText)styledText, (int)(styledText.getCaretOffset() + n), (int)event.time);
    }

    public String getPartitionType(int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)this.document, (String)this.documentContentInfo.getPartitioning(), (int)offset, (boolean)true).getType();
    }

    private static class DocumentData {
        private int counter;

        private DocumentData() {
        }
    }

    public static abstract class InBracketPosition
    extends LinkedPosition {
        private Position openPos;
        private Position closePos;

        public InBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public abstract char getOpenChar();

        public abstract char getCloseChar();

        protected int getCloseLength() {
            return 1;
        }

        void createOpenClosePositions(IDocument document) throws BadPositionCategoryException, BadLocationException {
            Position pos = new Position(this.getOffset() - 1, 1);
            assert (document.getChar(pos.getOffset()) == this.getOpenChar());
            document.addPosition(LinkedModeBracketLevel.POSITION_CATEGORY, pos);
            this.openPos = pos;
            pos = new Position(this.getOffset() + this.getLength(), 1);
            assert (document.getChar(pos.getOffset()) == this.getCloseChar());
            document.addPosition(LinkedModeBracketLevel.POSITION_CATEGORY, pos);
            this.closePos = pos;
        }

        boolean hasOpenClosePositions() {
            return this.openPos != null && this.closePos != null;
        }

        Position getOpenPosition() {
            return this.openPos;
        }

        Position getClosePosition() {
            return this.closePos;
        }

        protected boolean insertCR(int charOffset) throws BadLocationException {
            return true;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return false;
        }

        public boolean matchesOpen(LinkedModeBracketLevel level, int offset, char character) throws BadLocationException {
            return this.getOffset() == offset + 1 && this.getOpenChar() == character && !this.isEscaped(offset);
        }

        public boolean matchesClose(LinkedModeBracketLevel level, int offset, char character) throws BadLocationException {
            return this.getOffset() + this.getLength() == offset && this.getCloseLength() == 1 && this.getCloseChar() == character && level.getPartitionType(this.getOffset()) == level.getPartitionType(offset) && !this.isEscaped(offset);
        }
    }
}

