/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.core.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.StatusDetail;

@NonNullByDefault
public class SourceMessageUtil {
    private static final int FULL_TEXT_LIMIT = 98;
    private static final int MID_TEXT_LIMIT = 53;
    private static final int SHORT_TEXT_LIMIT = 28;
    private static final char SPECIAL_OPEN = '\u276c';
    private static final char SPECIAL_CLOSE = '\u276d';
    private static final String LIMIT_AFFIX = "\u200a\u2026";
    private final StringBuilder tmpBuilder = new StringBuilder();
    private SourceContent sourceContent = (SourceContent)((Object)ObjectUtils.nonNullLateInit());

    public SourceMessageUtil(SourceContent sourceContent) {
        this.setSourceContent(sourceContent);
    }

    public SourceMessageUtil() {
    }

    public void setSourceContent(SourceContent sourceContent) {
        this.sourceContent = (SourceContent)((Object)ObjectUtils.nonNullAssert((Object)((Object)sourceContent)));
    }

    public final StringBuilder getStringBuilder() {
        this.tmpBuilder.setLength(0);
        return this.tmpBuilder;
    }

    private int indexOfSpecial(String text, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            char c = text.charAt(startIndex);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    return startIndex;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++startIndex;
                    break;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 0: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: {
                            return startIndex;
                        }
                    }
                    ++startIndex;
                }
            }
        }
        return -1;
    }

    private String checkQuoteText(String text, int startIndex, int endIndex, boolean limited) {
        int idx = this.indexOfSpecial(text, startIndex, endIndex);
        if (idx == -1) {
            return startIndex == 0 && endIndex == text.length() ? text : text.substring(startIndex, endIndex);
        }
        int lastIdx = 0;
        StringBuilder sb = this.getStringBuilder();
        block11: while (idx < endIndex) {
            char c0 = text.charAt(idx);
            block0 : switch (c0) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    if (idx > lastIdx) {
                        sb.append(text, lastIdx, idx);
                    }
                    sb.append('\u276c');
                    sb.append(Chars.getAsciiControlAbbr((char)c0));
                    sb.append('\u276d');
                    lastIdx = ++idx;
                    break;
                }
                case '\t': {
                    if (idx > lastIdx) {
                        sb.append(text, lastIdx, idx);
                    }
                    sb.append('\u276c');
                    do {
                        sb.append("\u00bb");
                    } while (++idx < endIndex && text.charAt(idx) == '\t');
                    sb.append('\u276d');
                    lastIdx = idx;
                    break;
                }
                case '\n': {
                    if (idx > lastIdx) {
                        sb.append(text, lastIdx, idx);
                    }
                    sb.append("\u276c\u00b6\u276d");
                    lastIdx = ++idx;
                    break;
                }
                case '\r': {
                    if (idx > lastIdx) {
                        sb.append(text, lastIdx, idx);
                    }
                    if (++idx < endIndex && text.charAt(idx) == '\n') {
                        sb.append("\u276c\u00a4\u00b6\u276d");
                    } else {
                        sb.append('\u276c');
                        sb.append(Chars.getAsciiControlAbbr((char)c0));
                        sb.append('\u276d');
                    }
                    lastIdx = ++idx;
                    break;
                }
                default: {
                    switch (Character.getType(c0)) {
                        case 0: 
                        case 15: 
                        case 16: 
                        case 18: {
                            if (idx > lastIdx) {
                                sb.append(text, lastIdx, idx);
                            }
                            sb.append('\u276c');
                            sb.append(Chars.formatCodePoint((int)c0));
                            sb.append('\u276d');
                            lastIdx = ++idx;
                            break block0;
                        }
                        case 19: {
                            char c1;
                            if (idx > lastIdx) {
                                sb.append(text, lastIdx, idx);
                            }
                            if (++idx < endIndex && Character.isHighSurrogate(c0) && Character.isLowSurrogate(c1 = text.charAt(idx))) {
                                sb.append('\u276c');
                                sb.append(Chars.formatCodePoint((int)Character.toCodePoint(c0, c1)));
                                sb.append('\u276d');
                                lastIdx = ++idx;
                                break block0;
                            }
                            if (limited && idx == endIndex) {
                                lastIdx = --idx;
                                break block11;
                            }
                            sb.append("\u276c!\u200a");
                            sb.append(Chars.formatCodePoint((int)c0));
                            sb.append('\u276d');
                            lastIdx = idx;
                            break block0;
                        }
                        default: {
                            ++idx;
                        }
                    }
                }
            }
        }
        if (idx > lastIdx) {
            sb.append(text, lastIdx, idx);
        }
        if (limited) {
            sb.append(LIMIT_AFFIX);
        }
        return sb.toString();
    }

    public String checkQuoteText(String text) {
        return this.checkQuoteText(text, 0, text.length(), false);
    }

    public String checkQuoteText(String text, int limit) {
        if (text.length() > limit) {
            return this.checkQuoteText(text, 0, limit - 3, true);
        }
        return this.checkQuoteText(text, 0, text.length(), false);
    }

    public String checkQuoteText(int startOffset, int endOffset) {
        return this.checkQuoteText(this.sourceContent.getString(startOffset, endOffset), 0, endOffset - startOffset, false);
    }

    public String checkQuoteText(int startOffset, int endOffset, int limit) {
        if (endOffset - startOffset > limit) {
            return this.checkQuoteText(this.sourceContent.getString(startOffset, endOffset + limit - 3), 0, limit - 3, true);
        }
        return this.checkQuoteText(this.sourceContent.getString(startOffset, endOffset), 0, endOffset - startOffset, false);
    }

    public String checkRawText(String text, int limit) {
        if (text.length() > limit) {
            StringBuilder sb = this.getStringBuilder();
            sb.append(text, 0, limit - 3);
            sb.append('\u2026');
            return sb.toString();
        }
        return text;
    }

    public String checkRawText(int startOffset, int endOffset, int limit) {
        if (endOffset - startOffset > limit) {
            StringBuilder sb = this.getStringBuilder();
            this.sourceContent.appendStringTo(sb, startOffset, endOffset + limit - 3);
            sb.append(LIMIT_AFFIX);
            return sb.toString();
        }
        return this.sourceContent.getString(startOffset, endOffset);
    }

    public String checkFullQuoteText(String text) {
        return this.checkQuoteText(text, 98);
    }

    public String getFullQuoteText(AstNode node) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkQuoteText(text, 98);
        }
        return this.checkQuoteText(node.getStartOffset(), node.getEndOffset(), 98);
    }

    public String getFullRawText(AstNode node) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkRawText(text, 98);
        }
        return this.checkRawText(node.getStartOffset(), node.getEndOffset(), 98);
    }

    public String checkMidQuoteText(String text) {
        return this.checkQuoteText(text, 53);
    }

    public String getMidQuoteText(AstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkQuoteText(text, 53);
        }
        return this.checkQuoteText(node.getStartOffset() + offset, node.getEndOffset(), 53);
    }

    public String getMidRawText(AstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkRawText(text, 53);
        }
        return this.checkRawText(node.getStartOffset() + offset, node.getEndOffset(), 53);
    }

    public String checkShortQuoteText(String text) {
        return this.checkQuoteText(text, 28);
    }

    public String getShortQuoteText(AstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkQuoteText(text, 28);
        }
        return this.checkQuoteText(node.getStartOffset() + offset, node.getEndOffset(), 28);
    }

    public String getShortRawText(AstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            return this.checkRawText(text, 28);
        }
        return this.checkRawText(node.getStartOffset() + offset, node.getEndOffset(), 28);
    }

    public String getDetailQuoteText(AstNode node, int offset, StatusDetail detail) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            int begin = detail.getStartOffset() - node.getStartOffset() - offset;
            return this.checkQuoteText(text.substring(begin, begin + detail.getLength()));
        }
        return this.checkQuoteText(detail.getStartOffset(), detail.getEndOffset());
    }

    public int expandSpaceStart(int offset) {
        switch (this.sourceContent.contains(offset - 1) ? (int)this.sourceContent.getChar(offset - 1) : -1) {
            case 9: 
            case 32: {
                return offset - 1;
            }
        }
        return offset;
    }

    public int expandSpaceEnd(int offset) {
        switch (this.sourceContent.contains(offset) ? (int)this.sourceContent.getChar(offset) : -1) {
            case 9: 
            case 32: {
                return offset + 1;
            }
        }
        return offset;
    }
}

