/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.statet.internal.jcommons.status.StringBuilderWriter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class StatusPrinter {
    public static String getSeverityFixWidthString(byte severity) {
        switch (severity) {
            case 0: {
                return "OK     ";
            }
            case 1: {
                return "INFO   ";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR  ";
            }
            case 8: {
                return "CANCEL ";
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public void print(List<Status> statusList, PrintStream output) {
        this.print(statusList, null, output);
    }

    public void print(List<Status> statusList, PrintWriter output) {
        this.print(statusList, null, output);
    }

    public void print(List<Status> statusList, StringBuilder output) {
        PrintWriter writer = new PrintWriter(new StringBuilderWriter(output));
        this.print(statusList, null, writer);
        writer.flush();
    }

    private void print(List<Status> children, @Nullable StringBuilder text, PrintStream output) {
        if (children == null || children.isEmpty()) {
            return;
        }
        if (text == null) {
            text = new StringBuilder("(");
        } else {
            text.append('.');
        }
        int baseTextLength = text.length();
        int i = 0;
        while (i < children.size()) {
            Status child = children.get(i);
            text.setLength(baseTextLength);
            text.append(i + 1);
            int iTextLength = text.length();
            text.append(") ");
            text.append(StatusPrinter.getSeverityFixWidthString(child.getSeverity()));
            text.append(" [");
            text.append(child.getBundleId());
            text.append(':');
            text.append(child.getCode());
            text.append("] ");
            text.append(child.getMessage());
            output.println(text);
            Throwable exception = child.getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            text.setLength(iTextLength);
            this.print(child.getChildren(), text, output);
            ++i;
        }
    }

    private void print(List<Status> children, @Nullable StringBuilder text, PrintWriter output) {
        if (children == null || children.isEmpty()) {
            return;
        }
        if (text == null) {
            text = new StringBuilder("(");
        } else {
            text.append('.');
        }
        int baseTextLength = text.length();
        int i = 0;
        while (i < children.size()) {
            Status child = children.get(i);
            text.setLength(baseTextLength);
            text.append(i + 1);
            int iTextLength = text.length();
            text.append(") ");
            text.append(StatusPrinter.getSeverityFixWidthString(child.getSeverity()));
            text.append(" [");
            text.append(child.getBundleId());
            text.append(':');
            text.append(child.getCode());
            text.append("] ");
            text.append(child.getMessage());
            output.println(text);
            Throwable exception = child.getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            text.setLength(iTextLength);
            this.print(child.getChildren(), text, output);
            ++i;
        }
    }
}

