/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.Builder;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;

@NonNullByDefault
public class ProcessConfigBuilder
implements Builder<ProcessConfig> {
    private String commandString = "";
    private final Map<String, String> environmentVars = new HashMap<String, String>();
    private @Nullable OutputStream ioOutputStream;
    private @Nullable InputStream ioInputStream;

    public String getCommandString() {
        return this.commandString;
    }

    public ProcessConfigBuilder setCommandString(String command) {
        this.commandString = ObjectUtils.nonNullAssert(command);
        return this;
    }

    public Map<String, String> getEnvironmentVars() {
        return this.environmentVars;
    }

    public ProcessConfigBuilder addEnvironmentVar(String name, String value) {
        this.environmentVars.put(name, value);
        return this;
    }

    public ProcessConfigBuilder addEnvironmentVars(Map<String, String> vars) {
        this.environmentVars.putAll(vars);
        return this;
    }

    public @Nullable InputStream getInputStream() {
        return this.ioInputStream;
    }

    public ProcessConfigBuilder setInputStream(@Nullable InputStream in) {
        this.ioInputStream = in;
        return this;
    }

    public @Nullable OutputStream getOutputStream() {
        return this.ioOutputStream;
    }

    public ProcessConfigBuilder setOutputStream(@Nullable OutputStream out) {
        this.ioOutputStream = out;
        return this;
    }

    @Override
    public ProcessConfig build() {
        return new ProcessConfig(this.commandString, this.environmentVars, this.ioInputStream, this.ioOutputStream);
    }
}

