/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class OpenSshConfigUtils {
    public static final String DATA_DIR_NAME = ".ssh";
    public static final String CONFIG_FILE_NAME = "config";
    public static final String KNOWN_HOSTS_FILE_NAME = "known_hosts";
    private static final Pattern SHORT_SSH_FORMAT = Pattern.compile("[\\w-.]+(?:@[\\w-.]+)?(?::\\d+)?");

    public static URI createSshUri(String s) throws URISyntaxException {
        URI uri;
        if (SHORT_SSH_FORMAT.matcher((CharSequence)(s = ((String)s).trim())).matches()) {
            s = "ssh://" + (String)s;
        }
        if (!UriUtils.isScheme((uri = new URI((String)s)).getScheme(), "ssh")) {
            throw new URISyntaxException((String)s, "URI with scheme 'ssh' expected");
        }
        return uri;
    }

    public static boolean parseTrue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        switch (value = value.trim()) {
            case "on": 
            case "yes": 
            case "true": {
                return true;
            }
        }
        return false;
    }

    public static boolean parseNone(@Nullable String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "none": {
                return true;
            }
        }
        return false;
    }

    public static int parsePositiveInt(@Nullable String value) {
        if (value == null) {
            return -1;
        }
        value = value.trim();
        try {
            return Integer.parseUnsignedInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static @Nullable Duration parseDuration(@Nullable String value) {
        if (value == null) {
            return null;
        }
        @Nullable Duration duration = null;
        value = value.trim();
        int length = value.length();
        int idx = 0;
        while (idx < length) {
            int tValue;
            int tOffset = idx;
            char c = value.charAt(idx);
            if (c == '+') {
                ++idx;
            }
            while (idx < length) {
                if ((c = value.charAt(idx++)) >= '0' && c <= '9') continue;
                --idx;
                break;
            }
            try {
                tValue = Integer.parseInt(value, tOffset, idx, 10);
            }
            catch (NumberFormatException e) {
                return duration;
            }
            int tUnit = 115;
            if (idx < length) {
                if ((tUnit = (int)value.charAt(idx++)) == 32) {
                    tUnit = 115;
                } else if (idx < length && value.charAt(idx) == ' ') {
                    ++idx;
                }
            }
            if (duration == null) {
                duration = Duration.ZERO;
            }
            switch (tUnit) {
                case 83: 
                case 115: {
                    duration = duration.plusSeconds(tValue);
                    break;
                }
                case 77: 
                case 109: {
                    duration = duration.plusMinutes(tValue);
                    break;
                }
                case 72: 
                case 104: {
                    duration = duration.plusHours(tValue);
                    break;
                }
                case 68: 
                case 100: {
                    duration = duration.plusDays(tValue);
                    break;
                }
                case 87: 
                case 119: {
                    duration = duration.plusDays(tValue * 7);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return duration;
    }

    public static List<URI> parseProxyJump(String value) throws URISyntaxException {
        @NonNull String[] hops = value.split(",");
        ArrayList<URI> result = new ArrayList<URI>();
        String[] stringArray = hops;
        int n = hops.length;
        int n2 = 0;
        while (n2 < n) {
            String hop = stringArray[n2];
            URI to = OpenSshConfigUtils.createSshUri(hop);
            String path = to.getPath();
            if (path != null && !path.isEmpty()) {
                throw new URISyntaxException(hop, "URI without path component expected");
            }
            result.add(to);
            ++n2;
        }
        return result;
    }

    private OpenSshConfigUtils() {
    }
}

